/*
 * Decompiled with CFR 0.152.
 */
package view;

import action.Action;
import algorithm.Algorithm;
import error.Error;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.LinkedList;
import structure.ObservabileVariable;
import structure.Using;
import utils.Utils;
import viewer.AbstractViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractView
implements Serializable {
    private int width;
    private int height;
    private int centerX;
    private int centerY;
    private double zoom = 1.0;
    private Thread labelEraser;
    private String topLabel = "";
    private String bottomLabel = "";
    protected AbstractViewer viewer;
    protected int currentIndex;
    protected Algorithm algorithm;
    protected Action currentAction;
    protected LinkedList<Action> actions;
    protected LinkedList<Using> usedStructures;
    protected boolean processing;
    protected static final RenderingHints HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    protected static Color colorCmp = new Color(100, 20, 20);
    protected static Color colorSet = new Color(100, 100, 20);
    protected static Color colorGet = new Color(100, 20, 100);
    protected static Color colorSelected = new Color(20, 100, 20);

    public String algorithmName() {
        return this.algorithm.getClass().getSimpleName();
    }

    public void processCurrentAction(int pause) throws InterruptedException {
        this.processing = true;
        int ind = this.currentIndex < 0 ? 0 : this.currentIndex;
        this.processing = false;
    }

    public abstract void paintStructure(Graphics2D var1);

    public abstract void loadStructure() throws Error;

    protected abstract void additionalActionsNext() throws Error;

    protected abstract void additionalActionsPrevious() throws Error;

    protected abstract void paintAbstract(Graphics2D var1);

    public ObservabileVariable[] getCurrentStructures() {
        if (this.actions.size() > 0) {
            return this.currentAction.getStructs();
        }
        return null;
    }

    public void interrupt() {
        this.processing = false;
    }

    public abstract String description();

    public void drawLabel(String label, Graphics2D g2D, boolean up) {
        if (label == null || label.equals("")) {
            return;
        }
        Font font = new Font("Tahoma", 0, 24);
        Rectangle2D textBounds = Utils.getTextBounds(label, font, g2D);
        Font oldF = g2D.getFont();
        Paint oldP = g2D.getPaint();
        g2D.setFont(font);
        g2D.setPaint(Color.DARK_GRAY);
        if (up) {
            g2D.drawString(label, (int)((double)this.width - textBounds.getWidth()) - 10, (int)textBounds.getHeight() + 10);
        } else {
            g2D.drawString(label, (int)((double)this.width - textBounds.getWidth()) - 10, (int)((double)this.height - textBounds.getHeight() / 2.0));
        }
        g2D.setPaint(oldP);
        g2D.setFont(oldF);
    }

    public boolean nextStep() throws Error {
        if (this.actions == null) {
            return true;
        }
        int size = this.getActions().size() - 1;
        if (this.currentIndex < size) {
            if (this.processing) {
                this.interrupt();
            } else {
                this.currentAction = this.actions.get(++this.currentIndex);
                this.viewer.notifySimulationListeners();
            }
        } else {
            return true;
        }
        this.additionalActionsNext();
        return false;
    }

    public boolean previousStep() throws Error {
        if (this.actions == null) {
            return true;
        }
        if (this.currentIndex > 0) {
            if (this.processing) {
                this.interrupt();
            } else {
                this.currentAction = this.actions.get(--this.currentIndex);
                this.viewer.notifySimulationListeners();
            }
        } else {
            return true;
        }
        this.additionalActionsPrevious();
        return false;
    }

    public void paint(Graphics2D g2D) {
        AffineTransform old = g2D.getTransform();
        AffineTransform tf = new AffineTransform();
        tf.translate(this.centerX, this.centerY);
        tf.scale(this.getZoom(), this.getZoom());
        g2D.transform(tf);
        this.paintAbstract(g2D);
        g2D.setTransform(old);
        this.drawLabel(this.topLabel, g2D, true);
        this.drawLabel(this.bottomLabel, g2D, false);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) throws Error {
        this.algorithm = algorithm;
        this.reset();
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(Action currentAction) {
        this.currentAction = currentAction;
    }

    public void reset() throws Error {
        this.currentIndex = -1;
        this.actions = this.algorithm.getActions();
        if (this.actions.size() > 0) {
            this.currentAction = this.actions.get(0);
        }
        this.usedStructures = this.algorithm.using();
        this.loadStructure();
    }

    public LinkedList<Action> getActions() {
        return this.actions;
    }

    public void setActions(LinkedList<Action> actions) {
        this.actions = actions;
    }

    public LinkedList<Using> getUsedStructures() {
        return this.usedStructures;
    }

    public void setUsedStructures(LinkedList<Using> usedStructures) {
        this.usedStructures = usedStructures;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.setTopLabel((int)(100.0 * zoom) + "%");
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public AbstractViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(AbstractViewer viewer) {
        this.viewer = viewer;
        viewer.setView(this);
        this.width = viewer.getWidth();
        this.height = viewer.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) throws Error {
        this.currentIndex = currentIndex;
        if (currentIndex >= 0 && currentIndex < this.actions.size()) {
            this.currentAction = this.actions.get(currentIndex);
        }
        this.usedStructures = this.algorithm.using();
        this.loadStructure();
    }

    private void delayTopLabel() {
        if (this.labelEraser != null) {
            this.labelEraser.stop();
        }
        this.labelEraser = new LabelEraserThread();
        this.labelEraser.start();
    }

    public String getTopLabel() {
        return this.topLabel;
    }

    public void setTopLabel(String topLabel) {
        this.topLabel = topLabel;
        this.viewer.repaint();
        this.delayTopLabel();
    }

    public String getBottomLabel() {
        return this.bottomLabel;
    }

    public void setBottomLabel(String bottomLabel) {
        this.bottomLabel = bottomLabel;
    }

    private class LabelEraserThread
    extends Thread
    implements Serializable {
        private LabelEraserThread() {
        }

        public void run() {
            try {
                Thread.sleep(2000L);
                AbstractView.this.topLabel = "";
                AbstractView.this.viewer.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

