/*
 * Decompiled with CFR 0.152.
 */
package structure;

import algorithm.Algorithm;
import error.Error;
import java.io.Serializable;
import structure.ObservabileVariable;

public class ObservabileSingleLinkedList
extends ObservabileVariable {
    private ListElem listFirst;
    private ListElem listLast;
    private int numOfElem;

    public ObservabileSingleLinkedList(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public String readElem(int ind) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1010);
        }
        ListElem tmp = this.listFirst;
        for (int i = 0; i < ind; ++i) {
            tmp = tmp.next;
        }
        return tmp.value;
    }

    public void addFirst(String value) {
        if (this.listFirst == null) {
            this.listFirst = this.listLast = new ListElem(value);
        } else {
            ListElem tmp = new ListElem(value);
            tmp.next = this.listFirst;
            this.listFirst = tmp;
        }
        ++this.numOfElem;
    }

    public void addLast(String value) {
        if (this.listFirst == null) {
            this.listFirst = this.listLast = new ListElem(value);
        } else {
            this.listLast = this.listLast.next = new ListElem(value);
        }
        ++this.numOfElem;
    }

    public void addMiddle(String value, int ind) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1010);
        }
        ListElem newElem = new ListElem(value);
        ListElem tmp = this.listFirst;
        for (int i = 0; i < ind; ++i) {
            tmp = tmp.next;
        }
        newElem.next = tmp.next;
        tmp.next = newElem;
        if (this.listLast == tmp) {
            this.listLast = newElem;
        }
        ++this.numOfElem;
    }

    public void remFirst() throws Error {
        if (this.listFirst == null) {
            throw new Error(1010);
        }
        if (this.numOfElem == 1) {
            this.listLast = null;
            this.listFirst = null;
        } else {
            ListElem tmp = this.listFirst;
            this.listFirst = this.listFirst.next;
            tmp.next = null;
        }
        --this.numOfElem;
    }

    public void remLast() throws Error {
        if (this.listFirst == null) {
            throw new Error(1010);
        }
        if (this.numOfElem == 1) {
            this.listLast = null;
            this.listFirst = null;
        } else {
            ListElem tmp = this.listFirst;
            for (int i = 0; i < this.numOfElem - 2; ++i) {
                tmp = tmp.next;
            }
            tmp.next = null;
        }
        --this.numOfElem;
    }

    public void remMiddle(int ind) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1010);
        }
        if (ind == 0) {
            this.remFirst();
        } else if (ind == this.numOfElem - 1) {
            this.remLast();
        } else {
            ListElem tmp = this.listFirst;
            for (int i = 0; i < ind - 1; ++i) {
                tmp = tmp.next;
            }
            ListElem t = tmp.next;
            tmp.next = t.next;
            t.next = null;
        }
        --this.numOfElem;
    }

    public Integer searchElem(String value) {
        ListElem tmp = this.listFirst;
        for (int i = 0; i < this.numOfElem; ++i) {
            if (tmp.value.equals(value)) {
                return i;
            }
            tmp = tmp.next;
        }
        return null;
    }

    public ObservabileVariable clone() {
        try {
            ObservabileSingleLinkedList struct = new ObservabileSingleLinkedList(this.alg, this.structureID);
            for (int i = 0; i < this.numOfElem; ++i) {
                ++struct.numOfElem;
                if (struct.listFirst == null) {
                    struct.listFirst = struct.listLast = new ListElem(this.readElem(i));
                    continue;
                }
                struct.listLast = struct.listLast.next = new ListElem(this.readElem(i));
            }
            return struct;
        }
        catch (Error error) {
            return null;
        }
    }

    public String toString() {
        String str = "";
        ListElem tmp = this.listFirst;
        while (tmp != null) {
            str = str + tmp.value;
            if (tmp.next != null) {
                str = str + " ";
            }
            tmp = tmp.next;
        }
        return str;
    }

    public int getNumOfElem() {
        return this.numOfElem;
    }

    public void setNumOfElem(int numOfElem) {
        this.numOfElem = numOfElem;
    }

    private class ListElem
    implements Serializable {
        String value;
        ListElem next;

        ListElem(String value) {
            this.value = value;
        }
    }
}

