/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActBST;
import algorithm.Algorithm;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;

public class ObservabileHuffman
extends ObservabileBinaryTree {
    public static final int HuffmanCode = -13;
    LinkedList<ObservabileBinaryTree.Node> queue = new LinkedList();

    public void insertQueue(String name, int value) {
        ObservabileBinaryTree.Node n = new ObservabileBinaryTree.Node(value, 0);
        if (!name.equals("")) {
            n.insertAttr(name, -13);
        }
        this.queue.add(n);
    }

    public void insertNodeQueue(ObservabileBinaryTree.Node n) {
        this.queue.add(n);
    }

    public ObservabileBinaryTree.Node removeFromQueue() {
        if (this.queue.size() == 0) {
            return null;
        }
        ObservabileBinaryTree.Node n = this.queue.getFirst();
        int ind = 0;
        for (int i = 1; i < this.queue.size(); ++i) {
            if (this.queue.get((int)i).value >= n.value) continue;
            n = this.queue.get(i);
            ind = i;
        }
        this.queue.remove(ind);
        return n;
    }

    public ObservabileHuffman(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public void HuffmanInsert(String name, String value) {
        int val = 0;
        try {
            val = Integer.parseInt(value);
            this.insertQueue(name, val);
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
    }

    public void makeHuffman() {
        ObservabileBinaryTree.Node parent = null;
        int len = this.queue.size() - 1;
        for (int i = 0; i < len; ++i) {
            ObservabileBinaryTree.Node left = this.removeFromQueue();
            ObservabileBinaryTree.Node right = this.removeFromQueue();
            parent = new ObservabileBinaryTree.Node(left.value + right.value, 0);
            parent.left = left;
            parent.right = right;
            this.insertNodeQueue(parent);
        }
        if (len > 0) {
            this.root = parent;
        } else if (len == 0) {
            this.root = this.removeFromQueue();
        }
        this.updateNodeLevels();
        this.alg.getActions().add(new ActBST("Huffman", "Whole", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, this.root.id));
    }
}

