/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActGraph;
import algorithm.Algorithm;
import error.Error;
import java.util.HashSet;
import java.util.LinkedList;
import structure.ObservabileVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservabileGraph
extends ObservabileVariable {
    private boolean[][] connectionMatrix = null;
    private String[][] weightMatrix = null;
    private int numOfElems;
    private LinkedList<String> nodes = new LinkedList();
    private LinkedList<Status> nodesStatus = new LinkedList();
    private Status[][] branchStatusMatrix = null;

    public ObservabileGraph(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public ObservabileGraph addNode(String name) {
        boolean[][] tmp1 = new boolean[this.numOfElems + 1][this.numOfElems + 1];
        String[][] tmp2 = new String[this.numOfElems + 1][this.numOfElems + 1];
        Status[][] tmp3 = new Status[this.numOfElems + 1][this.numOfElems + 1];
        for (int i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                tmp1[i][j] = this.connectionMatrix[i][j];
                tmp2[i][j] = this.weightMatrix[i][j];
                tmp3[i][j] = this.branchStatusMatrix[i][j];
            }
        }
        this.connectionMatrix = tmp1;
        this.weightMatrix = tmp2;
        this.branchStatusMatrix = tmp3;
        ++this.numOfElems;
        this.nodes.add(name);
        this.nodesStatus.add(Status.DEFAULT);
        return this;
    }

    public ObservabileGraph removeNode(String name) {
        if (this.nodes.indexOf(name) == -1) {
            throw new NoSuchFieldError();
        }
        boolean[][] tmp1 = new boolean[this.numOfElems - 1][this.numOfElems - 1];
        String[][] tmp2 = new String[this.numOfElems - 1][this.numOfElems - 1];
        Status[][] tmp3 = new Status[this.numOfElems - 1][this.numOfElems - 1];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.numOfElems; ++i) {
            y = 0;
            if (i == this.nodes.indexOf(name)) continue;
            for (int j = 0; j < this.numOfElems; ++j) {
                if (j == this.nodes.indexOf(name)) continue;
                tmp1[x][y] = this.connectionMatrix[i][j];
                tmp2[x][y] = this.weightMatrix[i][j];
                tmp3[x][y] = this.branchStatusMatrix[i][j];
                ++y;
            }
            ++x;
        }
        this.connectionMatrix = tmp1;
        this.weightMatrix = tmp2;
        this.branchStatusMatrix = tmp3;
        --this.numOfElems;
        this.nodesStatus.remove(this.nodes.indexOf(name));
        this.nodes.remove(name);
        return this;
    }

    public ObservabileGraph addBranch(String node1, String node2) {
        return this.addBranch(node1, node2, "0");
    }

    public ObservabileGraph addBranch(String node1, String node2, String weight) {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new NoSuchFieldError();
        }
        int ind1 = this.nodes.indexOf(node1);
        int ind2 = this.nodes.indexOf(node2);
        this.connectionMatrix[ind1][ind2] = true;
        this.weightMatrix[ind1][ind2] = weight;
        return this;
    }

    public ObservabileGraph removeBranch(String node1, String node2) throws Error {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new Error(1008);
        }
        int ind1 = this.nodes.indexOf(node1);
        int ind2 = this.nodes.indexOf(node2);
        this.connectionMatrix[ind1][ind2] = false;
        this.weightMatrix[ind1][ind2] = "0";
        return this;
    }

    public ObservabileGraph writeBranchWeight(String node1, String node2, String weight) throws Error {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new Error(1008);
        }
        int ind1 = this.nodes.indexOf(node1);
        int ind2 = this.nodes.indexOf(node2);
        this.weightMatrix[ind1][ind2] = weight;
        return this;
    }

    public ObservabileGraph writeBranchWeight(int ind1, int ind2, String weight) throws Error {
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1007);
        }
        this.weightMatrix[ind1][ind2] = weight;
        return this;
    }

    public ObservabileGraph setBranchWeight(String node1, String node2, String weight) throws Error {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new Error(1008);
        }
        int ind1 = this.nodes.indexOf(node1);
        int ind2 = this.nodes.indexOf(node2);
        this.weightMatrix[ind1][ind2] = weight;
        this.alg.getActions().add(new ActGraph("SetBranch weight between nodes " + this.nodes.get(ind1) + " and " + this.nodes.get(ind2), this.alg.getCloneStructures(), 8, new int[]{this.structureID}, this.nodes.get(ind1), this.nodes.get(ind2)));
        return this;
    }

    public ObservabileGraph setBranchWeight(int ind1, int ind2, String weight) throws Error {
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1007);
        }
        this.weightMatrix[ind1][ind2] = weight;
        this.alg.getActions().add(new ActGraph("SetBranch weight between nodes " + this.nodes.get(ind1) + " and " + this.nodes.get(ind2), this.alg.getCloneStructures(), 8, new int[]{this.structureID}, this.nodes.get(ind1), this.nodes.get(ind2)));
        return this;
    }

    public void selectNode(int ind) throws Error {
        if (ind > this.numOfElems - 1) {
            throw new Error(1007);
        }
        if (this.nodesStatus.get(ind) == Status.FINAL) {
            this.nodesStatus.set(ind, Status.FINAL_SELECTED);
        } else {
            this.nodesStatus.set(ind, Status.SELECTED);
        }
        this.alg.getActions().add(new ActGraph("SelectNode " + this.nodes.get(ind), this.alg.getCloneStructures(), 2, new int[]{this.structureID}, this.nodes.get(ind)));
    }

    public void deselectNode(int ind) throws Error {
        if (ind > this.numOfElems - 1) {
            throw new Error(1007);
        }
        if (this.nodesStatus.get(ind) == Status.FINAL_SELECTED) {
            this.nodesStatus.set(ind, Status.FINAL);
        } else {
            this.nodesStatus.set(ind, Status.DEFAULT);
        }
        this.alg.getActions().add(new ActGraph("DeselectNode " + this.nodes.get(ind), this.alg.getCloneStructures(), 4, new int[]{this.structureID}, this.nodes.get(ind)));
    }

    public void selectBranch(String node1, String node2) throws Error {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new Error(1008);
        }
        this.branchStatusMatrix[this.nodes.indexOf((Object)node1)][this.nodes.indexOf((Object)node2)] = Status.SELECTED;
        if (this.connectionMatrix[this.nodes.indexOf(node1)][this.nodes.indexOf(node2)]) {
            this.branchStatusMatrix[this.nodes.indexOf((Object)node2)][this.nodes.indexOf((Object)node1)] = Status.SELECTED;
        }
        this.alg.getActions().add(new ActGraph("SelectBranch between nodes " + node1 + " and " + node2, this.alg.getCloneStructures(), 3, new int[]{this.structureID}, node1, node2));
    }

    public void deselectBranch(String node1, String node2) throws Error {
        if (this.nodes.indexOf(node1) == -1 || this.nodes.indexOf(node2) == -1) {
            throw new Error(1008);
        }
        this.branchStatusMatrix[this.nodes.indexOf((Object)node1)][this.nodes.indexOf((Object)node2)] = Status.DEFAULT;
        if (this.connectionMatrix[this.nodes.indexOf(node1)][this.nodes.indexOf(node2)]) {
            this.branchStatusMatrix[this.nodes.indexOf((Object)node2)][this.nodes.indexOf((Object)node1)] = Status.DEFAULT;
        }
        this.alg.getActions().add(new ActGraph("DeselectBranch between nodes " + node1 + " and " + node2, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, node1, node2));
    }

    public String readNeighbour(int ind, int neigh) throws Error {
        if (ind > this.numOfElems - 1 || neigh > this.numOfElems - 1) {
            throw new Error(1007);
        }
        if (this.connectionMatrix[ind][neigh]) {
            return this.readNode(neigh);
        }
        return null;
    }

    public String readNode(int ind) throws Error {
        if (ind > this.numOfElems - 1) {
            throw new Error(1008);
        }
        return this.nodes.get(ind);
    }

    public int readNodeIndex(String node) throws Error {
        for (int i = 0; i < this.numOfElems; ++i) {
            if (!this.nodes.get(i).equals(node)) continue;
            return i;
        }
        throw new Error(1008);
    }

    public String getNode(int ind) throws Error {
        if (ind > this.numOfElems - 1) {
            throw new Error(1007);
        }
        this.alg.getActions().add(new ActGraph("AccessNode " + this.nodes.get(ind), this.alg.getCloneStructures(), 0, new int[]{this.structureID}, this.nodes.get(ind)));
        return this.nodes.get(ind);
    }

    public void finalNode(String name) throws Error {
        if (this.nodes.indexOf(name) == -1) {
            throw new Error(1008);
        }
        this.nodesStatus.set(this.nodes.indexOf(name), Status.FINAL);
        this.alg.getActions().add(new ActGraph("FinalNode " + name, this.alg.getCloneStructures(), 6, new int[]{this.structureID}, name));
    }

    public void finalBranch(String name1, String name2) throws Error {
        if (this.nodes.indexOf(name1) == -1 || this.nodes.indexOf(name2) == -1) {
            throw new Error(1008);
        }
        this.branchStatusMatrix[this.nodes.indexOf((Object)name1)][this.nodes.indexOf((Object)name2)] = Status.FINAL;
        if (this.connectionMatrix[this.nodes.indexOf(name1)][this.nodes.indexOf(name2)]) {
            this.branchStatusMatrix[this.nodes.indexOf((Object)name2)][this.nodes.indexOf((Object)name1)] = Status.FINAL;
        }
        this.alg.getActions().add(new ActGraph("FinalBranch between nodes " + name1 + " and " + name2, this.alg.getCloneStructures(), 7, new int[]{this.structureID}, name1, name2));
    }

    public String readWeight(int ind1, int ind2) throws Error {
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1007);
        }
        return this.weightMatrix[ind1][ind2];
    }

    public String readWeight(String node1, String node2) throws Error {
        int ind1 = this.readNodeIndex(node1);
        int ind2 = this.readNodeIndex(node2);
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1007);
        }
        return this.weightMatrix[ind1][ind2];
    }

    public String getWeight(int ind1, int ind2) throws Error {
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1007);
        }
        this.alg.getActions().add(new ActGraph("AccessBranch between nodes " + this.nodes.get(ind1) + " and " + this.nodes.get(ind2), this.alg.getCloneStructures(), 1, new int[]{this.structureID}, this.nodes.get(ind1), this.nodes.get(ind2)));
        return this.weightMatrix[ind1][ind2];
    }

    public String getWeight(String node1, String node2) throws Error {
        int ind1 = this.readNodeIndex(node1);
        int ind2 = this.readNodeIndex(node2);
        if (ind1 > this.numOfElems - 1 || ind2 > this.numOfElems - 1) {
            throw new Error(1008);
        }
        this.alg.getActions().add(new ActGraph("AccessBranch between nodes " + node1 + " and " + node2, this.alg.getCloneStructures(), 1, new int[]{this.structureID}, node1, node2));
        return this.weightMatrix[ind1][ind2];
    }

    public void refreshGraph() {
        this.alg.getActions().add(new ActGraph("RefreshGraph", this.alg.getCloneStructures(), 9, new int[]{this.structureID}, null, null));
    }

    public boolean containsNode(String name) {
        for (int i = 0; i < this.numOfElems; ++i) {
            if (!this.nodes.get(i).equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean equalNodes(ObservabileGraph g) {
        if (this.numOfElems != g.numOfElems) {
            return false;
        }
        HashSet<String> g1 = new HashSet<String>();
        HashSet<String> g2 = new HashSet<String>();
        for (int i = 0; i < this.numOfElems; ++i) {
            g1.add(this.nodes.get(i));
            g2.add(g.nodes.get(i));
        }
        return g1.equals(g2);
    }

    public void resetWeightMatrixToZero() {
        for (int i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                this.weightMatrix[i][j] = "0";
            }
        }
    }

    public void resetNodeAndBranchStatus() {
        int i;
        for (i = 0; i < this.nodesStatus.size(); ++i) {
            this.nodesStatus.set(i, Status.DEFAULT);
        }
        for (i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                this.branchStatusMatrix[i][j] = Status.DEFAULT;
            }
        }
    }

    public boolean isAllBranchTwoSided() {
        for (int i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                if (this.connectionMatrix[i][j] == this.connectionMatrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConnected() {
        int i;
        HashSet[] T = new HashSet[this.numOfElems];
        for (i = 0; i < this.numOfElems; ++i) {
            T[i] = new HashSet();
            T[i].add(this.nodes.get(i));
        }
        for (i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                if (!this.connectionMatrix[i][j]) continue;
                for (int m = 0; m < this.numOfElems; ++m) {
                    for (int n = 0; n < this.numOfElems; ++n) {
                        if (!T[m].contains(this.nodes.get(i)) || !T[n].contains(this.nodes.get(j)) || m == n) continue;
                        T[m].addAll(T[n]);
                        T[n].removeAll(T[n]);
                    }
                }
            }
        }
        for (i = 1; i < this.numOfElems; ++i) {
            if (T[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public LinkedList<LinkedList<String>> findAllPaths() throws Error {
        boolean chng;
        if (this.numOfElems <= 1) {
            throw new Error(1012);
        }
        LinkedList<LinkedList<String>> list = new LinkedList<LinkedList<String>>();
        LinkedList<String> tmp = new LinkedList<String>();
        tmp.add(this.nodes.get(0));
        list.add(tmp);
        do {
            chng = false;
            for (int i = 0; i < list.size(); ++i) {
                String node = (String)((LinkedList)list.get(i)).getLast();
                if (node.equals(this.nodes.get(this.numOfElems - 1))) continue;
                int ind = this.readNodeIndex(node);
                for (int j = 0; j < this.getNumOfElems(); ++j) {
                    String str = this.readNeighbour(ind, j);
                    if (str == null) continue;
                    LinkedList newList = (LinkedList)list.get(i).clone();
                    if (newList.contains(str)) {
                        throw new Error(1009);
                    }
                    newList.add(str);
                    list.add(newList);
                }
                list.remove(i);
                chng = true;
            }
        } while (chng);
        return list;
    }

    public boolean allBranchesNotNegative() {
        for (int i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                if (!this.connectionMatrix[i][j] || Integer.parseInt(this.weightMatrix[i][j]) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ObservabileVariable clone() {
        int i;
        ObservabileGraph struct = new ObservabileGraph(this.alg, this.structureID);
        for (i = 0; i < this.numOfElems; ++i) {
            struct.addNode(this.nodes.get(i));
        }
        struct.nodesStatus = new LinkedList<Status>(this.nodesStatus);
        for (i = 0; i < this.numOfElems; ++i) {
            for (int j = 0; j < this.numOfElems; ++j) {
                if (this.connectionMatrix[i][j]) {
                    struct.addBranch(this.nodes.get(i), this.nodes.get(j), this.weightMatrix[i][j]);
                }
                struct.branchStatusMatrix[i][j] = this.branchStatusMatrix[i][j];
            }
        }
        return struct;
    }

    @Override
    public String toString() {
        int i;
        String str = "  ";
        for (i = 0; i < this.numOfElems; ++i) {
            str = str + this.nodes.get(i);
            str = i != this.numOfElems - 1 ? str + " " : str + "\n";
        }
        for (i = 0; i < this.numOfElems; ++i) {
            int j;
            str = str + this.nodes.get(i) + " ";
            for (j = 0; j < this.numOfElems; ++j) {
                str = str + (this.connectionMatrix[i][j] ? "T" : "F");
                if (j == this.numOfElems - 1) continue;
                str = str + " ";
            }
            str = str + "   ";
            for (j = 0; j < this.numOfElems; ++j) {
                str = str + String.format("%3s", this.weightMatrix[i][j]);
                if (j == this.numOfElems - 1) continue;
                str = str + " ";
            }
            str = str + "\n";
        }
        return str;
    }

    public boolean[][] getConnectionMatrix() {
        return this.connectionMatrix;
    }

    public String[][] getWeightMatrix() {
        return this.weightMatrix;
    }

    public int getNumOfElems() {
        return this.numOfElems;
    }

    public LinkedList<String> getNodes() {
        return this.nodes;
    }

    public LinkedList<Status> getNodesStatus() {
        return this.nodesStatus;
    }

    public Status[][] getBranchStatusMatrix() {
        return this.branchStatusMatrix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DEFAULT,
        FINAL,
        SELECTED,
        FINAL_SELECTED;

    }
}

