/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActBST;
import algorithm.Algorithm;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;
import structure.ObservabileHuffman;

public class ObservabileDynamicHuffman
extends ObservabileHuffman {
    ObservabileBinaryTree.Node nyt;

    public ObservabileDynamicHuffman(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public void HuffmanInsert(String value) {
        ObservabileBinaryTree.Node novi = this.root;
        String transmit = "";
        if (this.root == null) {
            ObservabileBinaryTree.Node temp = new ObservabileBinaryTree.Node(1, 1);
            ObservabileBinaryTree.Node koren = new ObservabileBinaryTree.Node(1, 0);
            ObservabileBinaryTree.Node n = new ObservabileBinaryTree.Node(0, 1);
            temp.insertAttr(value, -13);
            n.insertAttr("NYT", -13);
            koren.left = this.nyt = n;
            koren.right = temp;
            this.root = koren;
            transmit = value;
            this.updateNodeLevels();
            this.root.value = this.root.left.value + this.root.right.value;
            this.alg.getActions().add(new ActBST("Huffman Insert " + value, "Transmit: " + transmit, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, this.root.id));
        } else if (this.getCode(value).equals("")) {
            this.getCodeAct(value);
            transmit = this.getCode("NYT") + value;
            novi = this.nyt;
            novi.removeAttr("NYT");
            ObservabileBinaryTree.Node temp = new ObservabileBinaryTree.Node(1, 1);
            temp.insertAttr(value, -13);
            novi.right = temp;
            temp = new ObservabileBinaryTree.Node(0, 1);
            temp.insertAttr("NYT", -13);
            novi.left = temp;
            this.nyt = temp;
            this.updateNodeLevels();
            this.alg.getActions().add(new ActBST("Huffman Insert " + value, "Transmit: " + transmit, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, novi.id));
            this.updateTree(novi, true);
            this.updateNodeLevels();
            this.root.value = this.root.left.value + this.root.right.value;
            this.alg.getActions().add(new ActBST("Huffman Insert " + value, "Transmit: " + transmit, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, novi.id));
        } else {
            ObservabileBinaryTree.Node n;
            transmit = this.getCodeAct(value);
            novi = n = this.findNode(value);
            transmit = this.getCode(value);
            this.updateTree(n, false);
            this.updateTree(this.findParent(n), true);
            this.updateNodeLevels();
            this.root.value = this.root.left.value + this.root.right.value;
            this.alg.getActions().add(new ActBST("Huffman Insert " + value, "Transmit: " + transmit, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, novi.id));
        }
    }

    public String getCode(String name) {
        String str = "";
        ObservabileBinaryTree.Node node = this.findNode(name);
        if (node == null) {
            return "";
        }
        while (node != this.root) {
            ObservabileBinaryTree.Node parent = this.findParent(node);
            str = parent.left == node ? "0" + str : "1" + str;
            node = parent;
        }
        return str;
    }

    public String getCode(ObservabileBinaryTree.Node n) {
        String str = "";
        ObservabileBinaryTree.Node temp = n;
        while (temp != this.root) {
            str = this.findParent((ObservabileBinaryTree.Node)temp).left == temp ? "0" + str : "1" + str;
            temp = this.findParent(temp);
        }
        return str;
    }

    public String getCodeAct(String name) {
        String str = this.getCode(name);
        String transmit = "";
        ObservabileBinaryTree.Node node = this.findNode(name);
        ObservabileBinaryTree.Node temp = this.root;
        if (str.equals("")) {
            str = this.getCode("NYT");
            node = this.nyt;
        }
        while (temp != node) {
            transmit = transmit + str.substring(0, 1);
            this.alg.getActions().add(new ActBST("Insert " + name, "Transmit: " + transmit, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, temp.id));
            temp = str.substring(0, 1).equals("0") ? temp.left : temp.right;
            str = str.substring(1);
        }
        if (node == this.nyt) {
            return "";
        }
        return str;
    }

    public ObservabileBinaryTree.Node findNode(String name) {
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTPreorder(list, this.root);
        for (ObservabileBinaryTree.Node n : list) {
            if (n.getAttr(name) == 0) continue;
            return n;
        }
        return null;
    }

    public ObservabileBinaryTree.Node findParent(ObservabileBinaryTree.Node node) {
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTPreorder(list, this.root);
        for (ObservabileBinaryTree.Node n : list) {
            if (n.left == null || n.right == null || !n.left.equals(node) && !n.right.equals(node)) continue;
            return n;
        }
        return null;
    }

    public boolean onPath(ObservabileBinaryTree.Node anc, ObservabileBinaryTree.Node node) {
        String str = this.getCode(node.getAttr(-13));
        if (anc.equals(this.root)) {
            return true;
        }
        ObservabileBinaryTree.Node temp = this.root;
        while (temp != node && !str.equals("")) {
            temp = str.substring(0, 1).equals("0") ? temp.left : temp.right;
            str = str.substring(1);
            if (!temp.equals(anc)) continue;
            return true;
        }
        return false;
    }

    private void updateTree(ObservabileBinaryTree.Node r, boolean propagate) {
        ObservabileBinaryTree.Node par;
        if (r == this.root) {
            return;
        }
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTPreorder(list, this.root);
        ObservabileBinaryTree.Node temp = r;
        block0: for (ObservabileBinaryTree.Node n : list) {
            if (n.level > temp.level || n.value != r.value || this.onPath(n, r)) continue;
            if (n.level == temp.level) {
                String tmpStr = this.getCode(temp);
                String nStr = this.getCode(n);
                for (int i = 0; i < tmpStr.length(); ++i) {
                    if (tmpStr.substring(i, i + 1).equals("0") && nStr.substring(i, i + 1).equals("1")) {
                        temp = n;
                        this.alg.getActions().add(new ActBST("Comparing", "Replacement " + n.getAttr(-13), this.alg.getCloneStructures(), 0, new int[]{this.structureID}, n.id));
                        continue block0;
                    }
                    if (tmpStr.substring(i, i + 1).equals("1") && nStr.substring(i, i + 1).equals("0")) continue block0;
                }
                continue;
            }
            temp = n;
            this.alg.getActions().add(new ActBST("Comparing", "Replacement " + n.getAttr(-13), this.alg.getCloneStructures(), 0, new int[]{this.structureID}, n.id));
        }
        if (temp == r) {
            ++r.value;
            par = this.findParent(r);
            if (par.left.value > par.right.value) {
                this.swap(par.left, par.right);
            }
            if (propagate) {
                this.updateTree(this.findParent(r), true);
            }
        } else {
            this.swap(r, temp);
            this.updateNodeLevels();
            ++r.value;
            par = this.findParent(r);
            if (par.left.value > par.right.value) {
                this.swap(par.left, par.right);
            }
            if (propagate) {
                this.updateTree(this.findParent(r), true);
            }
        }
    }

    private void swap(ObservabileBinaryTree.Node n1, ObservabileBinaryTree.Node n2) {
        ObservabileBinaryTree.Node p2;
        ObservabileBinaryTree.Node p1 = this.findParent(n1);
        if (p1 != (p2 = this.findParent(n2))) {
            if (p1.left.equals(n1)) {
                p1.left = n2;
            } else {
                p1.right = n2;
            }
            if (p2.left.equals(n2)) {
                p2.left = n1;
            } else {
                p2.right = n1;
            }
        } else if (p1.left.equals(n1)) {
            p1.left = n2;
            p1.right = n1;
        } else {
            p1.left = n1;
            p1.right = n2;
        }
    }

    public void HuffmanSearch(String name) {
        this.getCodeAct(name);
        String transmit = this.getCode(name);
        if (transmit.equals("")) {
            this.alg.getActions().add(new ActBST("Huffman", name + " : Not found", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
        } else {
            ObservabileBinaryTree.Node found = this.findNode(name);
            this.alg.getActions().add(new ActBST("Huffman", name + " : " + transmit, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, found.id));
        }
    }
}

