/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActBST;
import algorithm.Algorithm;
import java.io.Serializable;
import java.util.LinkedList;
import structure.ObservabileVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservabileBinaryTree
extends ObservabileVariable {
    protected int ID;
    protected Node root;

    public ObservabileBinaryTree(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public ObservabileBinaryTree BSTInsert(int value) {
        this.BSTInsert(value, this.root, null, false, 0);
        return this;
    }

    private void BSTInsert(int value, Node tmp, Node parent, boolean left, int level) {
        if (this.root == null) {
            this.root = new Node(value, level);
            this.alg.getActions().add(new ActBST("InsertRoot " + value, "BST Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, -1, true));
        } else if (left && tmp == null) {
            parent.left = new Node(value, level);
            this.alg.getActions().add(new ActBST("InsertNodeLeft " + value + " parentID = " + parent.id, "BST Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, parent.id, true));
        } else if (tmp == null) {
            parent.right = new Node(value, level);
            this.alg.getActions().add(new ActBST("InsertNodeRight " + value + " parentID = " + parent.id, "BST Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, parent.id, false));
        } else {
            this.alg.getActions().add(new ActBST("Blink branch - Node ID = " + tmp.id, "BST Insert " + value, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, tmp.id));
            this.alg.getActions().add(new ActBST("VisitNode ID = " + tmp.id, "BST Insert " + value, this.alg.getCloneStructures(), 0, new int[]{this.structureID}, tmp.id));
            if (value < tmp.value) {
                this.BSTInsert(value, tmp.left, tmp, true, ++level);
            } else {
                this.BSTInsert(value, tmp.right, tmp, false, ++level);
            }
        }
    }

    public ObservabileBinaryTree BSTDelete(int K) {
        Node current = this.root;
        Node parent = null;
        Node replacement = null;
        Node f = null;
        Node s = null;
        while (current != null && K != current.value) {
            if (parent != null) {
                parent.status = Status.DEFAULT;
            }
            if ((parent = current) != null) {
                parent.setStatus(Status.PARENT, "BST Delete " + K);
            }
            if ((current = K < current.value ? current.left : current.right) == null) continue;
            current.setStatus(Status.CURRENT, "BST Delete " + K);
        }
        if (current == null) {
            parent.setStatus(Status.DEFAULT, "BST Delete " + K);
            return this;
        }
        if (current.left == null) {
            replacement = current.right;
            if (replacement != null) {
                replacement.setStatus(Status.REPLACEMENT, "BST Replacement " + K);
            }
        } else if (current.right == null) {
            replacement = current.left;
            if (replacement != null) {
                replacement.setStatus(Status.REPLACEMENT, "BST Replacement " + K);
            }
        } else {
            f = current;
            replacement = current.right;
            s = replacement.left;
            replacement.setStatus(Status.REPLACEMENT, "BST Replacement " + K);
            while (s != null) {
                replacement.status = Status.DEFAULT;
                f = replacement;
                replacement = s;
                s = replacement.left;
                replacement.setStatus(Status.REPLACEMENT, "BST Replacement " + K);
            }
            if (f != current) {
                f.left = replacement.right;
                replacement.right = current.right;
            }
            replacement.left = current.left;
        }
        if (parent == null) {
            this.root = replacement;
        } else if (current == parent.left) {
            parent.left = replacement;
        } else {
            parent.right = replacement;
        }
        this.updateNodeLevels();
        if (parent != null) {
            parent.status = Status.DEFAULT;
        }
        if (replacement != null) {
            replacement.status = Status.DEFAULT;
        }
        this.alg.getActions().add(new ActBST("UpdateTree", "BST Delete " + K, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
        return this;
    }

    public Node BSTSearch(int value) {
        return this.BSTSearch(value, this.root);
    }

    private Node BSTSearch(int value, Node tmp) {
        if (tmp == null) {
            this.alg.getActions().add(new ActBST("Update Tree", "BST Search Failed for " + value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
            return null;
        }
        if (tmp.value < value) {
            this.alg.getActions().add(new ActBST("Blink branch - Node ID = " + tmp.id, "BST Search " + value, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, tmp.id));
            this.alg.getActions().add(new ActBST("VisitNode ID = " + tmp.id, "BST Search " + value, this.alg.getCloneStructures(), 0, new int[]{this.structureID}, tmp.id));
            return this.BSTSearch(value, tmp.right);
        }
        if (tmp.value > value) {
            this.alg.getActions().add(new ActBST("Blink branch - Node ID = " + tmp.id, "BST Search " + value, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, tmp.id));
            this.alg.getActions().add(new ActBST("VisitNode ID = " + tmp.id, "BST Search " + value, this.alg.getCloneStructures(), 0, new int[]{this.structureID}, tmp.id));
            return this.BSTSearch(value, tmp.left);
        }
        tmp.setStatus(Status.REPLACEMENT, "BST Search " + value);
        tmp.status = Status.DEFAULT;
        return tmp;
    }

    public void BSTPreorder() {
        LinkedList<Node> list = new LinkedList<Node>();
        this.BSTPreorderAct(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).status = Status.DEFAULT;
        }
    }

    public void BSTPreorderAct(LinkedList<Node> list, Node root) {
        if (root != null) {
            list.add(root);
            root.setStatus(Status.SEEN, "BST Preorder");
            this.BSTPreorderAct(list, root.left);
            this.BSTPreorderAct(list, root.right);
        }
    }

    public void BSTPreorder(LinkedList<Node> list, Node root) {
        if (root != null) {
            list.add(root);
            this.BSTPreorder(list, root.left);
            this.BSTPreorder(list, root.right);
        }
    }

    public void BSTInorder() {
        LinkedList<Node> list = new LinkedList<Node>();
        this.BSTInorderAct(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).status = Status.DEFAULT;
        }
    }

    public void BSTInorderAct(LinkedList<Node> list, Node root) {
        if (root != null) {
            this.BSTInorderAct(list, root.left);
            list.add(root);
            root.setStatus(Status.SEEN, "BST Inorder");
            this.BSTInorderAct(list, root.right);
        }
    }

    public void BSTInorder(LinkedList<Node> list, Node root) {
        if (root != null) {
            this.BSTInorder(list, root.left);
            list.add(root);
            this.BSTInorder(list, root.right);
        }
    }

    public void BSTPostorder() {
        LinkedList<Node> list = new LinkedList<Node>();
        this.BSTPostorderAct(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).status = Status.DEFAULT;
        }
    }

    public void BSTPostorderAct(LinkedList<Node> list, Node root) {
        if (root != null) {
            this.BSTPostorderAct(list, root.left);
            this.BSTPostorderAct(list, root.right);
            list.add(root);
            root.setStatus(Status.SEEN, "BST Postorder");
        }
    }

    public void BSTPostorder(LinkedList<Node> list, Node root) {
        if (root != null) {
            this.BSTPostorder(list, root.left);
            this.BSTPostorder(list, root.right);
            list.add(root);
        }
    }

    public void BSTLevelOrderAct() {
        LinkedList<Node> list = new LinkedList<Node>();
        LinkedList<Node> queue = new LinkedList<Node>();
        Node node = this.root;
        queue.add(node);
        while (!queue.isEmpty()) {
            Node tmp = (Node)queue.removeFirst();
            if (tmp.left != null) {
                queue.add(tmp.left);
            }
            if (tmp.right != null) {
                queue.add(tmp.right);
            }
            list.add(tmp);
            tmp.setStatus(Status.SEEN, "BST LeverOrder");
        }
        for (int i = 0; i < list.size(); ++i) {
            ((Node)list.get((int)i)).status = Status.DEFAULT;
        }
    }

    public void BSTLevelOrder() {
        LinkedList<Node> list = new LinkedList<Node>();
        LinkedList<Node> queue = new LinkedList<Node>();
        Node node = this.root;
        queue.add(node);
        while (!queue.isEmpty()) {
            Node tmp = (Node)queue.removeFirst();
            if (tmp.left != null) {
                queue.add(tmp.left);
            }
            if (tmp.right != null) {
                queue.add(tmp.right);
            }
            list.add(tmp);
        }
    }

    public void updateNodeLevels() {
        this.updateNodeLevels(this.root, 0);
    }

    private void updateNodeLevels(Node tmp, int level) {
        if (tmp == null) {
            return;
        }
        tmp.level = level++;
        this.updateNodeLevels(tmp.left, level);
        this.updateNodeLevels(tmp.right, level);
    }

    public int getHeight() {
        LinkedList<Node> list = new LinkedList<Node>();
        int height = -1;
        this.BSTInorder(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).level <= height) continue;
            height = list.get((int)i).level;
        }
        return height;
    }

    @Override
    public ObservabileVariable clone() {
        int i;
        LinkedList<Node> list = new LinkedList<Node>();
        this.BSTPreorder(list, this.root);
        LinkedList<Node> newList = new LinkedList<Node>();
        for (i = 0; i < list.size(); ++i) {
            Node n = new Node(list.get((int)i).value, list.get((int)i).id, list.get((int)i).level, list.get((int)i).status);
            n.genericAttributes = new LinkedList();
            for (int j = 0; j < list.get((int)i).genericAttributes.size(); ++j) {
                n.genericAttributes.add(new GenericElement(list.get((int)i).genericAttributes.get((int)j).id, list.get((int)i).genericAttributes.get((int)j).value));
            }
            newList.add(n);
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get((int)i).left != null) {
                ((Node)newList.get((int)i)).left = (Node)newList.get(list.indexOf(list.get((int)i).left));
            }
            if (list.get((int)i).right == null) continue;
            ((Node)newList.get((int)i)).right = (Node)newList.get(list.indexOf(list.get((int)i).right));
        }
        ObservabileBinaryTree BST = new ObservabileBinaryTree(this.alg, this.structureID);
        BST.ID = this.ID;
        if (newList.size() > 0) {
            BST.root = (Node)newList.get(0);
        }
        return BST;
    }

    @Override
    public String toString() {
        LinkedList<Node> list = new LinkedList<Node>();
        this.BSTInorder(list, this.root);
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            str.append(list.get((int)i).value + "(" + list.get((int)i).level + ")");
            if (i == list.size() - 1) continue;
            str.append(" ");
        }
        return str.toString();
    }

    public Node getRoot() {
        return this.root;
    }

    public class Node
    implements Serializable {
        public int id;
        public int level;
        public int value;
        public Status status = Status.DEFAULT;
        public Node left;
        public Node right;
        public LinkedList<GenericElement> genericAttributes = new LinkedList();

        public Node(int value, int level) {
            this(value, observabileBinaryTree.ID++, level, Status.DEFAULT);
        }

        public Node(int value, int id, int level, Status status) {
            this.value = value;
            this.id = id;
            this.level = level;
            this.status = status;
        }

        public void insertAttr(String key, int val) {
            for (int i = 0; i < this.genericAttributes.size(); ++i) {
                if (!this.genericAttributes.get((int)i).id.equals(key)) continue;
                this.genericAttributes.remove(i);
            }
            this.genericAttributes.add(new GenericElement(key, val));
        }

        public int getAttr(String key) {
            int rtrn = 0;
            if (this.genericAttributes.size() == 0) {
                return 0;
            }
            for (GenericElement el : this.genericAttributes) {
                if (!el.id.equals(key)) continue;
                rtrn = el.value;
                break;
            }
            return rtrn;
        }

        public void removeAttr(String key) {
            if (this.genericAttributes.size() == 0) {
                return;
            }
            for (GenericElement el : this.genericAttributes) {
                if (!el.id.equals(key)) continue;
                this.genericAttributes.remove(el);
                break;
            }
        }

        public String getAttr(int value) {
            String rtrn = "";
            if (this.genericAttributes.size() == 0) {
                return rtrn;
            }
            for (GenericElement el : this.genericAttributes) {
                if (el.value != value) continue;
                rtrn = el.id;
                break;
            }
            return rtrn;
        }

        public void setStatus(Status status, String actionType) {
            if (status != Status.SEEN && status != Status.PARENT) {
                ObservabileBinaryTree.this.alg.getActions().add(new ActBST("Blink branch - Node ID = " + this.id, actionType, ObservabileBinaryTree.this.alg.getCloneStructures(), 5, new int[]{ObservabileBinaryTree.this.structureID}, this.id));
            }
            this.status = status;
            ObservabileBinaryTree.this.alg.getActions().add(new ActBST("UpdateTree", actionType, ObservabileBinaryTree.this.alg.getCloneStructures(), 4, new int[]{ObservabileBinaryTree.this.structureID}, this.id));
        }
    }

    public class GenericElement
    implements Serializable {
        public int value;
        public String id;

        public GenericElement(String id, int value) {
            this.value = value;
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DEFAULT,
        PARENT,
        CURRENT,
        REPLACEMENT,
        SEEN;

    }
}

