/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActBST;
import algorithm.Algorithm;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;
import structure.ObservabileVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservabileBTree
extends ObservabileBinaryTree {
    public static int nodeSize = 4;
    protected BNode BRoot;

    public ObservabileBTree(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    @Override
    public ObservabileBinaryTree BSTInsert(int value) {
        this.BTreeInsert(value);
        return this;
    }

    public void BTreeInsert(int value) {
        if (this.BRoot == null) {
            this.BRoot = new BNode(0);
            this.BRoot.value[this.BRoot.size++] = value;
        } else {
            BNode node = this.BTreeSearch(value);
            if (node != null) {
                return;
            }
            node = this.BTreeSearchNodeToInsert(value);
            if (node.size < nodeSize) {
                for (int i = node.size; i > 0 && node.value[i - 1] > value; --i) {
                    node.value[i] = node.value[i - 1];
                }
                node.value[i] = value;
                ++node.size;
            } else if (node.size == nodeSize) {
                int i;
                int middle = (int)Math.ceil((nodeSize + 1) / 2);
                for (i = node.size; i > 0 && node.value[i - 1] > value; --i) {
                    node.value[i] = node.value[i - 1];
                }
                node.value[i] = value;
                BNode novi = new BNode(0);
                novi.parent = node.parent;
                int midVal = node.value[middle];
                for (i = middle + 1; i < nodeSize + 1; ++i) {
                    novi.value[novi.size++] = node.value[i];
                    node.value[i] = 0;
                }
                node.value[middle] = 0;
                node.size = middle;
                this.BTreeInsertInParent(node.parent, node, novi, midVal);
            }
        }
        this.updateNodeLevels();
        this.updateParents();
        this.alg.getActions().add(new ActBST("BTree Insert" + value, "Update", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, this.BRoot.id));
    }

    public void BTreeInsertInParent(BNode node, BNode leftNode, BNode rightNode, int value) {
        if (node == null) {
            this.BRoot = new BNode(0);
            this.BRoot.value[this.BRoot.size++] = value;
            this.BRoot.child[0] = leftNode;
            this.BRoot.child[1] = rightNode;
            leftNode.parent = this.BRoot;
            rightNode.parent = this.BRoot;
            return;
        }
        if (node.size < nodeSize) {
            for (int i = node.size; i > 0 && node.value[i - 1] > value; --i) {
                node.value[i] = node.value[i - 1];
                node.child[i + 1] = node.child[i];
            }
            node.value[i] = value;
            node.child[i + 1] = rightNode;
            ++node.size;
            return;
        }
        if (node.size == nodeSize) {
            int i;
            int middle = (int)Math.ceil((nodeSize + 1) / 2);
            for (i = node.size; i > 0 && node.value[i - 1] > value; --i) {
                node.value[i] = node.value[i - 1];
                node.child[i + 1] = node.child[i];
            }
            node.value[i] = value;
            node.child[i + 1] = rightNode;
            BNode novi = new BNode(0);
            novi.parent = node.parent;
            int midVal = node.value[middle];
            for (i = middle + 1; i < nodeSize + 1; ++i) {
                novi.value[novi.size++] = node.value[i];
                novi.child[novi.size - 1] = node.child[i];
                node.value[i] = 0;
                node.child[i] = null;
            }
            novi.child[novi.size] = node.child[i];
            node.child[i] = null;
            node.value[middle] = 0;
            node.size = middle;
            this.BTreeInsertInParent(node.parent, node, novi, midVal);
        }
    }

    public void updateParents() {
        LinkedList<BNode> tmp = new LinkedList<BNode>();
        this.TreeToList(tmp, this.getBRoot());
        for (int i = 0; i < tmp.size(); ++i) {
            for (int j = 0; j < tmp.get((int)i).child.length; ++j) {
                if (tmp.get((int)i).child[j] == null) continue;
                tmp.get((int)i).child[j].parent = tmp.get(i);
            }
        }
    }

    public BNode BTreeSearch(int value) {
        BNode temp = this.BRoot;
        int len = 0;
        while (temp != null) {
            BNode help = temp;
            len = temp.size;
            for (int i = 0; i < len; ++i) {
                if (temp.value[i] == value) {
                    return temp;
                }
                if (temp.value[i] <= value) continue;
                temp = temp.child[i];
                break;
            }
            if (temp == null || !temp.equals(help)) continue;
            temp = temp.child[len];
        }
        return temp;
    }

    public BNode BTreeSearchNodeToInsert(int value) {
        BNode temp = this.BRoot;
        BNode help = null;
        int len = 0;
        while (temp != null) {
            help = temp;
            len = temp.size;
            for (int i = 0; i < len; ++i) {
                if (temp.value[i] <= value) continue;
                temp = temp.child[i];
                break;
            }
            if (temp == null || !temp.equals(help)) continue;
            temp = temp.child[len];
        }
        return help;
    }

    public void TreeToList(LinkedList<BNode> list, BNode root) {
        if (root != null) {
            list.add(root);
            for (int i = 0; i < root.size + 1; ++i) {
                this.TreeToList(list, root.child[i]);
            }
        }
    }

    @Override
    public void updateNodeLevels() {
        this.updateNodeLevels(this.BRoot, 0);
    }

    public void updateNodeLevels(BNode tmp, int level) {
        if (tmp == null) {
            return;
        }
        tmp.level = level++;
        for (int i = 0; i < tmp.size + 1; ++i) {
            this.updateNodeLevels(tmp.child[i], level);
        }
    }

    public BNode getBRoot() {
        return this.BRoot;
    }

    @Override
    public ObservabileVariable clone() {
        int i;
        LinkedList<BNode> list = new LinkedList<BNode>();
        this.TreeToList(list, this.BRoot);
        LinkedList<BNode> newList = new LinkedList<BNode>();
        for (i = 0; i < list.size(); ++i) {
            BNode n = new BNode(list.get((int)i).value, list.get((int)i).id, list.get((int)i).level, list.get((int)i).parent);
            newList.add(n);
        }
        for (i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.get((int)i).child.length; ++j) {
                if (list.get((int)i).child[j] == null) continue;
                ((BNode)newList.get((int)i)).child[j] = (BNode)newList.get(list.indexOf(list.get((int)i).child[j]));
            }
        }
        ObservabileBTree BTree = new ObservabileBTree(this.alg, this.structureID);
        BTree.ID = this.ID;
        if (newList.size() > 0) {
            BTree.BRoot = (BNode)newList.get(0);
        }
        return BTree;
    }

    @Override
    public int getHeight() {
        LinkedList<BNode> list = new LinkedList<BNode>();
        int height = -1;
        this.TreeToList(list, this.BRoot);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).level <= height) continue;
            height = list.get((int)i).level;
        }
        return height;
    }

    public class BNode {
        public int id;
        public int level;
        public int size;
        public int[] value = new int[nodeSize + 1];
        public BNode[] child = new BNode[nodeSize + 2];
        public BNode parent;

        public BNode(int level) {
            this(observabileBTree.ID++, level);
        }

        public BNode(int id, int level) {
            this.id = id;
            this.level = level;
            this.size = 0;
            for (int i = 0; i < nodeSize + 1; ++i) {
                this.value[i] = 0;
            }
        }

        private BNode(int[] value, int id, int level, BNode parent) {
            this.id = id;
            this.level = level;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == 0) continue;
                ++this.size;
                this.value[i] = value[i];
            }
        }
    }
}

