/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActArray;
import algorithm.Algorithm;
import error.Error;
import java.io.Serializable;
import structure.ObservabileElement;
import structure.ObservabileVariable;

public class ObservabileArray
extends ObservabileVariable {
    private ArrayElem arrayFirst;
    private ArrayElem arrayLast;
    private int numOfElem;
    private boolean numbers = true;

    public ObservabileArray(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public ObservabileArray addElem(String value) {
        ++this.numOfElem;
        if (this.arrayFirst == null) {
            this.arrayFirst = this.arrayLast = new ArrayElem(value);
        } else {
            this.arrayLast.next = new ArrayElem(value);
            this.arrayLast.next.prev = this.arrayLast;
            this.arrayLast = this.arrayLast.next;
        }
        if (this.numbers) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException exp) {
                this.numbers = false;
            }
        }
        return this;
    }

    public String readElem(int ind) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        ArrayElem tmp = this.arrayFirst;
        for (int i = 0; i < ind; ++i) {
            tmp = tmp.next;
        }
        return tmp.value;
    }

    public String getElem(int ind) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        String val = this.readElem(ind);
        this.alg.getActions().add(new ActArray("GetElem at position " + ind, this.alg.getCloneStructures(), 0, ind, new int[]{this.structureID}));
        return val;
    }

    public void writeElem(int ind, String value) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        ArrayElem tmp = this.arrayFirst;
        for (int i = 0; i < ind; ++i) {
            tmp = tmp.next;
        }
        tmp.value = value;
    }

    public void setElem(int ind, String value) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        this.alg.getActions().add(new ActArray("SetElem at position " + ind, this.alg.getCloneStructures(), 1, ind, value, new int[]{this.structureID}));
        this.writeElem(ind, value);
    }

    public void saveElem(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        this.alg.getActions().add(new ActArray("SaveElem at position " + ind, this.alg.getCloneStructures(), 4, ind, new int[]{this.structureID, K.structureID}));
        K.writeValue(this.readElem(ind));
    }

    public void restoreElem(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        this.alg.getActions().add(new ActArray("RestoreElem to position " + ind, this.alg.getCloneStructures(), 5, ind, new int[]{K.structureID, this.structureID}));
        this.writeElem(ind, K.readValue());
    }

    public Boolean compareTmp(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        String val = this.readElem(ind);
        if (this.numbers && Integer.parseInt(val) > Integer.parseInt(K.readValue())) {
            return true;
        }
        if (!this.numbers && val.compareTo(K.readValue()) > 0) {
            return true;
        }
        return false;
    }

    public Boolean compareTmpAct(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        String val = this.readElem(ind);
        this.alg.getActions().add(new ActArray("CompareElem at pos " + ind + " with " + K.readValue(), this.alg.getCloneStructures(), 2, ind, new int[]{this.structureID, K.structureID}));
        if (this.numbers && Integer.parseInt(val) > Integer.parseInt(K.readValue())) {
            return true;
        }
        if (!this.numbers && val.compareTo(K.readValue()) > 0) {
            return true;
        }
        return false;
    }

    public Boolean equalTmp(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        String val = this.readElem(ind);
        if (this.numbers && Integer.parseInt(val) == Integer.parseInt(K.readValue())) {
            return true;
        }
        if (!this.numbers && val.compareTo(K.readValue()) == 0) {
            return true;
        }
        return false;
    }

    public Boolean equalTmpAct(int ind, ObservabileElement K) throws Error {
        if (ind >= this.numOfElem) {
            throw new Error(1006);
        }
        String val = this.readElem(ind);
        this.alg.getActions().add(new ActArray("CompareElem at pos " + ind + " with " + K.readValue(), this.alg.getCloneStructures(), 2, ind, new int[]{this.structureID, K.structureID}));
        if (this.numbers && Integer.parseInt(val) == Integer.parseInt(K.readValue())) {
            return true;
        }
        if (!this.numbers && val.compareTo(K.readValue()) == 0) {
            return true;
        }
        return false;
    }

    public Boolean compare(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem || ind2 >= this.numOfElem) {
            throw new Error(1006);
        }
        String val1 = this.readElem(ind1);
        String val2 = this.readElem(ind2);
        if (this.numbers && Integer.parseInt(val1) > Integer.parseInt(val2)) {
            return true;
        }
        if (!this.numbers && val1.compareTo(val2) > 0) {
            return true;
        }
        return false;
    }

    public Boolean compareAct(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem || ind2 >= this.numOfElem) {
            throw new Error(1006);
        }
        String val1 = this.readElem(ind1);
        String val2 = this.readElem(ind2);
        this.alg.getActions().add(new ActArray("CompareElems at pos " + ind1 + " and " + ind2, this.alg.getCloneStructures(), 3, ind1, ind2, new int[]{this.structureID}));
        if (this.numbers && Integer.parseInt(val1) > Integer.parseInt(val2)) {
            return true;
        }
        if (!this.numbers && val1.compareTo(val2) > 0) {
            return true;
        }
        return false;
    }

    public Boolean equal(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem || ind2 >= this.numOfElem) {
            throw new Error(1006);
        }
        String val1 = this.readElem(ind1);
        String val2 = this.readElem(ind2);
        if (this.numbers && Integer.parseInt(val1) == Integer.parseInt(val2)) {
            return true;
        }
        if (!this.numbers && val1.compareTo(val2) == 0) {
            return true;
        }
        return false;
    }

    public Boolean equalAct(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem || ind2 >= this.numOfElem) {
            throw new Error(1006);
        }
        String val1 = this.readElem(ind1);
        String val2 = this.readElem(ind2);
        this.alg.getActions().add(new ActArray("CompareElems at pos " + ind1 + " and " + ind2, this.alg.getCloneStructures(), 3, ind1, ind2, new int[]{this.structureID}));
        if (this.numbers && Integer.parseInt(val1) == Integer.parseInt(val2)) {
            return true;
        }
        if (!this.numbers && val1.compareTo(val2) == 0) {
            return true;
        }
        return false;
    }

    public void moveElem(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem) {
            throw new Error(1006);
        }
        this.alg.getActions().add(new ActArray("MoveElem at pos " + ind1 + " from " + ind2, this.alg.getCloneStructures(), 6, ind1, ind2, new int[]{this.structureID}));
        this.writeElem(ind1, this.readElem(ind2));
    }

    public void swapElems(int ind1, int ind2) throws Error {
        if (ind1 >= this.numOfElem || ind2 >= this.numOfElem) {
            throw new Error(1006);
        }
        String val1 = this.readElem(ind1);
        String val2 = this.readElem(ind2);
        this.alg.getActions().add(new ActArray("SwapElems at pos " + ind1 + " and " + ind2, this.alg.getCloneStructures(), 7, ind1, ind2, new int[]{this.structureID}));
        this.writeElem(ind1, val2);
        this.writeElem(ind2, val1);
    }

    public ObservabileVariable clone() {
        try {
            ObservabileArray struct = new ObservabileArray(this.alg, this.structureID);
            for (int i = 0; i < this.numOfElem; ++i) {
                ++struct.numOfElem;
                if (struct.arrayFirst == null) {
                    struct.arrayFirst = struct.arrayLast = new ArrayElem(this.readElem(i));
                    continue;
                }
                struct.arrayLast.next = new ArrayElem(this.readElem(i));
                struct.arrayLast.next.prev = struct.arrayLast;
                struct.arrayLast = struct.arrayLast.next;
            }
            return struct;
        }
        catch (Error error) {
            return null;
        }
    }

    public String toString() {
        String str = "";
        ArrayElem tmp = this.arrayFirst;
        while (tmp != null) {
            str = str + tmp.value;
            if (tmp.next != null) {
                str = str + " ";
            }
            tmp = tmp.next;
        }
        return str;
    }

    public int getNumOfElem() {
        return this.numOfElem;
    }

    private class ArrayElem
    implements Serializable {
        String value;
        ArrayElem prev;
        ArrayElem next;

        ArrayElem(String value) {
            this.value = value;
        }
    }
}

