/*
 * Decompiled with CFR 0.152.
 */
package structure;

import action.ActBST;
import algorithm.Algorithm;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;

public class ObservabileAVLTree
extends ObservabileBinaryTree {
    public ObservabileAVLTree(Algorithm alg, int structureID) {
        super(alg, structureID);
    }

    public ObservabileBinaryTree BSTInsert(int value) {
        this.AVLInsert(value);
        return this;
    }

    private void AVLInsert(int value) {
        boolean left = false;
        if (this.root == null) {
            this.root = new ObservabileBinaryTree.Node(this, value, 0);
            this.root.insertAttr("balance", 0);
            this.alg.getActions().add(new ActBST("InsertRoot " + value, "AVL Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, -1, true));
        } else {
            ObservabileBinaryTree.Node q;
            ObservabileBinaryTree.Node p;
            ObservabileBinaryTree.Node fp = null;
            ObservabileBinaryTree.Node fx = null;
            ObservabileBinaryTree.Node x = p = this.root;
            while (p != null) {
                if (value == p.value) {
                    return;
                }
                this.alg.getActions().add(new ActBST("Blink branch - Node ID = " + p.id, "AVL Insert " + value, this.alg.getCloneStructures(), 5, new int[]{this.structureID}, p.id));
                this.alg.getActions().add(new ActBST("VisitNode ID = " + p.id, "AVL Insert " + value, this.alg.getCloneStructures(), 0, new int[]{this.structureID}, p.id));
                q = value < p.value ? p.left : p.right;
                if (q != null && q.getAttr("balance") != 0) {
                    fx = p;
                    x = q;
                }
                fp = p;
                p = q;
            }
            q = new ObservabileBinaryTree.Node(this, value, fp.level + 1);
            q.insertAttr("balance", 0);
            if (value < fp.value) {
                fp.left = q;
                this.alg.getActions().add(new ActBST("InsertNodeLeft " + value + " parentID = " + fp.id, "AVL Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, fp.id, true));
            } else {
                fp.right = q;
                this.alg.getActions().add(new ActBST("InsertNodeRight " + value + " parentID = " + fp.id, "AVL Insert " + value, this.alg.getCloneStructures(), 2, new int[]{this.structureID}, value, fp.id, false));
            }
            p = value < x.value ? x.left : x.right;
            ObservabileBinaryTree.Node y = p;
            while (!p.equals(q)) {
                if (value < p.value) {
                    p.insertAttr("balance", 1);
                    p = p.left;
                    continue;
                }
                p.insertAttr("balance", -1);
                p = p.right;
            }
            int imbal = value < x.value ? 1 : -1;
            if (x.getAttr("balance") == 0) {
                x.insertAttr("balance", imbal);
                this.updateBalance();
                this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                return;
            }
            if (x.getAttr("balance") != imbal) {
                x.insertAttr("balance", 0);
                this.updateBalance();
                this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                return;
            }
            if (y.getAttr("balance") == imbal) {
                p = y;
                if (imbal == 1) {
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.rightRotation(x);
                } else {
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.leftRotation(x);
                    left = true;
                }
                x.insertAttr("balance", 0);
                y.insertAttr("balance", 0);
            } else {
                if (imbal == 1) {
                    p = y.right;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.leftRotation(y);
                    x.left = p;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Left rotation " + y.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.rightRotation(x);
                } else {
                    p = y.left;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.rightRotation(y);
                    x.right = p;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Right rotation " + y.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                    this.leftRotation(x);
                    left = true;
                }
                if (p.getAttr("balance") == 0) {
                    if (x != null) {
                        x.insertAttr("balance", 0);
                    }
                    if (y != null) {
                        y.insertAttr("balance", 0);
                    }
                } else if (p.getAttr("balance") == imbal) {
                    if (x != null) {
                        x.insertAttr("balance", -1 * imbal);
                    }
                    if (y != null) {
                        y.insertAttr("balance", 0);
                    }
                } else {
                    if (x != null) {
                        x.insertAttr("balance", 0);
                    }
                    if (y != null) {
                        y.insertAttr("balance", 0);
                    }
                }
                p.insertAttr("balance", 0);
            }
            if (fx == null) {
                this.root = p;
            } else if (x.equals(fx.right)) {
                fx.right = p;
            } else {
                fx.left = p;
            }
            this.updateNodeLevels();
            this.updateBalance();
            String direction = left ? "Left rotation " : "Right rotation ";
            this.alg.getActions().add(new ActBST("UpdateTree", direction + x.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
        }
    }

    public ObservabileBinaryTree BSTDelete(int K) {
        this.AVLDelete(K);
        return this;
    }

    private void AVLDelete(int value) {
        ObservabileBinaryTree.Node del = null;
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTInorder(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).value != value) continue;
            del = list.get(i);
        }
        ObservabileBinaryTree.Node succ = null;
        ObservabileBinaryTree.Node succParent = null;
        ObservabileBinaryTree.Node delParent = this.getParent(del);
        int x = -1;
        if (list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(del)) continue;
            x = i;
        }
        if (x != -1) {
            if (list.get((int)x).right != null) {
                succ = list.get(x + 1);
            } else if (list.get((int)x).left != null) {
                succ = list.get(x - 1);
            }
            succParent = this.getParent(succ);
        }
        super.BSTDelete(value);
        this.updateNodeLevels();
        this.updateBalance();
        if (x == -1) {
            return;
        }
        this.alg.getActions().add(new ActBST("UpdateTree", "Update balance", this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
        if (succ == null) {
            this.updateBalanceUp(delParent);
        } else if (succParent != null && succParent.equals(del)) {
            this.updateBalanceUp(succ);
        } else {
            this.updateBalanceUp(succParent);
        }
        this.updateNodeLevels();
        this.updateBalance();
    }

    private void rightRotation(ObservabileBinaryTree.Node x) {
        ObservabileBinaryTree.Node y = x.left;
        ObservabileBinaryTree.Node temp = null;
        if (y != null) {
            temp = y.right;
            y.right = x;
        }
        x.left = temp;
        this.updateNodeLevels();
    }

    private void leftRotation(ObservabileBinaryTree.Node x) {
        ObservabileBinaryTree.Node y = x.right;
        ObservabileBinaryTree.Node temp = null;
        if (y != null) {
            temp = y.left;
            y.left = x;
        }
        x.right = temp;
        this.updateNodeLevels();
    }

    private ObservabileBinaryTree.Node getParent(ObservabileBinaryTree.Node p) {
        if (p == null) {
            return null;
        }
        if (p.equals(this.root)) {
            return null;
        }
        ObservabileBinaryTree.Node temp = this.root;
        ObservabileBinaryTree.Node parent = null;
        while (temp != null && temp != p) {
            parent = temp;
            if (temp.value > p.value) {
                temp = temp.left;
                continue;
            }
            temp = temp.right;
        }
        return parent;
    }

    private int getBranchHeight(ObservabileBinaryTree.Node n) {
        if (n == null) {
            return 0;
        }
        int temp = 1;
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTInorder(list, n);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).level - n.level + 1 <= temp) continue;
            temp = list.get((int)i).level - n.level + 1;
        }
        return temp;
    }

    private void updateBalanceUp(ObservabileBinaryTree.Node n) {
        if (n == null) {
            return;
        }
        ObservabileBinaryTree.Node temp = n;
        while (temp != null) {
            ObservabileBinaryTree.Node help;
            int right;
            int left = this.getBranchHeight(temp.left);
            if (left - (right = this.getBranchHeight(temp.right)) < -1) {
                if (temp.right.getAttr("balance") > 0) {
                    help = temp.right.left;
                    this.rightRotation(temp.right);
                    temp.right = help;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Right rotation " + help.right.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                }
                if ((help = this.getParent(temp)) == null) {
                    this.root = temp.right;
                } else if (help.right.equals(temp)) {
                    help.right = temp.right;
                } else {
                    help.left = temp.right;
                }
                this.leftRotation(temp);
                this.updateNodeLevels();
                this.updateBalance();
                this.alg.getActions().add(new ActBST("UpdateTree", "Left rotation " + temp.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
            } else if (left - right > 1) {
                if (temp.left.getAttr("balance") < 0) {
                    help = temp.left.right;
                    this.leftRotation(temp.left);
                    temp.left = help;
                    this.updateNodeLevels();
                    this.updateBalance();
                    this.alg.getActions().add(new ActBST("UpdateTree", "Left rotation " + help.left.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
                }
                if ((help = this.getParent(temp)) == null) {
                    this.root = temp.left;
                } else if (help.left.equals(temp)) {
                    help.left = temp.left;
                } else {
                    help.right = temp.left;
                }
                this.rightRotation(temp);
                this.updateNodeLevels();
                this.updateBalance();
                this.alg.getActions().add(new ActBST("UpdateTree", "Right rotation " + temp.value, this.alg.getCloneStructures(), 4, new int[]{this.structureID}, -1));
            }
            this.updateNodeLevels();
            temp = this.getParent(temp);
        }
    }

    public void updateBalance() {
        LinkedList<ObservabileBinaryTree.Node> list = new LinkedList<ObservabileBinaryTree.Node>();
        this.BSTInorder(list, this.root);
        for (int i = 0; i < list.size(); ++i) {
            int left = this.getBranchHeight(list.get((int)i).left);
            int right = this.getBranchHeight(list.get((int)i).right);
            list.get(i).insertAttr("balance", left - right);
        }
    }
}

