/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import algorithm.Algorithm;
import error.Error;
import gui.AbstractSimulationFrame;
import gui.tree.InternalFrameBSTViewParams;
import gui.tree.InternalFrameBinaryTree;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;
import structure.ObservabileDynamicHuffman;
import structure.ObservabileHuffman;
import structure.ObservabileVariable;
import view.AbstractView;
import viewer.BinaryTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationFrameBinaryTree
extends AbstractSimulationFrame {
    private ObservabileBinaryTree tree;
    private InternalFrameBSTViewParams frame3;

    public SimulationFrameBinaryTree(AbstractView view) {
        super(view);
    }

    @Override
    protected void openStructures(File file) throws FileNotFoundException, IOException, Error, ClassNotFoundException {
        try {
            super.openStructures(file);
        }
        catch (ClassCastException e) {
            this.error("Could not load: " + e.getMessage());
        }
        Algorithm a = this.viewer.getView().getAlgorithm();
        this.tree = (ObservabileBinaryTree)a.getCloneStructures()[0];
        a.clearActions();
        a.run(new ObservabileVariable[]{this.tree});
        this.viewer.getView().nextStep();
        this.viewer.repaint();
    }

    @Override
    protected void initComponents(AbstractView view) throws Error {
        super.initComponents(view);
        this.viewer = new BinaryTreeViewer(view);
        this.createAndStartViewerThread();
        this.frame2 = new InternalFrameBinaryTree(this);
        this.frame3 = new InternalFrameBSTViewParams(this);
        Algorithm a = this.viewer.getView().getAlgorithm();
        this.historyMenuItem.setEnabled(true);
        ObservabileVariable[] structures = a.makeStructures(null);
        this.tree = (ObservabileBinaryTree)structures[0];
        a.run(structures);
        this.getDesktop().add(this.frame3);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (SimulationFrameBinaryTree.this.frame1.isMaximum()) {
                    return;
                }
                if (SimulationFrameBinaryTree.this.getFrame3() != null) {
                    SimulationFrameBinaryTree.this.getFrame3().reposition();
                }
                SimulationFrameBinaryTree.this.viewer.repaint();
            }
        });
    }

    private void rememberHistory() {
        if (!this.historyMenuItem.isSelected()) {
            this.viewer.getView().getAlgorithm().clearActions();
            try {
                this.viewer.reset();
            }
            catch (Error e) {
                this.error(e.getErrorMessage());
            }
        }
    }

    public void insertElems(LinkedList<Integer> elems) {
        this.rememberHistory();
        for (Integer s : elems) {
            this.tree.BSTInsert(s);
        }
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void insert2Strings(LinkedList<String> elems) {
        this.rememberHistory();
        ObservabileHuffman tree2 = (ObservabileHuffman)this.tree;
        for (int i = 0; i < elems.size() - 1; i += 2) {
            tree2.HuffmanInsert(elems.get(i), elems.get(i + 1));
        }
        tree2.makeHuffman();
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void insertStrings(LinkedList<String> elems) {
        this.rememberHistory();
        ObservabileDynamicHuffman tree2 = (ObservabileDynamicHuffman)this.tree;
        for (int i = 0; i < elems.size(); ++i) {
            tree2.HuffmanInsert(elems.get(i));
        }
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void deleteElems(LinkedList<Integer> elems) {
        this.rememberHistory();
        for (Integer s : elems) {
            this.tree.BSTDelete(s);
        }
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void findElems(LinkedList<Integer> elems) {
        this.rememberHistory();
        for (Integer s : elems) {
            this.tree.BSTSearch(s);
        }
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void findElemsString(LinkedList<String> elems) {
        this.rememberHistory();
        ObservabileDynamicHuffman tree2 = (ObservabileDynamicHuffman)this.tree;
        for (int i = 0; i < elems.size(); ++i) {
            tree2.HuffmanSearch(elems.get(i));
        }
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void inorder() {
        this.rememberHistory();
        this.tree.BSTInorder();
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void preorder() {
        this.rememberHistory();
        this.tree.BSTPreorder();
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void postorder() {
        this.rememberHistory();
        this.tree.BSTPostorder();
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public void levelorder() {
        this.rememberHistory();
        this.tree.BSTLevelOrderAct();
        this.viewer.setFinished(false);
        this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
    }

    public InternalFrameBSTViewParams getFrame3() {
        return this.frame3;
    }

    public ObservabileBinaryTree getTree() {
        return this.tree;
    }
}

