/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import algorithm.tree.huffman.AlgDynamicHuffman;
import algorithm.tree.huffman.AlgHuffman;
import gui.AbstractSimulationFrame;
import gui.MyInternalFrame;
import gui.tree.SimulationFrameBinaryTree;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InternalFrameBinaryTree
extends MyInternalFrame {
    private LinkedList<Integer> elems = new LinkedList();
    private LinkedList<String> strElems = new LinkedList();
    private JButton deleteButton;
    private JScrollPane elementsScrollPane;
    private JTextArea elementsTextArea;
    private JButton findButton;
    private JButton inorderButton;
    private JButton insertButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JButton levelorderButton;
    private JButton postorderButton;
    private JButton preorderButton;

    public InternalFrameBinaryTree(AbstractSimulationFrame owner) {
        super(owner);
        this.initComponents();
        if (AlgDynamicHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm())) {
            this.jPanel1.remove(this.deleteButton);
        }
        this.setVisible(true);
    }

    private void makeElems() {
        String[] e;
        this.elems.clear();
        this.strElems.clear();
        for (String s : e = this.elementsTextArea.getText().split("[ |\n]+")) {
            try {
                if (AlgHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm()) || AlgDynamicHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm())) {
                    this.strElems.add(s);
                    continue;
                }
                this.elems.add(Integer.parseInt(s));
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.elementsScrollPane = new JScrollPane();
        this.elementsTextArea = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.insertButton = new JButton();
        this.deleteButton = new JButton();
        this.findButton = new JButton();
        this.jPanel2 = new JPanel();
        this.preorderButton = new JButton();
        this.inorderButton = new JButton();
        this.postorderButton = new JButton();
        this.levelorderButton = new JButton();
        this.setTitle("Tree operations");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.elementsScrollPane.setBorder(BorderFactory.createTitledBorder("Elements"));
        this.elementsScrollPane.setPreferredSize(new Dimension(150, 100));
        this.elementsTextArea.setColumns(12);
        this.elementsTextArea.setFont(new Font("Tahoma", 0, 11));
        this.elementsTextArea.setLineWrap(true);
        this.elementsTextArea.setRows(2);
        this.elementsScrollPane.setViewportView(this.elementsTextArea);
        this.getContentPane().add(this.elementsScrollPane);
        this.jPanel5.setPreferredSize(new Dimension(215, 5));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 227, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 4, Short.MAX_VALUE));
        this.getContentPane().add(this.jPanel5);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 3));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Basic actions"));
        this.jPanel1.setLayout(new GridLayout(1, 0, 2, 2));
        this.insertButton.setText("Insert");
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.insertButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.insertButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.findButton.setText("Find");
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.findButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.findButton);
        this.jPanel3.add(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Traversals"));
        this.jPanel2.setLayout(new GridLayout(2, 0, 2, 2));
        this.preorderButton.setText("Preorder");
        this.preorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.preorderButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.preorderButton);
        this.inorderButton.setText("Inorder");
        this.inorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.inorderButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.inorderButton);
        this.postorderButton.setText("Postorder");
        this.postorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.postorderButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.postorderButton);
        this.levelorderButton.setText("Level ordrer");
        this.levelorderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBinaryTree.this.levelorderButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.levelorderButton);
        this.jPanel3.add(this.jPanel2);
        this.getContentPane().add(this.jPanel3);
        this.pack();
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.makeElems();
        if (AlgHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm())) {
            ((SimulationFrameBinaryTree)this.getOwner()).insert2Strings(this.strElems);
        } else if (AlgDynamicHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm())) {
            ((SimulationFrameBinaryTree)this.getOwner()).insertStrings(this.strElems);
        } else {
            ((SimulationFrameBinaryTree)this.getOwner()).insertElems(this.elems);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.makeElems();
        ((SimulationFrameBinaryTree)this.getOwner()).deleteElems(this.elems);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.makeElems();
        if (AlgDynamicHuffman.class.isInstance(this.getOwner().getViewer().getView().getAlgorithm())) {
            ((SimulationFrameBinaryTree)this.getOwner()).findElemsString(this.strElems);
        } else {
            ((SimulationFrameBinaryTree)this.getOwner()).findElems(this.elems);
        }
    }

    private void inorderButtonActionPerformed(ActionEvent evt) {
        ((SimulationFrameBinaryTree)this.getOwner()).inorder();
    }

    private void preorderButtonActionPerformed(ActionEvent evt) {
        ((SimulationFrameBinaryTree)this.getOwner()).preorder();
    }

    private void postorderButtonActionPerformed(ActionEvent evt) {
        ((SimulationFrameBinaryTree)this.getOwner()).postorder();
    }

    private void levelorderButtonActionPerformed(ActionEvent evt) {
        ((SimulationFrameBinaryTree)this.getOwner()).levelorder();
    }

    public void reposition() {
        if (this.getDesktopPane() == null) {
            return;
        }
        Rectangle r = this.getDesktopPane().getBounds();
        this.setLocation((int)r.getWidth() - this.getWidth(), 0);
    }
}

