/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import error.Error;
import gui.AbstractSimulationFrame;
import gui.MyInternalFrame;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import view.graphics.graph.Node2D;
import view.tree.AbstractBinaryTreeView;
import view.tree.binarySearchTree.BSTAnimatedView;
import view.tree.binarySearchTree.BinaryTreeView;
import view.tree.huffman.HuffmanView;

public class InternalFrameBSTViewParams
extends MyInternalFrame {
    private JButton decDxButton;
    private JButton decDyButton;
    private JButton incDxButton;
    private JButton incDyButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton jButton1;
    private JButton incDistance;
    private JButton decDistance;

    public InternalFrameBSTViewParams(AbstractSimulationFrame owner) {
        super(owner);
        this.initComponents();
        if (BSTAnimatedView.class.isInstance(this.getOwner().getViewer().getView()) || HuffmanView.class.isInstance(this.getOwner().getViewer().getView())) {
            this.makeDistancePanel();
            this.getContentPane().add(this.jPanel3);
            this.pack();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.incDxButton = new JButton();
        this.decDxButton = new JButton();
        this.jPanel2 = new JPanel();
        this.incDyButton = new JButton();
        this.decDyButton = new JButton();
        this.setTitle("View parameters");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Width manipulation"));
        this.jPanel1.setLayout(new GridLayout(1, 0, 2, 2));
        this.incDxButton.setText("Increase");
        this.incDxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.incDxButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.incDxButton);
        this.decDxButton.setText("Decrease");
        this.decDxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.decDxButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.decDxButton);
        this.getContentPane().add(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Height manipulation"));
        this.jPanel2.setLayout(new GridLayout(1, 0, 2, 2));
        this.incDyButton.setText("Increase");
        this.incDyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.incDyButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.incDyButton);
        this.decDyButton.setText("Decrease");
        this.decDyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.decDyButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.decDyButton);
        this.getContentPane().add(this.jPanel2);
        this.pack();
    }

    private void incDxButtonActionPerformed(ActionEvent evt) {
        AbstractBinaryTreeView p = BinaryTreeView.class.isInstance(this.getOwner().getViewer().getView()) ? (BinaryTreeView)this.getOwner().getViewer().getView() : (HuffmanView.class.isInstance(this.getOwner().getViewer().getView()) ? (HuffmanView)this.getOwner().getViewer().getView() : (BSTAnimatedView)this.getOwner().getViewer().getView());
        p.setDx(11 * p.getDx() / 10);
        try {
            this.getOwner().getViewer().getView().loadStructure();
            this.getOwner().getViewer().repaint();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void incDyButtonActionPerformed(ActionEvent evt) {
        AbstractBinaryTreeView p = BinaryTreeView.class.isInstance(this.getOwner().getViewer().getView()) ? (BinaryTreeView)this.getOwner().getViewer().getView() : (HuffmanView.class.isInstance(this.getOwner().getViewer().getView()) ? (HuffmanView)this.getOwner().getViewer().getView() : (BSTAnimatedView)this.getOwner().getViewer().getView());
        p.setDy(11 * p.getDy() / 10);
        try {
            this.getOwner().getViewer().getView().loadStructure();
            this.getOwner().getViewer().repaint();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void decDxButtonActionPerformed(ActionEvent evt) {
        AbstractBinaryTreeView p = BinaryTreeView.class.isInstance(this.getOwner().getViewer().getView()) ? (BinaryTreeView)this.getOwner().getViewer().getView() : (HuffmanView.class.isInstance(this.getOwner().getViewer().getView()) ? (HuffmanView)this.getOwner().getViewer().getView() : (BSTAnimatedView)this.getOwner().getViewer().getView());
        int dx = 9 * p.getDx() / 10;
        dx = (double)dx < (double)Node2D.getR() * 0.8 ? 4 * Node2D.getR() / 5 : dx;
        p.setDx(dx);
        try {
            this.getOwner().getViewer().getView().loadStructure();
            this.getOwner().getViewer().repaint();
        }
        catch (Error ex) {
            // empty catch block
        }
    }

    private void decDyButtonActionPerformed(ActionEvent evt) {
        AbstractBinaryTreeView p = BinaryTreeView.class.isInstance(this.getOwner().getViewer().getView()) ? (BinaryTreeView)this.getOwner().getViewer().getView() : (HuffmanView.class.isInstance(this.getOwner().getViewer().getView()) ? (HuffmanView)this.getOwner().getViewer().getView() : (BSTAnimatedView)this.getOwner().getViewer().getView());
        int dy = 9 * p.getDy() / 10;
        dy = (double)dy < (double)Node2D.getR() * 1.33 ? 4 * Node2D.getR() / 3 : dy;
        p.setDy(dy);
        try {
            this.getOwner().getViewer().getView().loadStructure();
            this.getOwner().getViewer().repaint();
        }
        catch (Error ex) {
            // empty catch block
        }
    }

    public void reposition() {
        Rectangle r = this.getOwner().getFrame2().getBounds();
        this.setBounds(this.getOwner().getDesktop().getBounds().width - r.width, r.height + 10, r.width, this.getHeight());
        this.setVisible(true);
    }

    public void paint(Graphics g) {
        if (BSTAnimatedView.class.isInstance(this.getOwner().getViewer().getView())) {
            BSTAnimatedView v = (BSTAnimatedView)this.getOwner().getViewer().getView();
            if (this.getOwner().getViewer().isPaused()) {
                this.decDxButton.setEnabled(true);
                this.decDyButton.setEnabled(true);
                this.incDxButton.setEnabled(true);
                this.incDyButton.setEnabled(true);
                this.pack();
            } else {
                this.decDxButton.setEnabled(false);
                this.decDyButton.setEnabled(false);
                this.incDxButton.setEnabled(false);
                this.incDyButton.setEnabled(false);
                this.pack();
            }
        }
        super.paint(g);
    }

    public void makeDistancePanel() {
        this.jPanel3 = new JPanel();
        this.incDistance = new JButton();
        this.decDistance = new JButton();
        this.jButton1 = new JButton();
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Animated key position"));
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.incDistance.setText("Left");
        this.incDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.incDistanceButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.incDistance);
        this.jButton1.setText("Center");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.centerKeyPositionActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.decDistance.setText("Right");
        this.decDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameBSTViewParams.this.decDistanceButtonActionPerformed(evt);
            }
        });
        this.decDistance.setFont(new Font("Tahoma", 1, 11));
        this.jPanel3.add(this.decDistance);
        this.getContentPane().add(this.jPanel3);
    }

    private void decDistanceButtonActionPerformed(ActionEvent evt) {
        if (BSTAnimatedView.class.isInstance(this.getOwner().getViewer().getView())) {
            BSTAnimatedView v = (BSTAnimatedView)this.getOwner().getViewer().getView();
            v.setKeyDistance(30);
        } else {
            HuffmanView v = (HuffmanView)this.getOwner().getViewer().getView();
            v.setKeyDistance(30);
        }
        this.decDistance.setFont(new Font("Tahoma", 1, 11));
        this.incDistance.setFont(new Font("Tahoma", 0, 11));
        this.jButton1.setFont(new Font("Tahoma", 0, 11));
    }

    private void centerKeyPositionActionPerformed(ActionEvent evt) {
        if (BSTAnimatedView.class.isInstance(this.getOwner().getViewer().getView())) {
            BSTAnimatedView v = (BSTAnimatedView)this.getOwner().getViewer().getView();
            v.setKeyDistance(0);
        } else {
            HuffmanView v = (HuffmanView)this.getOwner().getViewer().getView();
            v.setKeyDistance(0);
        }
        this.decDistance.setFont(new Font("Tahoma", 0, 11));
        this.incDistance.setFont(new Font("Tahoma", 0, 11));
        this.jButton1.setFont(new Font("Tahoma", 1, 11));
    }

    private void incDistanceButtonActionPerformed(ActionEvent evt) {
        if (BSTAnimatedView.class.isInstance(this.getOwner().getViewer().getView())) {
            BSTAnimatedView v = (BSTAnimatedView)this.getOwner().getViewer().getView();
            v.setKeyDistance(-30);
        } else {
            HuffmanView v = (HuffmanView)this.getOwner().getViewer().getView();
            v.setKeyDistance(-30);
        }
        this.decDistance.setFont(new Font("Tahoma", 0, 11));
        this.incDistance.setFont(new Font("Tahoma", 1, 11));
        this.jButton1.setFont(new Font("Tahoma", 0, 11));
    }
}

