/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import error.Error;
import gui.MyJFrame;
import java.awt.BasicStroke;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import structure.ObservabileGraph;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;
import viewer.GraphViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawGraphDialog
extends JDialog
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    private int button;
    private double zoom = 1.0;
    private int mX;
    private int mY;
    private int mouseX;
    private int mouseY;
    private int centerX;
    private int centerY;
    private State state;
    private boolean finished;
    private char ukID = (char)65;
    private GraphViewer vg;
    private boolean directed = true;
    private Branch2D selectedBranch;
    private Node2D from;
    private Node2D to;
    private Node2D newNode;
    private Node2D selectedNode;
    private JPopupMenu popupMenuNode = new JPopupMenu();
    private JPopupMenu popupMenuBranch = new JPopupMenu();
    private LinkedList<Node2D> nodes = new LinkedList();
    private LinkedList<Branch2D> branches = new LinkedList();
    private ObservabileGraph graph = new ObservabileGraph(null, 0);
    private static final RenderingHints HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private JToggleButton addBranchDir;
    private JToggleButton addBranchTwoWay;
    private JToggleButton addNode;
    private ButtonGroup buttonGroup1;
    private JToggleButton freeHandTool;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JToggleButton moveButton;
    private JPanel panel;
    private JToolBar toolbar;

    public DrawGraphDialog(GraphViewer pg) {
        this.initComponents();
        this.vg = pg;
        this.addPopupMenuNode();
        this.addPopupMenuBranch();
        this.state = State.HAND_TOOL;
        this.panel.addMouseListener(this);
        this.panel.addMouseWheelListener(this);
        this.panel.addMouseMotionListener(this);
        this.freeHandTool.requestFocusInWindow();
        this.setSize(pg.getWidth(), pg.getHeight() + 30);
        this.panel.setPreferredSize(new Dimension(pg.getWidth() - 140, this.getHeight()));
        MyJFrame.centerPosition(this);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setTitle("Draw Graph Dialog");
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/gui/images/draw-16px.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panel = new DrawGraphJPanel();
        this.toolbar = new JToolBar();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.addNode = new JToggleButton();
        this.addBranchDir = new JToggleButton();
        this.addBranchTwoWay = new JToggleButton();
        this.freeHandTool = new JToggleButton();
        this.moveButton = new JToggleButton();
        this.jPanel4 = new JPanel();
        this.buttonGroup1.add(this.addNode);
        this.buttonGroup1.add(this.addBranchDir);
        this.buttonGroup1.add(this.addBranchTwoWay);
        this.buttonGroup1.add(this.freeHandTool);
        this.buttonGroup1.add(this.moveButton);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.panel.setBorder(BorderFactory.createTitledBorder("Drawing surface"));
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 314, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 270, Short.MAX_VALUE));
        this.getContentPane().add(this.panel);
        this.toolbar.setBorder(BorderFactory.createTitledBorder("Toolbar"));
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setMaximumSize(new Dimension(150, 65564));
        this.toolbar.setMinimumSize(new Dimension(120, 180));
        this.toolbar.setPreferredSize(new Dimension(120, 152));
        this.jPanel3.setMinimumSize(new Dimension(100, 150));
        this.jPanel3.setPreferredSize(new Dimension(120, 150));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 3));
        this.jPanel2.setPreferredSize(new Dimension(120, 75));
        this.jPanel2.setLayout(new GridLayout(3, 0, 3, 3));
        this.addNode.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/addnode.png")));
        this.addNode.setToolTipText("Add new node");
        this.addNode.setMargin(new Insets(2, 2, 2, 2));
        this.addNode.setMinimumSize(new Dimension(52, 52));
        this.addNode.setPreferredSize(new Dimension(52, 52));
        this.addNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DrawGraphDialog.this.addNodeActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.addNode);
        this.addBranchDir.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/branch-twoway.png")));
        this.addBranchDir.setToolTipText("Connect nodes via bidirectional branches");
        this.addBranchDir.setMargin(new Insets(2, 2, 2, 2));
        this.addBranchDir.setMinimumSize(new Dimension(52, 52));
        this.addBranchDir.setPreferredSize(new Dimension(52, 52));
        this.addBranchDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DrawGraphDialog.this.addBranchDirActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.addBranchDir);
        this.addBranchTwoWay.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/branch-dir.png")));
        this.addBranchTwoWay.setToolTipText("Connect nodes via directed branches");
        this.addBranchTwoWay.setMargin(new Insets(2, 2, 2, 2));
        this.addBranchTwoWay.setMinimumSize(new Dimension(52, 52));
        this.addBranchTwoWay.setPreferredSize(new Dimension(52, 52));
        this.addBranchTwoWay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DrawGraphDialog.this.addBranchTwoWayActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.addBranchTwoWay);
        this.freeHandTool.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/hand.png")));
        this.freeHandTool.setSelected(true);
        this.freeHandTool.setToolTipText("Reposition nodes");
        this.freeHandTool.setMargin(new Insets(2, 2, 2, 2));
        this.freeHandTool.setMinimumSize(new Dimension(52, 52));
        this.freeHandTool.setPreferredSize(new Dimension(52, 52));
        this.freeHandTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DrawGraphDialog.this.freeHandToolActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.freeHandTool);
        this.moveButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/move.png")));
        this.moveButton.setToolTipText("Move your screen");
        this.moveButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveButton.setMinimumSize(new Dimension(52, 52));
        this.moveButton.setPreferredSize(new Dimension(52, 52));
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DrawGraphDialog.this.moveButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.moveButton);
        this.jPanel3.add(this.jPanel2);
        this.jPanel4.setPreferredSize(new Dimension(85, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 104, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 108, Short.MAX_VALUE));
        this.jPanel3.add(this.jPanel4);
        this.toolbar.add(this.jPanel3);
        this.getContentPane().add(this.toolbar);
        this.pack();
    }

    private void addNodeActionPerformed(ActionEvent evt) {
        this.state = this.state != State.NODE_ADD ? State.NODE_ADD : State.HAND_TOOL;
        if (this.state == State.NODE_ADD) {
            this.newNode = new Node2D(this.mouseX, this.mouseY);
            char c = this.ukID;
            this.ukID = (char)(c + '\u0001');
            this.newNode.setName("" + c);
        } else {
            this.newNode = null;
        }
    }

    private void freeHandToolActionPerformed(ActionEvent evt) {
        if (!this.freeHandTool.isSelected()) {
            this.freeHandTool.setSelected(true);
        }
        this.state = State.HAND_TOOL;
    }

    private void moveButtonActionPerformed(ActionEvent evt) {
        if (!this.moveButton.isSelected()) {
            this.moveButton.setSelected(true);
        }
        this.state = State.MOVE_TOOL;
    }

    private void addBranchDirActionPerformed(ActionEvent evt) {
        if (!this.addBranchDir.isSelected()) {
            this.addBranchDir.setSelected(true);
        }
        this.state = State.BRANCH_ADD;
        this.directed = false;
    }

    private void addBranchTwoWayActionPerformed(ActionEvent evt) {
        if (!this.addBranchTwoWay.isSelected()) {
            this.addBranchTwoWay.setSelected(true);
        }
        this.state = State.BRANCH_ADD;
        this.directed = true;
    }

    public boolean isGotovo() {
        return this.finished;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateMouseCoordinates(e);
        switch (this.state) {
            case HAND_TOOL: {
                this.nodeSelection();
                break;
            }
            case BRANCH_ADD: {
                break;
            }
            case NODE_ADD: {
                this.newNode.setX(this.mouseX);
                this.newNode.setY(this.mouseY);
                this.nodes.add(this.newNode);
                this.graph.addNode(this.newNode.getName());
                this.state = State.HAND_TOOL;
                this.freeHandTool.setSelected(true);
                this.freeHandTool.requestFocusInWindow();
            }
        }
        this.newNode = null;
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double zoomOld = this.zoom;
        this.zoom += (double)e.getWheelRotation() * 0.1;
        this.zoom = this.zoom <= 0.0 ? 0.05 : this.zoom;
        this.updateMouseCoordinates(zoomOld, this.zoom);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateMouseCoordinates(e);
        this.nodeSelection();
        this.branchSelection();
        this.button = e.getButton();
        if (this.state == State.BRANCH_ADD && this.button == 1) {
            this.from = this.selectedNode;
            if (this.selectedNode == null) {
                JOptionPane.showMessageDialog(this, "You have to select a node", "Error Dialog", 0);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateMouseCoordinates(e);
        this.nodeSelection();
        this.branchSelection();
        this.showPopupMenu(e);
        if (this.state == State.BRANCH_ADD) {
            this.to = this.selectedNode;
            if (this.from == null) {
                return;
            }
            if (this.to == null) {
                this.from = null;
                JOptionPane.showMessageDialog(this, "You have to select a node", "Error Dialog", 0);
                this.repaint();
                return;
            }
            if (this.from != this.to) {
                boolean bidirectional = false;
                for (Branch2D g : this.branches) {
                    if (g.getTo() == this.from && g.getFrom() == this.to) {
                        bidirectional = true;
                        g.setBidirectional(true);
                        continue;
                    }
                    if (g.getTo() != this.to || g.getFrom() != this.from) continue;
                    if (!this.directed) {
                        g.setBidirectional(true);
                        this.graph.addBranch(this.to.getName(), this.from.getName());
                    }
                    this.from = null;
                    return;
                }
                if (!bidirectional) {
                    Branch2D tmp = new Branch2D(this.from, this.to, "0");
                    tmp.setBidirectional(!this.directed);
                    this.branches.add(tmp);
                    if (!this.directed) {
                        this.graph.addBranch(this.to.getName(), this.from.getName());
                    }
                }
                this.graph.addBranch(this.from.getName(), this.to.getName());
            }
            this.to = null;
            this.from = null;
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.button != 1) {
            return;
        }
        if (this.state == State.BRANCH_ADD) {
            this.updateMouseCoordinates(e);
        }
        if (this.state == State.NODE_ADD) {
            this.updateMouseCoordinates(e);
            this.setNodeCoordinates(this.mouseX, this.mouseY, this.newNode);
        }
        if (this.state == State.HAND_TOOL) {
            this.updateMouseCoordinates(e);
            this.setNodeCoordinates(this.mouseX, this.mouseY, this.selectedNode);
        }
        if (this.state == State.MOVE_TOOL) {
            int dx = this.mX - e.getX();
            int dy = this.mY - e.getY();
            this.centerX -= dx;
            this.centerY -= dy;
            this.updateMouseCoordinates(e);
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateMouseCoordinates(e);
        this.setNodeCoordinates(this.mouseX, this.mouseY, this.newNode);
        this.repaint();
    }

    private void updateMouseCoordinates(MouseEvent e) {
        this.mX = e.getX();
        this.mY = e.getY();
        this.mouseX = (int)((double)(this.mX - this.centerX) / this.zoom);
        this.mouseY = (int)((double)(this.mY - this.centerY) / this.zoom);
    }

    private void updateMouseCoordinates(double zoomOld, double zoomNew) {
        this.mouseX = (int)((double)this.mouseX * (zoomOld / zoomNew));
        this.mouseY = (int)((double)this.mouseY * (zoomOld / zoomNew));
    }

    private void nodeSelection() {
        this.selectedNode = null;
        for (Node2D c : this.nodes) {
            if (!c.intersects(this.mouseX - 5, this.mouseY - 5, 10.0, 10.0)) continue;
            this.selectedNode = c;
            break;
        }
    }

    private void branchSelection() {
        this.selectedBranch = null;
        for (Branch2D g : this.branches) {
            if (!g.intersects(this.mouseX - 4, this.mouseY - 4, 8.0, 8.0)) continue;
            this.selectedBranch = g;
            break;
        }
    }

    private void setNodeCoordinates(int x, int y, Node2D node) {
        if (node == null) {
            return;
        }
        node.setX(x);
        node.setY(y);
    }

    private void showPopupMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.selectedNode != null) {
            this.popupMenuNode.show(e.getComponent(), e.getX(), e.getY());
        } else if (this.selectedBranch != null) {
            this.popupMenuBranch.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void addPopupMenuNode() {
        ActionListener handler = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("Delete")) {
                    DrawGraphDialog.this.getNodes().remove(DrawGraphDialog.this.selectedNode);
                    LinkedList<Branch2D> forDelete = new LinkedList<Branch2D>();
                    for (Branch2D branch : DrawGraphDialog.this.getBranches()) {
                        if (branch.getFrom() != DrawGraphDialog.this.selectedNode && branch.getTo() != DrawGraphDialog.this.selectedNode) continue;
                        forDelete.add(branch);
                    }
                    DrawGraphDialog.this.getBranches().removeAll(forDelete);
                    DrawGraphDialog.this.getGraph().removeNode(DrawGraphDialog.this.selectedNode.getName());
                }
                DrawGraphDialog.this.selectedNode = null;
                DrawGraphDialog.this.repaint();
            }
        };
        JMenuItem option = new JMenuItem("Delete");
        option.addActionListener(handler);
        this.popupMenuNode.add(option);
    }

    private void addPopupMenuBranch() {
        final DrawGraphDialog diag = this;
        ActionListener handler = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                String from = DrawGraphDialog.this.selectedBranch.getFrom().getName();
                String to = DrawGraphDialog.this.selectedBranch.getTo().getName();
                if (command.equals("Set weight")) {
                    new BranchWeightJDialog(diag);
                } else if (command.equals("Directed")) {
                    DrawGraphDialog.this.selectedBranch.setBidirectional(false);
                    try {
                        DrawGraphDialog.this.getGraph().removeBranch(to, from);
                    }
                    catch (Error error) {}
                } else if (command.equals("Bidirectional")) {
                    DrawGraphDialog.this.selectedBranch.setBidirectional(true);
                    DrawGraphDialog.this.getGraph().addBranch(to, from);
                    try {
                        DrawGraphDialog.this.getGraph().writeBranchWeight(to, from, DrawGraphDialog.this.getGraph().readWeight(from, to));
                    }
                    catch (Error error) {}
                } else if (command.equals("Delete")) {
                    try {
                        DrawGraphDialog.this.getBranches().remove(DrawGraphDialog.this.selectedBranch);
                        DrawGraphDialog.this.getGraph().removeBranch(from, to);
                        if (DrawGraphDialog.this.selectedBranch.isBidirectional()) {
                            DrawGraphDialog.this.getGraph().removeBranch(to, from);
                        }
                        System.out.println(DrawGraphDialog.this.getGraph());
                    }
                    catch (Error error) {
                        error.printStackTrace(System.err);
                    }
                }
                if (!command.equals("Set weight")) {
                    DrawGraphDialog.this.selectedBranch = null;
                }
                DrawGraphDialog.this.repaint();
            }
        };
        JMenuItem option = new JMenuItem("Set weight");
        option.addActionListener(handler);
        this.popupMenuBranch.add(option);
        option = new JMenuItem("Directed");
        option.addActionListener(handler);
        this.popupMenuBranch.add(option);
        option = new JMenuItem("Bidirectional");
        option.addActionListener(handler);
        this.popupMenuBranch.add(option);
        option = new JMenuItem("Delete");
        option.addActionListener(handler);
        this.popupMenuBranch.add(option);
    }

    public ObservabileGraph getGraph() {
        return this.graph;
    }

    public void setGraph(ObservabileGraph graph) {
        this.graph = graph;
        graph.resetNodeAndBranchStatus();
    }

    public LinkedList<Node2D> getNodes() {
        return this.nodes;
    }

    public LinkedList<Branch2D> getBranches() {
        return this.branches;
    }

    public void setNodes(LinkedList<Node2D> nodes) {
        this.nodes = nodes;
        if (nodes != null && nodes.size() > 0) {
            this.ukID = (char)(nodes.getLast().getName().charAt(0) + '\u0001');
        }
    }

    public void setBranches(LinkedList<Branch2D> branches) {
        this.branches = branches;
    }

    private class BranchWeightJDialog
    extends JDialog {
        JPanel panel;
        JButton apply;
        JButton cancel;
        JTextField w;

        BranchWeightJDialog(JDialog owner) {
            super((Dialog)owner, "Set branch weight");
            this.panel = new JPanel();
            this.apply = new JButton("Apply");
            this.cancel = new JButton("Cancel");
            this.w = new JTextField(10);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            KeyAdapter key = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        BranchWeightJDialog.this.applyWeight();
                    } else if (key == 27) {
                        BranchWeightJDialog.this.dispose();
                    }
                }
            };
            ActionListener handler = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    if (command.equals("Apply")) {
                        BranchWeightJDialog.this.applyWeight();
                    } else if (command.equals("Cancel")) {
                        BranchWeightJDialog.this.dispose();
                    }
                    DrawGraphDialog.this.selectedBranch = null;
                }
            };
            this.w.addKeyListener(key);
            this.apply.addActionListener(handler);
            this.cancel.addActionListener(handler);
            this.addKeyListener(key);
            this.panel.add(this.w);
            this.panel.add(this.apply);
            this.panel.add(this.cancel);
            this.setContentPane(this.panel);
            this.setDefaultCloseOperation(2);
            this.setSize(250, 65);
            MyJFrame.centerPosition(this);
            this.setVisible(true);
        }

        private void applyWeight() {
            try {
                int weight = Integer.parseInt(this.w.getText());
                DrawGraphDialog.this.selectedBranch.setWeight("" + weight);
                String from = DrawGraphDialog.this.selectedBranch.getFrom().getName();
                String to = DrawGraphDialog.this.selectedBranch.getTo().getName();
                DrawGraphDialog.this.getGraph().writeBranchWeight(from, to, "" + weight);
                if (DrawGraphDialog.this.selectedBranch.isBidirectional()) {
                    DrawGraphDialog.this.getGraph().writeBranchWeight(to, from, "" + weight);
                }
                this.dispose();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.panel, "Invalid input - must be integer value", "Error Dialog", 0);
                ex.printStackTrace(System.err);
                return;
            }
        }
    }

    private class DrawGraphJPanel
    extends JPanel {
        private DrawGraphJPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2D = (Graphics2D)g;
            AffineTransform old = g2D.getTransform();
            AffineTransform tf = new AffineTransform();
            tf.translate(DrawGraphDialog.this.centerX, DrawGraphDialog.this.centerY);
            tf.scale(DrawGraphDialog.this.zoom, DrawGraphDialog.this.zoom);
            g2D.transform(tf);
            g2D.setRenderingHints(HINTS);
            if (DrawGraphDialog.this.state == State.BRANCH_ADD && DrawGraphDialog.this.from != null) {
                Stroke tmp = g2D.getStroke();
                float[] dash = new float[]{5.0f};
                g2D.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, dash, 0.0f));
                g2D.drawLine((int)DrawGraphDialog.this.from.getX(), (int)DrawGraphDialog.this.from.getY(), DrawGraphDialog.this.mouseX, DrawGraphDialog.this.mouseY);
                g2D.setStroke(tmp);
            }
            for (Branch2D grana : DrawGraphDialog.this.getBranches()) {
                grana.draw(g2D);
            }
            for (Node2D node : DrawGraphDialog.this.getNodes()) {
                node.paint(g2D);
            }
            if (DrawGraphDialog.this.newNode != null && DrawGraphDialog.this.state == State.NODE_ADD) {
                DrawGraphDialog.this.newNode.paint(g2D);
            }
            g2D.setTransform(old);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BRANCH_ADD,
        NODE_ADD,
        HAND_TOOL,
        MOVE_TOOL;

    }
}

