/*
 * Decompiled with CFR 0.152.
 */
package gui.array;

import algorithm.Algorithm;
import algorithm.array.AlgShellSort;
import algorithm.array.AlgSort;
import error.Error;
import gui.AbstractSimulationFrame;
import gui.array.InternalFrameArray;
import gui.array.InternalFrameRadioSelection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileVariable;
import view.AbstractView;
import viewer.ArrayViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationFrameArray
extends AbstractSimulationFrame {
    LinkedList<String> shellList = new LinkedList();

    public SimulationFrameArray(AbstractView view) {
        super(view);
    }

    @Override
    protected void initComponents(AbstractView view) throws Error {
        super.initComponents(view);
        this.viewer = new ArrayViewer(view);
        this.createAndStartViewerThread();
        this.frame2 = new InternalFrameArray(this);
        if (AlgShellSort.class.isInstance(this.viewer.getView().getAlgorithm())) {
            this.frame3 = new InternalFrameRadioSelection(this);
            this.getDesktop().add(this.frame3);
            this.frame3.reposition();
        }
    }

    public void setElems(LinkedList<String> elems, boolean asc) {
        this.elems = elems;
        try {
            this.playbackControlPanel.stop();
            Object[] el = new String[elems.size()];
            el = elems.toArray(el);
            AbstractView p = this.viewer.getView();
            Algorithm alg = p.getAlgorithm();
            Algorithm a = (Algorithm)alg.getClass().newInstance();
            if (AlgShellSort.class.isInstance(this.viewer.getView().getAlgorithm())) {
                InternalFrameRadioSelection fr = (InternalFrameRadioSelection)this.frame3;
                AlgShellSort al = (AlgShellSort)a;
                if (this.shellList.size() > 0) {
                    al.setSequence(this.shellList);
                }
            }
            ObservabileVariable[] structs = null;
            structs = a.makeStructures(el);
            ((AlgSort)a).setAscending(asc);
            a.run(structs);
            p.setAlgorithm(a);
            this.viewer.setView(p);
            this.createAndStartViewerThread();
            this.viewer.repaint();
            this.playbackControlPanel.enablePlayback(0);
        }
        catch (InstantiationException ex) {
            this.playbackControlPanel.disablePlayback();
        }
        catch (IllegalAccessException ex) {
            this.playbackControlPanel.disablePlayback();
        }
        catch (Error e) {
            this.playbackControlPanel.disablePlayback();
            this.error(e.getErrorMessage());
        }
    }

    public void inputSequenceShell(LinkedList<String> ele) {
        this.shellList = ele;
        if (AlgShellSort.class.isInstance(this.viewer.getView().getAlgorithm())) {
            AlgShellSort al = (AlgShellSort)this.viewer.getView().getAlgorithm();
            al.setSequence(ele);
        }
    }

    public void updateElems() throws Error {
        ObservabileArray a = (ObservabileArray)this.viewer.getView().getCurrentStructures()[0];
        int n = a.getNumOfElem();
        this.elems.clear();
        for (int i = 0; i < n; ++i) {
            this.elems.add(a.readElem(i));
        }
        ((InternalFrameArray)this.frame2).setElems(this.elems);
    }

    @Override
    protected void openStructures(File file) throws FileNotFoundException, IOException, Error, ClassNotFoundException {
        super.openStructures(file);
        this.updateElems();
    }

    @Override
    protected void loadStruct(File file) throws Error, FileNotFoundException, IOException, ClassNotFoundException {
        super.loadStruct(file);
        this.updateElems();
    }
}

