/*
 * Decompiled with CFR 0.152.
 */
package gui.array;

import gui.MyInternalFrame;
import gui.array.SimulationFrameArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalFrameArray
extends MyInternalFrame {
    private LinkedList<String> elems = new LinkedList();
    private JPanel actionsPanel;
    private JButton applyButton;
    private JTextArea arrayElementsTextArea;
    private JPanel contentPanel;
    private JScrollPane jScrollPane1;
    private JToggleButton orderButton;

    public InternalFrameArray(SimulationFrameArray owner) {
        super(owner);
        this.initComponents();
    }

    @Override
    public void reposition() {
        if (this.getDesktopPane() == null) {
            return;
        }
        Rectangle r = this.getDesktopPane().getBounds();
        this.setLocation((int)(r.getWidth() - (double)this.getWidth()), 0);
        this.setVisible(true);
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.arrayElementsTextArea = new JTextArea();
        this.actionsPanel = new JPanel();
        this.applyButton = new JButton();
        this.orderButton = new JToggleButton();
        this.setTitle("Array operations");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Input array"));
        this.jScrollPane1.setMinimumSize(new Dimension(37, 70));
        this.jScrollPane1.setPreferredSize(new Dimension(116, 80));
        this.arrayElementsTextArea.setColumns(12);
        this.arrayElementsTextArea.setFont(new Font("Tahoma", 0, 11));
        this.arrayElementsTextArea.setLineWrap(true);
        this.arrayElementsTextArea.setRows(2);
        this.jScrollPane1.setViewportView(this.arrayElementsTextArea);
        this.contentPanel.add(this.jScrollPane1);
        this.actionsPanel.setBorder(BorderFactory.createTitledBorder("Actions"));
        this.actionsPanel.setMinimumSize(new Dimension(188, 50));
        this.actionsPanel.setPreferredSize(new Dimension(254, 55));
        this.actionsPanel.setLayout(new GridLayout(1, 0, 10, 10));
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameArray.this.applyButtonActionPerformed(evt);
            }
        });
        this.actionsPanel.add(this.applyButton);
        this.orderButton.setSelected(true);
        this.orderButton.setText("Ascending");
        this.orderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InternalFrameArray.this.orderButtonActionPerformed(evt);
            }
        });
        this.actionsPanel.add(this.orderButton);
        this.contentPanel.add(this.actionsPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.pack();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        String[] el;
        this.elems.clear();
        for (String s : el = this.arrayElementsTextArea.getText().split("[ \n]+")) {
            if (s.equals("")) continue;
            this.elems.add(s);
        }
        ((SimulationFrameArray)this.getOwner()).setElems(this.elems, this.orderButton.isSelected());
    }

    private void orderButtonActionPerformed(ActionEvent evt) {
        ((SimulationFrameArray)this.getOwner()).setElems(this.elems, this.orderButton.isSelected());
        if (this.orderButton.isSelected()) {
            this.orderButton.setText("Ascending");
        } else {
            this.orderButton.setText("Descending");
        }
    }

    public LinkedList<String> getElems() {
        return this.elems;
    }

    public void setElems(LinkedList<String> elems) {
        this.elems = elems;
    }
}

