/*
 * Decompiled with CFR 0.152.
 */
package gui;

import error.Error;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.AbstractViewer;
import viewer.SimulationListener;

public class PlaybackControlPanel
extends JPanel
implements SimulationListener {
    private JFrame owner;
    private AbstractViewer viewer;
    private Thread viewerThread;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton nextButton;
    private JButton pauseButton;
    private JButton playButton;
    private JButton previousButton;
    private JSlider slider;
    private JButton slowDownButton;
    private JButton speedUpButton;
    private JButton stopButton;

    public PlaybackControlPanel() {
        this(null, null);
    }

    public PlaybackControlPanel(AbstractViewer prikazivac, Thread prikazivackaNit) {
        this.viewer = prikazivac;
        this.viewerThread = prikazivackaNit;
        this.initComponents();
        if (prikazivac != null && !prikazivac.hasWork()) {
            this.disablePlayback();
        }
    }

    public void enablePlayback(int index) {
        this.updateCommandButtonsStart();
        this.updateJSlider(index);
    }

    public void disablePlayback() {
        this.playButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.speedUpButton.setEnabled(false);
        this.slowDownButton.setEnabled(false);
    }

    public void stop() throws Error {
        this.viewer.stop();
        this.viewerThread.interrupt();
        this.slider.setValue(0);
    }

    public void play() throws Error {
        this.viewer.play();
    }

    public void previous() throws Error {
        this.viewer.previous();
    }

    public void next() throws Error {
        if (this.viewer.next()) {
            this.nextButton.setEnabled(false);
        }
    }

    public void pause() {
        this.viewer.setPaused(true);
        this.viewerThread.interrupt();
        this.playButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
    }

    public AbstractViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(AbstractViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeSimulationFinishedListener(this);
        }
        this.viewer = viewer;
        viewer.addSimulationFinishedListener(this);
        if (viewer != null) {
            this.updateJSlider(0);
            if (!viewer.hasWork()) {
                this.disablePlayback();
            }
        }
    }

    public Thread getViewerThread() {
        return this.viewerThread;
    }

    public void setViewerThread(Thread viewerThread) {
        this.viewerThread = viewerThread;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(JButton nextButton) {
        this.nextButton = nextButton;
    }

    public JButton getPauseButton() {
        return this.pauseButton;
    }

    public void setPauseButton(JButton pauseButton) {
        this.pauseButton = pauseButton;
    }

    public JButton getPlayButton() {
        return this.playButton;
    }

    public void setPlayButton(JButton playButton) {
        this.playButton = playButton;
    }

    public JButton getPreviousButton() {
        return this.previousButton;
    }

    public void setPreviousButton(JButton previousButton) {
        this.previousButton = previousButton;
    }

    public JButton getStopButton() {
        return this.stopButton;
    }

    public void setStopButton(JButton stopButton) {
        this.stopButton = stopButton;
    }

    public void simulationFinished() {
        this.updateCommandButtonsEnd();
    }

    public void updateJSlider() {
        int min = 0;
        int max = 0;
        if (this.viewer != null) {
            max = this.viewer.getView().getActions().size();
        }
        this.slider.setMinimum(min);
        this.slider.setMaximum(max > 0 ? max - 1 : max);
    }

    public void updateJSlider(int index) {
        this.updateJSlider();
        this.slider.setValue(index);
        int max = this.slider.getMaximum();
        int min = this.slider.getMinimum();
        int majTS = max / 20;
        int minTS = min / 100;
        if (max < 20) {
            this.setJSlider(1, 5);
        } else if (max < 100) {
            this.setJSlider(1, 10);
        } else {
            this.setJSlider(minTS, majTS);
        }
        if (this.viewer != null && !this.viewer.hasWork()) {
            this.disablePlayback();
        }
    }

    private void setJSlider(int minTS, int majTS) {
        this.slider.setMajorTickSpacing(majTS);
        this.slider.setMinorTickSpacing(minTS);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.slider = new JSlider();
        this.jPanel1 = new JPanel();
        this.slowDownButton = new JButton();
        this.previousButton = new JButton();
        this.playButton = new JButton();
        this.pauseButton = new JButton();
        this.nextButton = new JButton();
        this.stopButton = new JButton();
        this.speedUpButton = new JButton();
        this.setBackground(new Color(234, 234, 234));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 180));
        this.setMinimumSize(new Dimension(315, 67));
        this.setPreferredSize(new Dimension(315, 105));
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel2.setBackground(new Color(234, 234, 234));
        this.jPanel2.setLayout(new BorderLayout());
        this.updateJSlider(0);
        this.slider.setBackground(new Color(234, 234, 234));
        this.slider.setForeground(new Color(0, 0, 0));
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PlaybackControlPanel.this.sliderStateChanged(evt);
            }
        });
        this.jPanel2.add((Component)this.slider, "Center");
        this.add(this.jPanel2);
        this.jPanel1.setBackground(new Color(234, 234, 234));
        this.slowDownButton.setBackground(new Color(234, 234, 234));
        this.slowDownButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/slower.png")));
        this.slowDownButton.setToolTipText("Slow down the presentation");
        this.slowDownButton.setEnabled(false);
        this.slowDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.slowDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.slowDownButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.slowDownButton);
        this.previousButton.setBackground(new Color(234, 234, 234));
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/rewind.png")));
        this.previousButton.setToolTipText("Previous action");
        this.previousButton.setEnabled(false);
        this.previousButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.previousButton);
        this.playButton.setBackground(new Color(234, 234, 234));
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/play.png")));
        this.playButton.setToolTipText("Play");
        this.playButton.setEnabled(false);
        this.playButton.setMargin(new Insets(2, 2, 2, 2));
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.playButton);
        this.pauseButton.setBackground(new Color(234, 234, 234));
        this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/pause.png")));
        this.pauseButton.setToolTipText("Pause");
        this.pauseButton.setEnabled(false);
        this.pauseButton.setMargin(new Insets(2, 2, 2, 2));
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.pauseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.pauseButton);
        this.nextButton.setBackground(new Color(234, 234, 234));
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/forward.png")));
        this.nextButton.setToolTipText("Next action");
        this.nextButton.setEnabled(false);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.nextButton);
        this.stopButton.setBackground(new Color(234, 234, 234));
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/stop.png")));
        this.stopButton.setToolTipText("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.setMargin(new Insets(2, 2, 2, 2));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.stopButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopButton);
        this.speedUpButton.setBackground(new Color(234, 234, 234));
        this.speedUpButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/faster.png")));
        this.speedUpButton.setToolTipText("Speed up the presentation");
        this.speedUpButton.setEnabled(false);
        this.speedUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.speedUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlaybackControlPanel.this.speedUpButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.speedUpButton);
        this.add(this.jPanel1);
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        try {
            this.previous();
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(this.viewer, e.getErrorMessage(), "Error Dialog", 0);
        }
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        try {
            this.play();
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(this.viewer, e.getErrorMessage(), "Error Dialog", 0);
        }
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        this.pause();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        try {
            this.next();
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(this.viewer, e.getErrorMessage(), "Error Dialog", 0);
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        try {
            this.stop();
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(this.viewer, e.getErrorMessage(), "Error Dialog", 0);
        }
    }

    private void sliderStateChanged(ChangeEvent evt) {
        JSlider source = (JSlider)evt.getSource();
        if (!source.getValueIsAdjusting()) {
            int index = source.getValue();
            try {
                this.updateButtons(index);
                this.viewer.getView().setCurrentIndex(index);
                this.viewer.repaint();
                if (this.viewer != null && !this.viewer.hasWork()) {
                    this.disablePlayback();
                }
            }
            catch (Error e) {
                System.out.println(e.getErrorMessage());
            }
        }
    }

    private void slowDownButtonActionPerformed(ActionEvent evt) {
        this.viewer.decreaseSpeed();
        this.owner.setTitle(this.viewer.getView().algorithmName() + " " + this.viewer.getSpeed());
    }

    private void speedUpButtonActionPerformed(ActionEvent evt) {
        this.viewer.increaseSpeed();
        this.owner.setTitle(this.viewer.getView().algorithmName() + " " + this.viewer.getSpeed());
    }

    public void updateButtons(int currentIndex) {
        if (this.viewer.isPaused()) {
            this.playButton.setEnabled(true);
        } else if (currentIndex > 0) {
            this.pauseButton.setEnabled(true);
        }
        if (currentIndex == 0) {
            this.updateCommandButtonsStart();
        } else if (currentIndex == this.slider.getMaximum()) {
            this.updateCommandButtonsEnd();
        } else {
            this.updateCommandButtonsRunning();
        }
    }

    protected void updateCommandButtonsStart() {
        this.nextButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.speedUpButton.setEnabled(true);
        this.slowDownButton.setEnabled(true);
    }

    protected void updateCommandButtonsRunning() {
        this.viewer.setFinished(false);
        this.nextButton.setEnabled(true);
        this.previousButton.setEnabled(true);
        this.stopButton.setEnabled(true);
    }

    protected void updateCommandButtonsEnd() {
        this.stopButton.setEnabled(true);
        this.playButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        if (this.slider.getValue() > 0) {
            this.previousButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    public void stateChanged(int currentIndex) {
        this.updateJSlider();
        this.slider.setValue(currentIndex);
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public void setOwner(JFrame owner) {
        this.owner = owner;
    }
}

