/*
 * Decompiled with CFR 0.152.
 */
package gui;

import error.Error;
import gui.AboutDialog;
import gui.MyInternalFrame;
import gui.MyJFrame;
import gui.PlaybackControlPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import structure.ObservabileVariable;
import utils.ImageFilter;
import utils.Utils;
import view.AbstractView;
import viewer.AbstractViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimulationFrame
extends MyJFrame {
    protected AbstractViewer viewer;
    protected Thread viewerThread;
    protected MyInternalFrame frame2;
    protected MyInternalFrame frame3;
    protected LinkedList<String> elems = new LinkedList();
    protected JInternalFrame frame1 = new JInternalFrame("Simulation", true, false, true, true);
    private JMenuItem aboutMenuItem;
    private ButtonGroup buttonGroup1;
    private JDesktopPane desktop;
    private JMenuItem exitMenuItem;
    protected JMenu fileMenu;
    private JMenu helpMenu;
    protected JCheckBoxMenuItem historyMenuItem;
    private JMenu jMenu2;
    private JSeparator jSeparator1;
    protected JMenuBar menuBar;
    private JMenuItem normalSpeedMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem openStructureMenuItem;
    protected PlaybackControlPanel playbackControlPanel;
    private JMenu playbackMenu;
    private JMenuItem saveImageMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem saveSVGMenuItem;
    private JMenuItem saveStructureMenuItem;
    private JMenuItem slowDownMenuItem;
    private JMenuItem speedUpMenuItem;
    protected JMenu viewMenu;
    private JCheckBoxMenuItem zoom100;
    private JCheckBoxMenuItem zoom150;
    private JCheckBoxMenuItem zoom200;
    private JCheckBoxMenuItem zoom250;
    private JCheckBoxMenuItem zoom50;
    private JCheckBoxMenuItem zoom75;
    protected JMenu zoomMenuItem;

    public AbstractSimulationFrame(AbstractView view) {
        try {
            this.initComponents(view);
        }
        catch (Error e) {
            this.error(e.getErrorMessage());
        }
        this.playbackControlPanel.setOwner(this);
        this.playbackControlPanel.setViewer(this.viewer);
        this.playbackControlPanel.getPlayButton().requestFocusInWindow();
        this.setTitle(view.algorithmName() + " " + this.viewer.getSpeed());
        this.frame1.setContentPane(this.viewer);
        this.frame1.setVisible(true);
        this.desktop.add(this.frame1);
        if (this.frame2 != null) {
            this.desktop.add(this.frame2);
        }
        try {
            this.frame1.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                AbstractSimulationFrame.this.viewerThread.stop();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (!AbstractSimulationFrame.this.frame1.isMaximum()) {
                    AbstractSimulationFrame.this.repositionFrame1();
                }
                if (AbstractSimulationFrame.this.frame2 != null) {
                    AbstractSimulationFrame.this.frame2.reposition();
                }
                if (AbstractSimulationFrame.this.frame3 != null) {
                    AbstractSimulationFrame.this.frame3.reposition();
                }
                AbstractSimulationFrame.this.viewer.repaint();
            }
        });
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.desktop = new JDesktopPane();
        this.playbackControlPanel = new PlaybackControlPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.openStructureMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveStructureMenuItem = new JMenuItem();
        this.saveImageMenuItem = new JMenuItem();
        this.saveSVGMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.playbackMenu = new JMenu();
        this.jMenu2 = new JMenu();
        this.speedUpMenuItem = new JMenuItem();
        this.normalSpeedMenuItem = new JMenuItem();
        this.slowDownMenuItem = new JMenuItem();
        this.historyMenuItem = new JCheckBoxMenuItem();
        this.viewMenu = new JMenu();
        this.zoomMenuItem = new JMenu();
        this.zoom50 = new JCheckBoxMenuItem();
        this.zoom75 = new JCheckBoxMenuItem();
        this.zoom100 = new JCheckBoxMenuItem();
        this.zoom150 = new JCheckBoxMenuItem();
        this.zoom200 = new JCheckBoxMenuItem();
        this.zoom250 = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.buttonGroup1.add(this.zoom50);
        this.buttonGroup1.add(this.zoom75);
        this.buttonGroup1.add(this.zoom100);
        this.buttonGroup1.add(this.zoom150);
        this.buttonGroup1.add(this.zoom200);
        this.buttonGroup1.add(this.zoom250);
        this.setDefaultCloseOperation(3);
        this.desktop.setBackground(new Color(244, 244, 244));
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.playbackControlPanel, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/open-16px.png")));
        this.openMenuItem.setText("Open...");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.openStructureMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.openStructureMenuItem.setText("Open Structure...");
        this.openStructureMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.openStructureMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openStructureMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/save-16px.png")));
        this.saveMenuItem.setText("Save As...");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveStructureMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveStructureMenuItem.setText("Save Structure As..");
        this.saveStructureMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.saveStructureMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveStructureMenuItem);
        this.saveImageMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 9));
        this.saveImageMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/image-16px.png")));
        this.saveImageMenuItem.setText("Save Image As...");
        this.saveImageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.saveImageMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveImageMenuItem);
        this.saveSVGMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        this.saveSVGMenuItem.setText("Save SVG As...");
        this.saveSVGMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.saveSVGMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveSVGMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/exit-16px.png")));
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.playbackMenu.setText("Options");
        this.jMenu2.setText("Play Speed");
        this.speedUpMenuItem.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        this.speedUpMenuItem.setText("Faster");
        this.speedUpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.speedUpMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.speedUpMenuItem);
        this.normalSpeedMenuItem.setAccelerator(KeyStroke.getKeyStroke(106, 2));
        this.normalSpeedMenuItem.setText("Normal speed");
        this.normalSpeedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.normalSpeedMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.normalSpeedMenuItem);
        this.slowDownMenuItem.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        this.slowDownMenuItem.setText("Slower");
        this.slowDownMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.slowDownMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.slowDownMenuItem);
        this.playbackMenu.add(this.jMenu2);
        this.historyMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.historyMenuItem.setSelected(true);
        this.historyMenuItem.setText("Remember history");
        this.historyMenuItem.setToolTipText("If toggled, remembes history after every operation in interactive algorithms.");
        this.historyMenuItem.setEnabled(false);
        this.playbackMenu.add(this.historyMenuItem);
        this.menuBar.add(this.playbackMenu);
        this.viewMenu.setText("View");
        this.zoomMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/zoom-16px.png")));
        this.zoomMenuItem.setText("Zoom");
        this.zoom50.setText("50%");
        this.zoom50.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom50ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom50);
        this.zoom75.setText("75%");
        this.zoom75.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom75ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom75);
        this.zoom100.setSelected(true);
        this.zoom100.setText("100%");
        this.zoom100.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom100ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom100);
        this.zoom150.setText("150%");
        this.zoom150.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom150ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom150);
        this.zoom200.setText("200%");
        this.zoom200.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom200ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom200);
        this.zoom250.setText("250%");
        this.zoom250.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.zoom250ActionPerformed(evt);
            }
        });
        this.zoomMenuItem.add(this.zoom250);
        this.viewMenu.add(this.zoomMenuItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/about-16px.png")));
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbstractSimulationFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    public void error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error Dialog", 0);
    }

    protected void initComponents(AbstractView view) throws Error {
        this.initComponents();
        this.setDefaultCloseOperation(2);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("/gui/images/play-16px.png"));
            this.frame1.setFrameIcon(new ImageIcon(img));
            this.setIconImage(ImageIO.read(this.getClass().getResource("/gui/images/logo-20px.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setSize(800, 600);
        MyJFrame.centerPosition(this);
    }

    protected void openStructures(File file) throws FileNotFoundException, IOException, Error, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        this.viewer.load((ObservabileVariable[])in.readObject());
        this.viewer.loadAdditionalObjects(in);
        this.createAndStartViewerThread();
        this.playbackControlPanel.enablePlayback(0);
        this.repaint();
        in.close();
    }

    private void repositionFrame1() {
        Rectangle r = this.getDesktop().getBounds();
        int w = (int)r.getWidth();
        if (this.frame2 != null) {
            w -= this.frame2.getWidth() + 10;
        }
        this.frame1.setBounds(0, 0, w, (int)r.getHeight());
        this.viewer.getView().setWidth(w);
        this.viewer.getView().setHeight((int)r.getHeight());
    }

    protected void loadStruct(File file) throws Error, FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        if (this.viewer.load((AbstractViewer)in.readObject())) {
            this.createAndStartViewerThread();
            this.playbackControlPanel.enablePlayback(this.viewer.getView().getCurrentIndex());
        } else {
            this.error("Algorithms incompatible");
        }
        this.repaint();
        in.close();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Open");
        choose.setCurrentDirectory(new File("."));
        if (choose.showOpenDialog(this) == 0) {
            File file = choose.getSelectedFile();
            try {
                this.loadStruct(file);
            }
            catch (Exception ex) {
                String msg = ex.getMessage().split(":")[0];
                this.error("Version incompatibility\n" + msg);
            }
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Save");
        choose.setCurrentDirectory(new File("."));
        if (choose.showSaveDialog(this) == 0) {
            File file = choose.getSelectedFile();
            ObjectOutputStream out = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                out = new ObjectOutputStream(fos);
                out.writeObject(this.viewer);
                out.close();
            }
            catch (Exception ex) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                file.delete();
                this.error("Cannot save " + ex.getMessage());
            }
        }
    }

    private void saveImageMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        ImageFilter filter = new ImageFilter();
        choose.setDialogTitle("Save");
        choose.setCurrentDirectory(new File("."));
        choose.setFileFilter(filter);
        if (choose.showSaveDialog(this) == 0) {
            File file = choose.getSelectedFile();
            String format = "jpg";
            try {
                if (((FileFilter)filter).accept(file)) {
                    format = Utils.getExtension(file);
                } else {
                    file = new File(file.getAbsolutePath() + "." + format);
                }
                ImageIO.write(this.viewer.createImage(), format, file);
            }
            catch (Exception ex) {
                this.error(ex.getMessage());
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.viewerThread.stop();
        this.dispose();
    }

    private void saveSVGMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Save");
        choose.setCurrentDirectory(new File("."));
        if (choose.showSaveDialog(this) == 0) {
            File file = choose.getSelectedFile();
            if (!Utils.getExtension(file).equals("svg")) {
                file = new File(file.getAbsolutePath() + ".svg");
            }
            try {
                FileWriter out = new FileWriter(file);
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                String svgNS = "http://www.w3.org/2000/svg";
                Document document = domImpl.createDocument(svgNS, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                this.viewer.paint((Graphics)svgGenerator);
                svgGenerator.stream((Writer)out, false);
                out.close();
            }
            catch (Exception ex) {
                this.error(ex.toString());
            }
        }
    }

    private void zoom50ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(0.5);
    }

    private void speedUpMenuItemActionPerformed(ActionEvent evt) {
        this.viewer.increaseSpeed();
        this.setTitle(this.viewer.getView().algorithmName() + " " + this.viewer.getSpeed());
    }

    private void zoom100ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(1.0);
    }

    private void slowDownMenuItemActionPerformed(ActionEvent evt) {
        this.viewer.decreaseSpeed();
        this.setTitle(this.viewer.getView().algorithmName() + " " + this.viewer.getSpeed());
    }

    private void zoom75ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(0.75);
    }

    private void zoom150ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(1.5);
    }

    private void zoom200ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(2.0);
    }

    private void zoom250ActionPerformed(ActionEvent evt) {
        this.viewer.getView().setZoom(2.5);
    }

    private void normalSpeedMenuItemActionPerformed(ActionEvent evt) {
        this.viewer.setPauseInterval(150);
        this.setTitle(this.viewer.getView().algorithmName() + " " + this.viewer.getSpeed());
    }

    private void openStructureMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Open");
        choose.setCurrentDirectory(new File("."));
        if (choose.showOpenDialog(this) == 0) {
            File file = choose.getSelectedFile();
            try {
                this.openStructures(file);
            }
            catch (Error e) {
                this.error("<html>Algorithm incompatibility: <br />" + e.getErrorMessage());
            }
            catch (Exception e) {
                this.error("<html>Could not open file: <br />" + e.toString());
            }
        }
    }

    private void saveStructureMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Save");
        choose.setCurrentDirectory(new File("."));
        if (choose.showSaveDialog(this) == 0) {
            File file = choose.getSelectedFile();
            ObjectOutputStream out = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                out = new ObjectOutputStream(fos);
                this.viewer.saveStructures(out);
                out.close();
            }
            catch (Exception ex) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                file.delete();
                this.error("Cannot save " + ex.getMessage());
            }
        }
    }

    public AbstractViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(AbstractViewer viewer) {
        this.viewer = viewer;
    }

    public LinkedList<String> getElems() {
        return this.elems;
    }

    public void createAndStartViewerThread() {
        if (this.viewerThread != null) {
            this.viewerThread.stop();
        }
        this.viewerThread = new Thread(this.viewer);
        this.viewerThread.setDaemon(true);
        this.viewerThread.start();
        this.playbackControlPanel.setViewerThread(this.viewerThread);
    }

    public Thread getViewerThread() {
        return this.viewerThread;
    }

    public void setViewerThread(Thread viewerThread) {
        this.viewerThread = viewerThread;
    }

    public PlaybackControlPanel getPlaybackControlPanel() {
        return this.playbackControlPanel;
    }

    public MyInternalFrame getFrame2() {
        return this.frame2;
    }

    public JInternalFrame getFrame1() {
        return this.frame1;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }
}

