/*
 * Decompiled with CFR 0.152.
 */
package dynamicClassLoader;

import java.io.File;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcClassLoader {
    private LinkedList<Class> classes = new LinkedList();
    private int limit = 0;

    public void loadClass(String packageName) {
        try {
            String path;
            if (this.limit == 0) {
                this.classes.clear();
            }
            ++this.limit;
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            File directory = new File(cld.getResource(path = packageName.replace('.', '/')).getFile().replace("%20", " "));
            if (directory.exists()) {
                File[] files = directory.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    Class<?> myClass;
                    if (files[i].isDirectory()) {
                        this.loadClass(packageName + "." + files[i].getName());
                        continue;
                    }
                    String fileName = files[i].getName();
                    if (!fileName.endsWith(".class") || (myClass = Class.forName(packageName + '.' + fileName.substring(0, fileName.length() - 6))).getModifiers() != 1) continue;
                    this.classes.add(myClass);
                }
            }
            --this.limit;
        }
        catch (NullPointerException exp) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DefaultMutableTreeNode getRoot(String type) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(type);
        for (int i = 0; i < this.classes.size(); ++i) {
            String[] parts = this.classes.get(i).getName().split("\\.");
            if (parts == null || parts.length == 0) continue;
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode(parts[0]);
            int index = this.getTreeNodeIndex(root, newRoot);
            if (root.toString().equals(newRoot.toString())) {
                newRoot = root;
            } else if (index == -1) {
                root.add(newRoot);
            } else {
                newRoot = (DefaultMutableTreeNode)root.getChildAt(index);
            }
            String[] newParts = new String[parts.length - 1];
            for (int k = 1; k < parts.length; ++k) {
                newParts[k - 1] = parts[k];
            }
            this.recursiveRoot(newRoot, newParts);
        }
        return root;
    }

    public void recursiveRoot(DefaultMutableTreeNode root, String[] parts) {
        if (parts != null && parts.length != 0) {
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode(parts[0]);
            int index = this.getTreeNodeIndex(root, newRoot);
            if (root.toString().equals(newRoot.toString())) {
                newRoot = root;
            } else if (index == -1) {
                root.add(newRoot);
            } else {
                newRoot = (DefaultMutableTreeNode)root.getChildAt(index);
            }
            String[] newParts = new String[parts.length - 1];
            for (int k = 1; k < parts.length; ++k) {
                newParts[k - 1] = parts[k];
            }
            this.recursiveRoot(newRoot, newParts);
        }
    }

    public int getTreeNodeIndex(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (!parent.getChildAt(i).toString().equals(child.toString())) continue;
            return i;
        }
        return -1;
    }

    public LinkedList<String> apropriateView(String alg) {
        LinkedList<String> list = new LinkedList<String>();
        String[] algList = alg.split("\\.");
        if (algList.length == 1) {
            for (int i = 0; i < this.classes.size(); ++i) {
                if (!this.classes.get(i).toString().split("\\.")[1].equals(alg)) continue;
                list.add(this.classes.get(i).toString());
            }
        } else {
            for (int i = 0; i < this.classes.size(); ++i) {
                if (!this.classes.get(i).toString().split("\\.")[1].equals(algList[0]) || !this.classes.get(i).toString().split("\\.")[2].equals(algList[1])) continue;
                list.add(this.classes.get(i).toString());
            }
        }
        return list;
    }

    public void addClasses(LinkedList<Class> c) {
        this.classes.addAll(c);
    }

    public LinkedList<Class> getMyClasses() {
        return this.classes;
    }
}

