/*
 * Decompiled with CFR 0.152.
 */
package dynamicClassLoader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassLoader {
    private LinkedList<Class> classes = new LinkedList();

    public void loadClassFromJar(String classPackage) {
        this.getClasses().clear();
        String jarName = this.getJarName("/Main.class");
        if (jarName != null) {
            this.loadFromPackage(jarName, classPackage);
        }
    }

    private String getJarName(String className) {
        int x1;
        URL url = JarClassLoader.class.getResource(className);
        if (url == null) {
            return null;
        }
        String jarName = url.getPath();
        int x2 = jarName.lastIndexOf("!");
        if (x2 != -1) {
            jarName = jarName.substring(0, x2);
        }
        if ((jarName = jarName.substring((x1 = jarName.lastIndexOf("/")) + 1, jarName.length())).endsWith(".jar")) {
            return jarName;
        }
        return null;
    }

    private void loadFromPackage(String jarName, String packageName) {
        try {
            JarFile jarFile = new JarFile(jarName);
            Enumeration<JarEntry> enum1 = jarFile.entries();
            String cs = packageName;
            while (enum1.hasMoreElements()) {
                String name = enum1.nextElement().getName();
                if (!name.contains(cs) || !name.startsWith(packageName + "/") || !name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6);
                Class<?> c = Class.forName(name = name.replace('/', '.'));
                int modif = c.getModifiers();
                if (modif != 1) continue;
                this.getClasses().add(c);
            }
        }
        catch (IOException exp) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public LinkedList<Class> getClasses() {
        return this.classes;
    }
}

