/*
 * Decompiled with CFR 0.152.
 */
package algorithm.graph;

import algorithm.Algorithm;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileElement;
import structure.ObservabileGraph;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgPrim
extends Algorithm {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileGraph G = (ObservabileGraph)struct[0];
        ObservabileElement s = (ObservabileElement)struct[1];
        ObservabileGraph V = new ObservabileGraph(this, 2);
        try {
            V.addNode(s.readValue());
            G.finalNode(s.readValue());
            while (!V.equalNodes(G)) {
                int min = Integer.MAX_VALUE;
                int ind1 = 0;
                int ind2 = 0;
                for (int i = 0; i < G.getNumOfElems(); ++i) {
                    for (int j = 0; j < G.getNumOfElems(); ++j) {
                        if (!V.containsNode(G.readNode(i)) || V.containsNode(G.readNode(j)) || !G.getConnectionMatrix()[i][j]) continue;
                        G.selectNode(j);
                        if (Integer.parseInt(G.getWeight(i, j)) < min) {
                            min = Integer.parseInt(G.getWeightMatrix()[i][j]);
                            ind1 = i;
                            ind2 = j;
                        }
                        G.deselectNode(j);
                    }
                }
                V.addNode(G.readNode(ind2));
                G.finalNode(G.readNode(ind2));
                V.addBranch(G.readNode(ind1), G.readNode(ind2), G.readWeight(ind1, ind2));
                G.finalBranch(G.readNode(ind1), G.readNode(ind2));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileGraph", 1));
        using.add(new Using("ObservabileElement", 1));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        if (!((ObservabileGraph)initializators[0]).isAllBranchTwoSided()) {
            throw new Error(1001);
        }
        if (!((ObservabileGraph)initializators[0]).isConnected()) {
            throw new Error(1003);
        }
        ((ObservabileGraph)initializators[0]).setAlghorithm(this);
        ((ObservabileElement)initializators[1]).setAlghorithm(this);
        return (ObservabileVariable[])initializators;
    }
}

