/*
 * Decompiled with CFR 0.152.
 */
package algorithm.graph;

import algorithm.Algorithm;
import error.Error;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import structure.ObservabileGraph;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgKruskal
extends Algorithm {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileGraph G = (ObservabileGraph)struct[0];
        ObservabileGraph E = new ObservabileGraph(this, 1);
        try {
            for (int i = 0; i < G.getNumOfElems(); ++i) {
                E.addNode(G.readNode(i));
            }
            PriorityQueue<Branch> PQ = new PriorityQueue<Branch>();
            for (int i = 0; i < G.getNumOfElems(); ++i) {
                for (int j = 0; j < G.getNumOfElems(); ++j) {
                    if (!G.getConnectionMatrix()[i][j] || i <= j) continue;
                    PQ.add(new Branch(G.readNode(i), G.readNode(j), Integer.parseInt(G.readWeight(i, j))));
                }
            }
            HashSet[] T = new HashSet[G.getNumOfElems()];
            for (int i = 0; i < G.getNumOfElems(); ++i) {
                T[i] = new HashSet();
                T[i].add(G.readNode(i));
                G.finalNode(G.readNode(i));
            }
            int num = 0;
            while (num < G.getNumOfElems() - 1) {
                Branch w = (Branch)PQ.remove();
                for (int i = 0; i < G.getNumOfElems(); ++i) {
                    for (int j = 0; j < G.getNumOfElems(); ++j) {
                        if (!T[i].contains(w.node1) || !T[j].contains(w.node2) || i == j) continue;
                        E.addBranch(w.node1, w.node2, "" + w.weight);
                        G.finalBranch(w.node1, w.node2);
                        T[i].addAll(T[j]);
                        T[j].removeAll(T[j]);
                        ++num;
                    }
                }
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileGraph", 1));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        if (!((ObservabileGraph)initializators[0]).isAllBranchTwoSided()) {
            throw new Error(1002);
        }
        if (!((ObservabileGraph)initializators[0]).isConnected()) {
            throw new Error(1004);
        }
        ((ObservabileGraph)initializators[0]).setAlghorithm(this);
        return (ObservabileVariable[])initializators;
    }

    private class Branch
    implements Comparable {
        public String node1;
        public String node2;
        public int weight;

        public Branch(String node1, String node2, int weight) {
            this.node1 = node1;
            this.node2 = node2;
            this.weight = weight;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Branch)) {
                throw new ClassFormatError();
            }
            if (this.weight < ((Branch)o).weight) {
                return -1;
            }
            if (this.weight > ((Branch)o).weight) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "" + this.weight;
        }
    }
}

