/*
 * Decompiled with CFR 0.152.
 */
package algorithm.graph;

import algorithm.Algorithm;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileElement;
import structure.ObservabileGraph;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgFordFulkerson
extends Algorithm {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileGraph G = (ObservabileGraph)struct[0];
        try {
            for (int i = 0; i < G.getNumOfElems(); ++i) {
                for (int j = 0; j < G.getNumOfElems(); ++j) {
                    if (!G.getConnectionMatrix()[i][j]) continue;
                    G.writeBranchWeight(i, j, G.readWeight(i, j) + "/0");
                }
            }
            LinkedList<LinkedList<String>> list = G.findAllPaths();
            for (int i = 0; i < list.size(); ++i) {
                int num;
                int j;
                int min = Integer.parseInt(G.readWeight(list.get(i).get(0), list.get(i).get(1)).split("/")[0]) - Integer.parseInt(G.readWeight(list.get(i).get(0), list.get(i).get(1)).split("/")[1]);
                G.selectBranch(list.get(i).get(0), list.get(i).get(1));
                int ind1 = 0;
                int ind2 = 1;
                for (j = 1; j < list.get(i).size() - 1; ++j) {
                    num = Integer.parseInt(G.getWeight(list.get(i).get(j), list.get(i).get(j + 1)).split("/")[0]) - Integer.parseInt(G.readWeight(list.get(i).get(j), list.get(i).get(j + 1)).split("/")[1]);
                    if (num >= min) continue;
                    min = num;
                    G.deselectBranch(list.get(i).get(ind1), list.get(i).get(ind2));
                    G.selectBranch(list.get(i).get(j), list.get(i).get(j + 1));
                    ind1 = j;
                    ind2 = j + 1;
                }
                G.deselectBranch(list.get(i).get(ind1), list.get(i).get(ind2));
                for (j = 0; j < list.get(i).size() - 1; ++j) {
                    num = Integer.parseInt(G.readWeight(list.get(i).get(j), list.get(i).get(j + 1)).split("/")[1]);
                    G.setBranchWeight(list.get(i).get(j), list.get(i).get(j + 1), G.readWeight(list.get(i).get(j), list.get(i).get(j + 1)).split("/")[0] + "/" + (num + min));
                }
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileGraph", 1));
        using.add(new Using("ObservabileElement", 2));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        if (!((ObservabileGraph)initializators[0]).isConnected()) {
            throw new Error(1005);
        }
        if (!((ObservabileGraph)initializators[0]).allBranchesNotNegative()) {
            throw new Error(1011);
        }
        ((ObservabileGraph)initializators[0]).findAllPaths();
        ((ObservabileGraph)initializators[0]).setAlghorithm(this);
        ((ObservabileElement)initializators[1]).setAlghorithm(this);
        ((ObservabileElement)initializators[2]).setAlghorithm(this);
        return (ObservabileVariable[])initializators;
    }
}

