/*
 * Decompiled with CFR 0.152.
 */
package algorithm.array;

import action.ActArray;
import algorithm.array.AlgSort;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileElement;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgShellSort
extends AlgSort {
    protected int[] h = new int[]{4, 2, 1};
    protected int len = 3;

    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileArray array = (ObservabileArray)struct[0];
        ObservabileElement K = (ObservabileElement)struct[1];
        ObservabileElement incEl = (ObservabileElement)struct[2];
        this.actions.add(new ActArray("Starting structure ", this.getCloneStructures(), 8, -1, new int[]{array.getStructureID()}));
        try {
            for (int i = 0; i < this.len; ++i) {
                if (this.h[i] >= array.getNumOfElem()) continue;
                int inc = this.h[i];
                incEl.setValue("h=" + this.h[i]);
                for (int j = inc; j < array.getNumOfElem(); ++j) {
                    array.saveElem(j, K);
                    int y = Integer.parseInt(array.getElem(j));
                    int t = j - inc;
                    boolean compare = array.compareTmpAct(t, K);
                    while (t >= 0 && compare) {
                        array.moveElem(t + inc, t);
                        if ((t -= inc) < 0) continue;
                        compare = array.compareTmpAct(t, K);
                    }
                    array.restoreElem(t + inc, K);
                }
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileArray", 1));
        using.add(new Using("ObservabileElement", 2));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        ObservabileVariable[] structures = new ObservabileVariable[]{new ObservabileArray(this, 0), new ObservabileElement(this, 1), new ObservabileElement(this, 2)};
        String[] elems = (String[])initializators;
        if (elems.length > 100) {
            throw new Error(1013);
        }
        for (int i = 0; i < elems.length; ++i) {
            ((ObservabileArray)structures[0]).addElem(elems[i]);
        }
        return structures;
    }

    public void setSequence(LinkedList<String> list) {
        int i;
        this.len = 0;
        for (i = 0; i < list.size(); ++i) {
            System.out.println(list.get(i));
        }
        if (list.get(list.size() - 1).equals("1")) {
            this.h = new int[list.size()];
        } else {
            this.h = new int[list.size() + 1];
            this.h[list.size()] = 1;
        }
        for (i = 0; i < list.size(); ++i) {
            int x;
            this.h[i] = x = Integer.parseInt(list.get(i));
            ++this.len;
        }
    }
}

