/*
 * Decompiled with CFR 0.152.
 */
package algorithm.array;

import action.ActArray;
import algorithm.array.AlgSort;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileElement;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgQuickSort
extends AlgSort {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileArray array = (ObservabileArray)struct[0];
        ObservabileElement low = (ObservabileElement)struct[1];
        ObservabileElement high = (ObservabileElement)struct[2];
        ObservabileElement pivot = (ObservabileElement)struct[3];
        this.actions.add(new ActArray("Starting structure ", this.getCloneStructures(), 8, -1, new int[]{array.getStructureID()}));
        try {
            if (Integer.parseInt(high.readValue()) > Integer.parseInt(low.readValue())) {
                String h = high.readValue();
                int j = this.partition(array, low, high, pivot);
                high.writeValue("" + (j - 1));
                this.run(new ObservabileVariable[]{array, low, high, pivot});
                low.writeValue("" + (j + 1));
                high.writeValue(h);
                this.run(new ObservabileVariable[]{array, low, high, pivot});
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private int partition(ObservabileArray array, ObservabileElement low, ObservabileElement high, ObservabileElement pivot) throws Error {
        int i = Integer.parseInt(low.readValue());
        int j = Integer.parseInt(high.readValue());
        array.saveElem(Integer.parseInt(low.readValue()), pivot);
        while (i < j) {
            if (this.ascending) {
                while (!array.compareTmpAct(i, pivot).booleanValue() && i < j) {
                    ++i;
                }
                while (array.compareTmpAct(j, pivot).booleanValue()) {
                    --j;
                }
            } else {
                while ((array.compareTmpAct(i, pivot).booleanValue() || array.equalTmp(i, pivot).booleanValue()) && i < j) {
                    ++i;
                }
                while (!array.compareTmpAct(j, pivot).booleanValue() && !array.equalTmp(j, pivot).booleanValue()) {
                    --j;
                }
            }
            if (i >= j) continue;
            array.swapElems(i, j);
        }
        array.moveElem(Integer.parseInt(low.readValue()), j);
        array.restoreElem(j, pivot);
        return j;
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileArray", 1));
        using.add(new Using("ObservabileElement", 3));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        ObservabileVariable[] structures = new ObservabileVariable[]{new ObservabileArray(this, 0), new ObservabileElement(this, 1), new ObservabileElement(this, 2), new ObservabileElement(this, 3)};
        String[] elems = (String[])initializators;
        if (elems.length > 100) {
            throw new Error(1013);
        }
        for (int i = 0; i < elems.length; ++i) {
            ((ObservabileArray)structures[0]).addElem(elems[i]);
        }
        String low = "0";
        String high = "" + (((ObservabileArray)structures[0]).getNumOfElem() - 1);
        ((ObservabileElement)structures[1]).writeValue(low);
        ((ObservabileElement)structures[2]).writeValue(high);
        return structures;
    }
}

