/*
 * Decompiled with CFR 0.152.
 */
package algorithm.array;

import action.ActArray;
import algorithm.array.AlgSort;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileElement;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgInsertionSort
extends AlgSort {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileArray array = (ObservabileArray)struct[0];
        ObservabileElement K = (ObservabileElement)struct[1];
        this.actions.add(new ActArray("Starting structure ", this.getCloneStructures(), 8, -1, new int[]{array.getStructureID()}));
        try {
            for (int i = 1; i < array.getNumOfElem(); ++i) {
                int j;
                array.saveElem(i, K);
                if (this.ascending) {
                    for (j = i - 1; j >= 0 && array.compareTmpAct(j, K).booleanValue(); --j) {
                        array.moveElem(j + 1, j);
                    }
                } else {
                    while (j >= 0 && !array.compareTmpAct(j, K).booleanValue() && !array.equalTmp(j, K).booleanValue()) {
                        array.moveElem(j + 1, j);
                        --j;
                    }
                }
                array.restoreElem(j + 1, K);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileArray", 1));
        using.add(new Using("ObservabileElement", 1));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        ObservabileVariable[] structures = new ObservabileVariable[]{new ObservabileArray(this, 0), new ObservabileElement(this, 1)};
        String[] elems = (String[])initializators;
        if (elems.length > 100) {
            throw new Error(1013);
        }
        for (int i = 0; i < elems.length; ++i) {
            ((ObservabileArray)structures[0]).addElem(elems[i]);
        }
        return structures;
    }
}

