/*
 * Decompiled with CFR 0.152.
 */
package algorithm.array;

import action.ActArray;
import algorithm.array.AlgSort;
import error.Error;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileElement;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgHeapSort
extends AlgSort {
    @Override
    public void run(ObservabileVariable[] struct) {
        this.obsVars = struct;
        ObservabileArray array = (ObservabileArray)struct[0];
        ObservabileElement nhe = (ObservabileElement)struct[1];
        ObservabileElement last = (ObservabileElement)struct[2];
        this.actions.add(new ActArray("Starting structure ", this.getCloneStructures(), 8, -1, new int[]{array.getStructureID()}));
        try {
            int i;
            for (i = 1; i < array.getNumOfElem(); ++i) {
                array.saveElem(i, nhe);
                int s = i;
                int f = (s - 1) / 2;
                if (this.ascending) {
                    while (s > 0 && !array.equalTmpAct(f, nhe).booleanValue() && !array.compareTmp(f, nhe).booleanValue()) {
                        array.moveElem(s, f);
                        s = f;
                        f = (s - 1) / 2;
                    }
                } else {
                    while (s > 0 && (array.equalTmpAct(f, nhe).booleanValue() || array.compareTmp(f, nhe).booleanValue())) {
                        array.moveElem(s, f);
                        s = f;
                        f = (s - 1) / 2;
                    }
                }
                array.restoreElem(s, nhe);
            }
            for (i = array.getNumOfElem() - 1; i > 0; --i) {
                array.saveElem(i, last);
                array.moveElem(i, 0);
                int f = 0;
                int s = 1;
                if (this.ascending) {
                    if (i - 1 >= 2 && array.compareAct(2, 1).booleanValue()) {
                        s = 2;
                    }
                    while (s <= i - 1 && array.compareTmpAct(s, last).booleanValue()) {
                        array.moveElem(f, s);
                        f = s;
                        if ((s = 2 * f + 1) + 1 > i - 1 || !array.compareAct(s + 1, s).booleanValue()) continue;
                        ++s;
                    }
                } else {
                    if (i - 1 >= 2 && !array.compareAct(2, 1).booleanValue()) {
                        s = 2;
                    }
                    while (s <= i - 1 && !array.compareTmpAct(s, last).booleanValue()) {
                        array.moveElem(f, s);
                        f = s;
                        if ((s = 2 * f + 1) + 1 > i - 1 || array.compareAct(s + 1, s).booleanValue()) continue;
                        ++s;
                    }
                }
                array.restoreElem(f, last);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public LinkedList<Using> using() {
        LinkedList<Using> using = new LinkedList<Using>();
        using.add(new Using("ObservabileArray", 1));
        using.add(new Using("ObservabileElement", 2));
        return using;
    }

    @Override
    public ObservabileVariable[] makeStructures(Object[] initializators) throws Error {
        ObservabileVariable[] structures = new ObservabileVariable[]{new ObservabileArray(this, 0), new ObservabileElement(this, 1), new ObservabileElement(this, 2)};
        String[] elems = (String[])initializators;
        if (elems.length > 100) {
            throw new Error(1013);
        }
        for (int i = 0; i < elems.length; ++i) {
            ((ObservabileArray)structures[0]).addElem(elems[i]);
        }
        return structures;
    }
}

