/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import action.Action;
import error.Error;
import java.io.Serializable;
import java.util.LinkedList;
import structure.ObservabileVariable;
import structure.Using;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithm
implements Serializable {
    protected ObservabileVariable[] obsVars = null;
    protected LinkedList<Action> actions = new LinkedList();

    public abstract void run(ObservabileVariable[] var1);

    public abstract LinkedList<Using> using();

    public abstract ObservabileVariable[] makeStructures(Object[] var1) throws Error;

    public ObservabileVariable[] getCloneStructures() {
        ObservabileVariable[] vars = new ObservabileVariable[this.obsVars.length];
        for (int i = 0; i < this.obsVars.length; ++i) {
            vars[i] = this.obsVars[i].clone();
        }
        return vars;
    }

    public String printActions() {
        String str = "";
        for (int i = 0; i < this.actions.size(); ++i) {
            str = str + this.actions.get(i);
            if (i == this.actions.size() - 1) continue;
            str = str + "\n";
        }
        return str;
    }

    public LinkedList<Action> getActions() {
        return this.actions;
    }

    public void clearActions() {
        this.actions.clear();
    }
}

