/*
 * Decompiled with CFR 0.152.
 */
import algorithm.Algorithm;
import dynamicClassLoader.JarClassLoader;
import dynamicClassLoader.SrcClassLoader;
import gui.AboutDialog;
import gui.AboutDialogData;
import gui.MyJFrame;
import gui.array.SimulationFrameArray;
import gui.graph.SimulationFrameGraph;
import gui.tree.SimulationFrameBinaryTree;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import view.AbstractView;

public class Main
extends MyJFrame {
    private SrcClassLoader algorithmsSrcLoader = new SrcClassLoader();
    private SrcClassLoader viewsSrcLoader = new SrcClassLoader();
    private JarClassLoader algorithmsJarLoader = new JarClassLoader();
    private JarClassLoader viewsJarLoader = new JarClassLoader();
    private JMenuItem aboutMenuItem;
    private JScrollPane algsScrollPane;
    private JTree algsTree;
    private JLabel descLabel;
    private JPanel descPanel;
    private JScrollPane descScrollPane;
    private JMenuItem exitMenuItem1;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JButton runButton;
    private JMenuItem runMenuItem;
    private JList viewsList;
    private JScrollPane viewsScrollPane;

    public Main(Frame parent, boolean modal) {
        this.setTitle("VSA " + AboutDialogData.version());
        this.initComponents();
        MyJFrame.centerPosition(this);
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/gui/images/logo-20px.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.algsScrollPane = new JScrollPane();
        this.algorithmsSrcLoader.loadClass("algorithm");
        this.viewsSrcLoader.loadClass("view");
        this.algorithmsJarLoader.loadClassFromJar("algorithm");
        this.viewsJarLoader.loadClassFromJar("view");
        this.algorithmsSrcLoader.addClasses(this.algorithmsJarLoader.getClasses());
        this.viewsSrcLoader.addClasses(this.viewsJarLoader.getClasses());
        this.algsTree = new JTree(this.algorithmsSrcLoader.getRoot("algorithm"));
        this.viewsScrollPane = new JScrollPane();
        this.viewsList = new JList();
        this.descPanel = new JPanel();
        this.descScrollPane = new JScrollPane();
        this.descLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.runButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.runMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem1 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.algsScrollPane.setBorder(BorderFactory.createTitledBorder("Algorithms"));
        this.algsScrollPane.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        this.algsScrollPane.setPreferredSize(new Dimension(200, 350));
        this.algsTree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.algsTree.setPreferredSize(new Dimension(150, 150));
        this.algsScrollPane.setViewportView(this.algsTree);
        this.jPanel1.add(this.algsScrollPane);
        this.viewsScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Views")));
        this.viewsScrollPane.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        this.viewsScrollPane.setPreferredSize(new Dimension(200, 198));
        this.viewsList.setSelectionMode(0);
        this.viewsList.setMaximumSize(new Dimension(300, 300));
        this.viewsList.setPreferredSize(new Dimension(150, 200));
        this.viewsList.setVisibleRowCount(10);
        this.viewsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Main.this.viewsListValueChanged(evt);
            }
        });
        this.viewsScrollPane.setViewportView(this.viewsList);
        this.jPanel1.add(this.viewsScrollPane);
        this.descPanel.setMaximumSize(new Dimension(250, 2048));
        this.descPanel.setMinimumSize(new Dimension(200, 113));
        this.descPanel.setPreferredSize(new Dimension(200, 300));
        this.descPanel.setLayout(new BoxLayout(this.descPanel, 3));
        this.descScrollPane.setBorder(BorderFactory.createTitledBorder("View Description"));
        this.descLabel.setVerticalAlignment(1);
        this.descLabel.setHorizontalTextPosition(2);
        this.descLabel.setVerticalTextPosition(1);
        this.descScrollPane.setViewportView(this.descLabel);
        this.descPanel.add(this.descScrollPane);
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.jPanel3.setPreferredSize(new Dimension(208, 60));
        this.runButton.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/play.png")));
        this.runButton.setText("Run simulation");
        this.runButton.setEnabled(false);
        this.runButton.setMargin(new Insets(2, 2, 2, 2));
        this.runButton.setMaximumSize(new Dimension(170, 52));
        this.runButton.setMinimumSize(new Dimension(170, 52));
        this.runButton.setPreferredSize(new Dimension(170, 52));
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.runButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.runButton);
        this.descPanel.add(this.jPanel3);
        this.jPanel1.add(this.descPanel);
        this.getContentPane().add(this.jPanel1);
        this.getContentPane().add(this.jPanel2);
        this.fileMenu.setText("File");
        this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.runMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/play-16px.png")));
        this.runMenuItem.setText("Run Simulation");
        this.runMenuItem.setEnabled(false);
        this.runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.runMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.runMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem1.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/exit-16px.png")));
        this.exitMenuItem1.setText("Exit");
        this.exitMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.exitMenuItem1ActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem1);
        this.jMenuBar1.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gui/images/about-16px.png")));
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        if (this.viewsList.getSelectedIndex() != -1) {
            Object[] packages = this.algsTree.getSelectionPath().getPath();
            try {
                AbstractView p = (AbstractView)this.getSelectedViewClass().newInstance();
                Algorithm a = (Algorithm)this.getSelectedAlgClass().newInstance();
                p.setAlgorithm(a);
                if (packages[1].toString().equals("array")) {
                    new SimulationFrameArray(p);
                } else if (packages[1].toString().equals("graph")) {
                    new SimulationFrameGraph(p);
                } else if (packages[1].toString().equals("tree")) {
                    new SimulationFrameBinaryTree(p);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void viewsListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (this.viewsList.getSelectedIndex() == -1) {
                this.descLabel.setText("");
                this.runButton.setEnabled(false);
                this.runMenuItem.setEnabled(false);
            } else {
                this.runButton.setEnabled(true);
                this.runMenuItem.setEnabled(true);
                try {
                    AbstractView p = (AbstractView)this.getSelectedViewClass().newInstance();
                    this.descLabel.setText("<html> " + p.description().replace("\n", "<br>"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void runMenuItemActionPerformed(ActionEvent evt) {
        this.runButtonActionPerformed(evt);
    }

    private void exitMenuItem1ActionPerformed(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main dialog = new Main(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private Class getSelectedAlgClass() throws ClassNotFoundException {
        String classAlgName = "";
        Object[] packages = this.algsTree.getSelectionPath().getPath();
        for (int i = 0; i < packages.length - 1; ++i) {
            classAlgName = classAlgName + packages[i] + ".";
        }
        classAlgName = classAlgName + packages[packages.length - 1];
        return Class.forName(classAlgName);
    }

    private Class getSelectedViewClass() throws ClassNotFoundException {
        String tmp = "";
        String classViewName = ((String)this.viewsList.getSelectedValue()).replace("class ", "");
        Object[] packages = this.algsTree.getSelectionPath().getPath();
        for (int i = 0; i < packages.length - 1; ++i) {
            tmp = tmp + packages[i] + ".";
        }
        if (tmp.length() > 9 && tmp.substring(0, 10).equals("algorithm.")) {
            tmp = tmp.substring(10);
        }
        classViewName = "view." + tmp + classViewName;
        return Class.forName(classViewName);
    }

    static {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)Main.this.algsTree.getLastSelectedPathComponent();
            if (node == null || !node.isLeaf()) {
                Main.this.viewsList.setListData(new Object[0]);
                Main.this.viewsList.setSelectedIndex(-1);
                return;
            }
            DefaultMutableTreeNode tmp = node;
            String tmpPath = "";
            while (!((DefaultMutableTreeNode)tmp.getParent()).isRoot()) {
                tmp = (DefaultMutableTreeNode)tmp.getParent();
                tmpPath = "." + tmp.toString() + tmpPath;
            }
            if (tmpPath.length() > 1 && tmpPath.substring(0, 1).equals(".")) {
                tmpPath = tmpPath.substring(1);
            }
            LinkedList<String> list = Main.this.viewsSrcLoader.apropriateView(tmpPath);
            String[] views = new String[list.size()];
            views = list.toArray(views);
            for (int i = 0; i < views.length; ++i) {
                String[] temp = views[i].split("[ \\.]");
                views[i] = temp[temp.length - 1];
            }
            Main.this.viewsList.setListData(views);
            Main.this.viewsList.setSelectedIndex(0);
        }
    }
}

