/*
 * Decompiled with CFR 0.152.
 */
package GUIIzgled;

import GUIIzgled.navigacija.ClickableArea;
import Utility.Usluge;
import guiKomponente.GUIPin;
import guiKomponente.Line;
import guiKomponente.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import komponente.Adapter;
import komponente.LogickaKomponenta;
import komponente.Pin;
import parser.ParsingLine;

public abstract class GuiParts
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ParsingLine parser;
    private static BufferedImage bufferedImage;
    private File imageFile;
    private Font font;
    private ArrayList<ClickableArea> hotspots;
    private int a;
    private int b;

    public GuiParts(String imeFajla) {
        this.imageFile = new File(imeFajla);
        this.parser = new ParsingLine(String.valueOf(imeFajla.substring(0, imeFajla.lastIndexOf("."))) + ".line");
        try {
            this.parser.parsiraj();
        }
        catch (Exception err) {
            System.err.println("Greska: " + err.getMessage() + "!!!" + "\nFajl: " + imeFajla);
        }
        this.font = new Font("Arial", 0, 10);
        this.hotspots = new ArrayList();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        this.a = 0;
        this.b = 0;
        if (bufferedImage != null) {
            int X = (int)this.getParent().getParent().getSize().getWidth();
            int Y = (int)this.getParent().getParent().getSize().getHeight();
            int x1 = bufferedImage.getWidth();
            int y1 = bufferedImage.getHeight();
            this.a = X / 2 - x1 / 2;
            this.b = Y / 2 - y1 / 2;
            if (this.a <= 0) {
                this.a = 10;
            }
            if (this.b <= 0) {
                this.b = 10;
            }
            gg.drawImage((Image)bufferedImage, this.a, this.b, null);
        }
        Iterator<GUIPin> iter = this.parser.getPinovi().iterator();
        try {
            while (iter.hasNext()) {
                GUIPin p = iter.next();
                gg.setColor(p.getTrenColor());
                gg.setStroke(new BasicStroke(p.getBrashWidth(), 2, 2));
                this.drawLine(gg, p, this.a, this.b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawLine(Graphics2D g, GUIPin pin, int a, int b) throws Exception {
        if (pin == null || pin.getGraphicLine() == null) {
            return;
        }
        for (Line next : pin.getGraphicLine()) {
            g.drawLine(a + next.getFirst().x, b + next.getFirst().y, a + next.getLast().x, b + next.getLast().y);
        }
        if (pin.getTextPoint() != null) {
            Iterator<Point> iter1 = pin.getTextPoint().iterator();
            while (iter1.hasNext()) {
                g.setFont(this.font);
                g.setColor(Color.RED);
                Point next = iter1.next();
                String tekst = "";
                if (pin.getBrLine() <= 4) {
                    tekst = Usluge.DtoX1(pin.getPinVal()).toUpperCase();
                } else if (pin.getBrLine() > 4 && pin.getBrLine() <= 8) {
                    tekst = Usluge.DtoX2(pin.getPinVal()).toUpperCase();
                } else if (pin.getBrLine() > 8 && pin.getBrLine() <= 16) {
                    tekst = Usluge.DtoX4(pin.getPinVal()).toUpperCase();
                } else if (pin.getBrLine() > 16 && pin.getBrLine() <= 20) {
                    tekst = Usluge.DtoX5(pin.getPinVal()).toUpperCase();
                } else if (pin.getBrLine() > 20) {
                    tekst = Usluge.DtoX6(pin.getPinVal()).toUpperCase();
                }
                g.drawString(tekst, a + next.x, b + next.y);
            }
        }
    }

    public void initSlika() throws Exception {
        try {
            bufferedImage = ImageIO.read(this.imageFile);
            System.gc();
        }
        catch (IOException e) {
            System.out.println("Error loading " + this.imageFile.getName() + "\n" + e.toString());
            throw new Exception("Error loading " + this.imageFile.getName());
        }
    }

    public abstract void init() throws Exception;

    public abstract Vector<Pin> izvozi() throws Exception;

    public abstract void uvozi(Vector<Pin> var1) throws Exception;

    public BufferedImage getBufferedImage() {
        return bufferedImage;
    }

    public ParsingLine getParser() {
        return this.parser;
    }

    public void control() throws Exception {
        for (LogickaKomponenta slk : this.parser.getLogKomponente()) {
            System.out.println(slk);
            try {
                slk.povezan();
            }
            catch (Exception e) {
                System.out.println("Broj kola: " + this.parser.getLogKomponente().indexOf(slk));
                e.printStackTrace();
            }
        }
    }

    public void addHotSpot(String sled, int x0, int y0, int x1, int y1) {
        this.hotspots.add(new ClickableArea(sled, x0, y0, x1, y1));
    }

    public ArrayList<ClickableArea> getHotspots() {
        return this.hotspots;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public static void insert(Pin in, int num, int start, int end, String name, Vector<LogickaKomponenta> logKomponente, Vector<GUIPin> pinovi) {
        try {
            Adapter oneToMany = new Adapter(1, num);
            oneToMany.setName(String.valueOf(name) + "_oneToMany");
            Pin[] izlaz = new Pin[num];
            int i = 0;
            while (i < num) {
                izlaz[i] = new Pin(false);
                oneToMany.setOutputPins(i, izlaz[i]);
                ++i;
            }
            oneToMany.setInputPins(0, in);
            Adapter manyToOne = new Adapter(1 + end - start, 1);
            manyToOne.setName(String.valueOf(name) + "_manyToOne");
            int i2 = 0;
            while (i2 < 1 + end - start) {
                manyToOne.setInputPins(i2, izlaz[i2 + start]);
                ++i2;
            }
            Pin out = new Pin(0, 1 + end - start);
            manyToOne.setOutputPins(0, out);
            logKomponente.insertElementAt(manyToOne, 2);
            logKomponente.insertElementAt(oneToMany, 2);
            GUIPin TMP = new GUIPin(Color.white, 1, 1, 1);
            TMP.setIme(name);
            TMP.setPin(out);
            pinovi.add(TMP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

