/*
 * Decompiled with CFR 0.152.
 */
package GUIIzgled;

import GUIIzgled.MemTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import komponente.Memorija;

public class GuiMemorija
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MemTableModel model;
    private JTable table;
    private int trnutnaStrana;
    private int UKUPNO_STRANA = 16383;
    private JTextField setVal;
    private JTextField setAdr;
    private JLabel lblTrenutnaStrana;
    private static final Color evenColor = new Color(240, 255, 250);

    public GuiMemorija(Memorija mem) {
        this.model = new MemTableModel(mem);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer tcr, int row, int column) {
                Component c = super.prepareRenderer(tcr, row, column);
                if (this.isRowSelected(row)) {
                    c.setForeground(this.getSelectionForeground());
                    c.setBackground(this.getSelectionBackground());
                } else {
                    c.setForeground(this.getForeground());
                    c.setBackground(row % 2 == 0 ? evenColor : this.getBackground());
                }
                if (column == 0) {
                    c.setBackground(Color.yellow);
                }
                return c;
            }
        };
        this.table.setModel(this.model);
        this.table.setFillsViewportHeight(true);
        this.table.setShowGrid(true);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setBorder(BorderFactory.createEmptyBorder());
        TableColumn column = null;
        int i = 0;
        while (i < 9) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(80);
            } else {
                column.setPreferredWidth(40);
            }
            ++i;
        }
        JTableHeader header = this.table.getTableHeader();
        header.setBackground(Color.yellow);
        JScrollPane pane = new JScrollPane(this.table);
        pane.setPreferredSize(new Dimension(400, 147));
        this.add((Component)pane, "North");
        JPanel listanje = new JPanel(new GridLayout(2, 1));
        listanje.setBorder(BorderFactory.createTitledBorder("Listnje"));
        listanje.setBackground(Color.white);
        Dimension buttonSize = new Dimension(50, 20);
        JPanel pan = new JPanel(new GridLayout(1, 4));
        pan.setBackground(Color.white);
        JButton pocetak = new JButton("<<");
        pocetak.setPreferredSize(buttonSize);
        JPanel pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(pocetak);
        pan.add(pom);
        JButton predhodna = new JButton(" <");
        predhodna.setPreferredSize(buttonSize);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(predhodna);
        pan.add(pom);
        JButton sledeca = new JButton("> ");
        sledeca.setPreferredSize(buttonSize);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(sledeca);
        pan.add(pom);
        JButton kraj = new JButton(">>");
        kraj.setPreferredSize(buttonSize);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(kraj);
        pan.add(pom);
        listanje.add(pan);
        this.lblTrenutnaStrana = new JLabel("Trenutno odabrana strana: " + this.trnutnaStrana + ", od ukupno: " + this.UKUPNO_STRANA);
        this.lblTrenutnaStrana.setVerticalAlignment(0);
        this.lblTrenutnaStrana.setHorizontalAlignment(4);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(this.lblTrenutnaStrana);
        listanje.add(pom);
        this.add((Component)listanje, "Center");
        JPanel kontr = new JPanel(new GridLayout(2, 4));
        kontr.setBackground(Color.white);
        JLabel adr = new JLabel("Adresa: ");
        adr.setBackground(Color.white);
        adr.setVerticalAlignment(0);
        adr.setHorizontalAlignment(4);
        kontr.add(adr);
        this.setAdr = new JTextField();
        this.setAdr.setColumns(8);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(this.setAdr);
        kontr.add(pom);
        JButton read = new JButton("\u010citaj");
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(read);
        kontr.add(pom);
        adr = new JLabel("  ");
        adr.setBackground(Color.white);
        kontr.add(adr);
        adr = new JLabel("Vrednost: ");
        adr.setBackground(Color.white);
        adr.setVerticalAlignment(0);
        adr.setHorizontalAlignment(4);
        kontr.add(adr);
        this.setVal = new JTextField();
        this.setVal.setColumns(8);
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(this.setVal);
        kontr.add(pom);
        JButton write = new JButton("Upi\u0161i");
        pom = new JPanel();
        pom.setBackground(Color.white);
        pom.add(write);
        kontr.add(pom);
        adr = new JLabel("  ");
        adr.setBackground(Color.white);
        kontr.add(adr);
        this.add((Component)kontr, "South");
        pocetak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GuiMemorija.this.setToStart();
                GuiMemorija.this.table.repaint();
                GuiMemorija.this.iscrtajLabeluZaTrenutnuStranu();
            }
        });
        kraj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GuiMemorija.this.model.popuniData(1048512);
                GuiMemorija.this.trnutnaStrana = GuiMemorija.this.UKUPNO_STRANA;
                GuiMemorija.this.table.repaint();
                GuiMemorija.this.iscrtajLabeluZaTrenutnuStranu();
            }
        });
        sledeca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiMemorija.this.trnutnaStrana == GuiMemorija.this.UKUPNO_STRANA) {
                    return;
                }
                GuiMemorija guiMemorija = GuiMemorija.this;
                guiMemorija.trnutnaStrana = guiMemorija.trnutnaStrana + 1;
                GuiMemorija.this.model.popuniData(GuiMemorija.this.trnutnaStrana * 64);
                GuiMemorija.this.table.repaint();
                GuiMemorija.this.iscrtajLabeluZaTrenutnuStranu();
            }
        });
        predhodna.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GuiMemorija.this.trnutnaStrana == 0) {
                    return;
                }
                GuiMemorija guiMemorija = GuiMemorija.this;
                guiMemorija.trnutnaStrana = guiMemorija.trnutnaStrana - 1;
                GuiMemorija.this.model.popuniData(GuiMemorija.this.trnutnaStrana * 64);
                GuiMemorija.this.table.repaint();
                GuiMemorija.this.iscrtajLabeluZaTrenutnuStranu();
            }
        });
        read.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int adr = Integer.parseInt(GuiMemorija.this.setAdr.getText(), 16);
                GuiMemorija.this.trnutnaStrana = adr / 64;
                GuiMemorija.this.model.popuniData(GuiMemorija.this.trnutnaStrana * 64);
                int curentAdr = adr - GuiMemorija.this.trnutnaStrana * 64;
                try {
                    GuiMemorija.this.setVal.setText(GuiMemorija.this.model.getValueAt(curentAdr / 8, curentAdr % 8 + 1).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        write.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GuiMemorija.this.model.updateMem(GuiMemorija.this.setAdr.getText(), GuiMemorija.this.setVal.getText());
                GuiMemorija.this.table.repaint();
            }
        });
    }

    private void iscrtajLabeluZaTrenutnuStranu() {
        this.lblTrenutnaStrana.setText("Trenutno odabrana strana: " + this.trnutnaStrana + ", od ukupno: " + this.UKUPNO_STRANA);
    }

    public void setToStart() {
        this.model.popuniData(0);
        this.trnutnaStrana = 0;
        this.setAdr.setText("");
        this.setVal.setText("");
        this.iscrtajLabeluZaTrenutnuStranu();
    }
}

