/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;

public class Moje_Line
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected boolean slopeType = false;
    protected int lineThickness = 1;
    protected Polygon poly;

    public void setPositiveSlope(boolean type) throws PropertyVetoException {
        if (this.slopeType != type) {
            this.slopeType = type;
            this.repaint();
        }
    }

    public boolean isPositiveSlope() {
        return this.slopeType;
    }

    public void setLineThickness(int thickness) throws PropertyVetoException {
        if (this.lineThickness != thickness) {
            this.lineThickness = thickness;
            this.repaint();
        }
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.getSize();
        Dimension min = this.getMinimumSize();
        return new Dimension(Math.max(dim.width, min.width), Math.max(dim.height, min.height));
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
    }

    @Override
    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoablechangelistener) {
    }

    @Override
    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoablechangelistener) {
    }

    @Override
    public boolean contains(int x, int y) {
        double y2;
        double x2;
        double y1;
        double x1;
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.lineThickness > 1) {
            if (this.poly != null) {
                return this.poly.contains(x, y);
            }
            return false;
        }
        Dimension s = this.getSize();
        if (this.slopeType) {
            x1 = s.width;
            y1 = 0.0;
            x2 = 0.0;
            y2 = s.height;
        } else {
            x1 = s.width;
            y1 = s.height;
            x2 = 0.0;
            y2 = 0.0;
        }
        if (s.width > s.height) {
            double calc = Math.abs((y1 - y2) * ((double)x - x2) / (x1 - x2) + y2);
            return Math.abs((double)y - calc) < 0.7000000000000001;
        }
        double calc = Math.abs((x1 - x2) * ((double)y - y2) / (y1 - y2) + x2);
        return Math.abs((double)x - calc) < 0.7000000000000001;
    }

    @Override
    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        Dimension s = this.getSize();
        if (this.slopeType) {
            x1 = s.width;
            y1 = 0;
            x2 = 0;
            y2 = s.height;
        } else {
            x1 = s.width;
            y1 = s.height;
            x2 = 0;
            y2 = 0;
        }
        g.setColor(this.getForeground());
        if (this.lineThickness > 1) {
            int B2y;
            int A2x;
            int B1y;
            int A1x;
            double w = this.lineThickness / 2;
            double theta = 3.1416 - (1.5708 + Math.abs(Math.atan((double)(y1 - y2) / (double)(x1 - x2))));
            double a = Math.abs(w * Math.cos(theta));
            double b = Math.abs(w * Math.sin(theta));
            if (this.slopeType) {
                A1x = (int)((double)x1 - a - a);
                B1y = (int)((double)y1 + b + b);
                A2x = (int)((double)x2 + a + a);
                B2y = (int)((double)y2 - b - b);
            } else {
                A1x = (int)((double)x1 - a - a);
                B1y = (int)((double)y1 - b - b);
                A2x = (int)((double)x2 + a + a);
                B2y = (int)((double)y2 + b + b);
            }
            this.poly = new Polygon();
            this.poly.addPoint(A1x, y1);
            this.poly.addPoint(x1, B1y);
            this.poly.addPoint(A2x, y2);
            this.poly.addPoint(x2, B2y);
            g.fillPolygon(this.poly);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }
}

