/*
 * Decompiled with CFR 0.152.
 */
package element;

public class Utility {
    public static int BoolToDec(boolean[] s) {
        int d = 0;
        int i = 0;
        while (i < s.length) {
            if (s[i]) {
                d = (int)((double)d + Math.pow(2.0, i));
            }
            ++i;
        }
        return d;
    }

    public static boolean[] DecToBool(int d, int width) {
        boolean[] x = new boolean[width];
        String signal = "";
        signal = Integer.toBinaryString(d);
        int i = 0;
        while (i < signal.length()) {
            x[i] = signal.charAt(signal.length() - i - 1) == '1';
            ++i;
        }
        i = signal.length();
        while (i < x.length - signal.length()) {
            x[signal.length() + i] = false;
            ++i;
        }
        return x;
    }

    public static String SignalToString(boolean[] s, int base, int length) {
        String result = "";
        switch (base) {
            case 2: {
                result = Integer.toBinaryString(Utility.BoolToDec(s));
                break;
            }
            case 8: {
                result = Integer.toOctalString(Utility.BoolToDec(s));
                break;
            }
            case 16: {
                result = Integer.toHexString(Utility.BoolToDec(s));
                break;
            }
            case 10: {
                result = Integer.toString(Utility.BoolToDec(s));
            }
        }
        result = result.toUpperCase();
        if (result.length() < length) {
            result = String.valueOf(Utility.replicate('0', length - result.length())) + result;
        }
        return result;
    }

    public static boolean[] HexToBool(String s, int width) {
        int w = s.length() * 4 < width ? width : s.length() * 4;
        return Utility.DecToBool(Integer.parseInt(s, 16), w);
    }

    public static String replicate(char c, int count) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < count) {
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String signal = "0100100000";
        System.out.println(Utility.formatSignal(signal, -1));
    }

    public static boolean[] BoolInc(boolean[] s) {
        boolean carry = false;
        boolean[] result = new boolean[s.length];
        int i = 0;
        while (i < s.length) {
            if (i == 0) {
                result[i] = !s[i];
                carry = s[i];
            } else {
                result[i] = s[i] ^ carry;
                carry = s[i] && carry;
            }
            ++i;
        }
        return result;
    }

    public static boolean[] BoolDec(boolean[] s) {
        boolean[] result = new boolean[s.length];
        boolean carry = false;
        int i = 0;
        while (i < s.length) {
            result[i] = carry ^ (s[i] ^ true);
            carry = s[i] || carry;
            ++i;
        }
        return result;
    }

    public static boolean compareSignals(boolean[] s1, int start1, int end1, boolean[] s2, int start2, int end2) {
        boolean result = true;
        if (end2 - start2 == end1 - start1 && s2.length - 1 >= end2 - start2 && s1.length - 1 >= end1 - start1 && start1 >= 0 && start2 >= 0) {
            int i = 0;
            while (i <= end1 - start1) {
                result = s1[start1 + i] == s2[start2 + i] && result;
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static String formatSignal(String signal, int groupLength) {
        StringBuffer result = new StringBuffer();
        result.append(signal);
        String reverseSignal = result.reverse().toString();
        result.delete(0, signal.length());
        if (groupLength > 0) {
            int groupCount = reverseSignal.length() / groupLength;
            int i = 0;
            while (i < groupCount) {
                result.append(String.valueOf(reverseSignal.substring(i * groupLength, (i + 1) * groupLength)) + ' ');
                ++i;
            }
            if (groupCount * groupLength < reverseSignal.length()) {
                result.append(String.valueOf(reverseSignal.substring(groupCount * groupLength, reverseSignal.length())) + ' ');
            }
        }
        return result.reverse().toString();
    }
}

