/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DisplaySignal
extends JLabel {
    private static final long serialVersionUID = 1L;
    private boolean[] signal;
    private int base;
    private int width;
    private JPopupMenu menu;

    public void setSignal(boolean[] s) {
        this.signal = s;
        this.setText(String.valueOf(this.conversion()) + this.getFormat());
        this.setToolTipText();
    }

    private void setToolTipText() {
        super.setToolTipText(String.valueOf(Utility.formatSignal(this.conversion(), this.getGroupLength())) + this.getFormat());
    }

    private String conversion() {
        int width;
        this.width = width = (int)Math.ceil((double)this.signal.length * Math.log(2.0) / Math.log(this.base));
        return Utility.SignalToString(this.signal, this.base, width);
    }

    private String getFormat() {
        String format = "";
        switch (this.base) {
            case 2: {
                format = "b";
                break;
            }
            case 8: {
                format = "o";
                break;
            }
            case 10: {
                format = "d";
                break;
            }
            case 16: {
                format = "h";
            }
        }
        return format;
    }

    private int getGroupLength() {
        int groupLength = 0;
        switch (this.base) {
            case 2: {
                groupLength = 4;
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                groupLength = this.width;
            }
        }
        return groupLength;
    }

    public DisplaySignal() {
        this(new boolean[4], 16, 4);
    }

    public DisplaySignal(int w) {
        this(new boolean[w], 16, w);
    }

    public DisplaySignal(boolean[] s, int w) {
        this(s, 16, w);
    }

    public DisplaySignal(boolean[] s, int b, int w) {
        this.base = b;
        this.width = w;
        this.setText(Utility.SignalToString(s, this.base, this.width));
        this.setOpaque(true);
        this.setHorizontalTextPosition(0);
        this.setBackground(new Color(255, 240, 245));
        this.setFont(new Font("Courier", 0, 10));
        this.setVerticalTextPosition(0);
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.menu = new JPopupMenu();
        JMenuItem item1 = new JMenuItem();
        item1.setText("Binarni prikaz");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplaySignal.this.base = 2;
                DisplaySignal.this.setToolTipText();
            }
        });
        this.menu.add(item1);
        JMenuItem item2 = new JMenuItem();
        item2.setText("Oktalni prikaz");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplaySignal.this.base = 8;
                DisplaySignal.this.setToolTipText();
            }
        });
        this.menu.add(item2);
        JMenuItem item3 = new JMenuItem();
        item3.setText("Decimalni prikaz");
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplaySignal.this.base = 10;
                DisplaySignal.this.setToolTipText();
            }
        });
        this.menu.add(item3);
        JMenuItem item4 = new JMenuItem();
        item4.setText("Heksadecimlani prikaz");
        item4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplaySignal.this.base = 16;
                DisplaySignal.this.setToolTipText();
            }
        });
        this.menu.add(item4);
        this.setComponentPopupMenu(this.menu);
    }
}

