/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.StepDescription;
import element.TAB;
import exception.SignalWidthException;
import java.io.Serializable;

public abstract class SignalCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int currentEntry = 0;
    private TAB tab;
    private TAB copyOfTAB;
    private int Tclk = 0;
    protected boolean[] WCNT = new boolean[8];
    protected boolean ldWCNT;
    protected boolean decWCNT;
    protected boolean OUT;
    protected boolean TV;
    protected boolean wrTAB;
    protected boolean incECNT;
    protected boolean stEND;
    protected boolean END;
    protected boolean[] ECNT = new boolean[(int)(Math.log(32.0) / Math.log(2.0))];
    protected boolean[] MODE = new boolean[2];
    protected boolean[] PAR = new boolean[16];
    protected boolean[] PDRWR = new boolean[8];
    protected boolean[] PDRRD = new boolean[8];
    protected boolean PRQRD = false;
    protected boolean PRQWR = false;
    protected boolean ldPDRWR = false;
    protected boolean ldPDRRD = false;
    protected boolean rd = false;
    protected boolean wr = false;
    protected boolean ldMODE = false;
    protected boolean PRQ = false;
    protected boolean ldPAR = false;
    protected boolean[] CPUCNT = new boolean[3];
    protected boolean[] CPUT = new boolean[(int)Math.pow(2.0, 3.0)];
    protected boolean incCPUCNT;
    protected boolean ldCPUCNT;
    protected boolean CRP = false;
    protected boolean writeMEM = false;
    protected boolean[] CDRRD = new boolean[8];
    protected boolean[] CDRWR = new boolean[8];
    protected boolean CRD;
    protected boolean CWR;
    protected boolean clCRD;
    protected boolean clCWR;
    protected boolean ldCDRRD;
    protected boolean[] CAR = new boolean[16];
    protected boolean writeV;
    protected boolean[] stV = new boolean[8];
    protected boolean[] vectorV = new boolean[8];
    protected boolean HM = false;
    protected boolean mxDIDATA;
    protected boolean writeDATA;
    protected boolean mxADATA;
    protected boolean incMEMACC;
    protected boolean[] MEMACC = new boolean[2];
    protected boolean MEMFC;
    protected boolean incCNTBB;
    protected boolean[] CNTBB = new boolean[2];
    protected boolean CNTBB3;
    protected boolean[] MDRWR = new boolean[8];
    protected boolean[] MAR = new boolean[16];
    protected boolean ldMAR;
    protected boolean ldMDRRD;
    protected boolean ldMDRWR;
    protected boolean[] MDRRD = new boolean[8];
    protected boolean[] MEMDRD = new boolean[8];
    protected boolean run;
    protected boolean ldCACHECNT;
    protected boolean[] CACHECNT;
    protected boolean[] CACHET;
    protected boolean[][] MEM = new boolean[(int)Math.pow(2.0, 16.0)][8];
    protected boolean[][] copyOfMEM = new boolean[(int)Math.pow(2.0, 16.0)][8];
    protected StepDescription cpuDesc;
    protected StepDescription cacheDesc;

    public SignalCache() throws SignalWidthException {
        this.tab = new TAB(8, 16, 8, 2);
    }

    public TAB getTAB() {
        try {
            if (this.tab == null) {
                this.tab = new TAB(8, 16, 8, 2);
            }
        }
        catch (SignalWidthException e) {
            e.printStackTrace();
        }
        return this.tab;
    }

    public int getCurrentEntry() {
        return this.currentEntry;
    }

    public boolean[] getWCNT() {
        return this.WCNT;
    }

    public boolean isLdWCNT() {
        return this.ldWCNT;
    }

    public boolean isDecWCNT() {
        return this.decWCNT;
    }

    public boolean isOUT() {
        return this.OUT;
    }

    public boolean isTV() {
        return this.TV;
    }

    public boolean isWrTAB() {
        return this.wrTAB;
    }

    public boolean isIncECNT() {
        return this.incECNT;
    }

    public boolean isStEND() {
        return this.stEND;
    }

    public boolean isEND() {
        return this.END;
    }

    public boolean[] getECNT() {
        return this.ECNT;
    }

    public boolean[] getMODE() {
        return this.MODE;
    }

    public boolean[] getPAR() {
        return this.PAR;
    }

    public boolean[] getPDRWR() {
        return this.PDRWR;
    }

    public boolean[] getPDRRD() {
        return this.PDRRD;
    }

    public boolean isPRQRD() {
        return this.PRQRD;
    }

    public boolean isPRQWR() {
        return this.PRQWR;
    }

    public boolean isLdPDRWR() {
        return this.ldPDRWR;
    }

    public boolean isLdPDRRD() {
        return this.ldPDRRD;
    }

    public boolean isRd() {
        return this.rd;
    }

    public boolean isWr() {
        return this.wr;
    }

    public boolean isLdMODE() {
        return this.ldMODE;
    }

    public boolean isPRQ() {
        return this.PRQ;
    }

    public boolean isLdPAR() {
        return this.ldPAR;
    }

    public boolean[] getCPUCNT() {
        return this.CPUCNT;
    }

    public boolean[] getCPUT() {
        return this.CPUT;
    }

    public boolean isIncCPUCNT() {
        return this.incCPUCNT;
    }

    public boolean isLdCPUCNT() {
        return this.ldCPUCNT;
    }

    public boolean isCRP() {
        return this.CRP;
    }

    public boolean isWriteMEM() {
        return this.writeMEM;
    }

    public boolean[] getCDRRD() {
        return this.CDRRD;
    }

    public boolean[] getCDRWR() {
        return this.CDRWR;
    }

    public boolean isCRD() {
        return this.CRD;
    }

    public boolean isCWR() {
        return this.CWR;
    }

    public boolean isClCRD() {
        return this.clCRD;
    }

    public boolean isClCWR() {
        return this.clCWR;
    }

    public boolean isLdCDRRD() {
        return this.ldCDRRD;
    }

    public boolean[] getCAR() {
        return this.CAR;
    }

    public boolean isWriteV() {
        return this.writeV;
    }

    public boolean[] getStV() {
        return this.stV;
    }

    public boolean[] getVectorV() {
        return this.vectorV;
    }

    public boolean isIncMEMACC() {
        return this.incMEMACC;
    }

    public boolean[] getMEMACC() {
        return this.MEMACC;
    }

    public boolean isMEMFC() {
        return this.MEMFC;
    }

    public boolean isIncCNTBB() {
        return this.incCNTBB;
    }

    public boolean[] getCNTBB() {
        return this.CNTBB;
    }

    public boolean isCNTBB3() {
        return this.CNTBB3;
    }

    public boolean[] getMDRWR() {
        return this.MDRWR;
    }

    public boolean[] getMAR() {
        return this.MAR;
    }

    public boolean isLdMAR() {
        return this.ldMAR;
    }

    public boolean isLdMDRRD() {
        return this.ldMDRRD;
    }

    public boolean isLdMDRWR() {
        return this.ldMDRWR;
    }

    public boolean[] getMDRRD() {
        return this.MDRRD;
    }

    public boolean[] getMEMDRD() {
        return this.MEMDRD;
    }

    public boolean isRun() {
        return this.run;
    }

    public boolean isLdCACHECNT() {
        return this.ldCACHECNT;
    }

    public boolean[] getCACHECNT() {
        return this.CACHECNT;
    }

    public boolean[] getCACHET() {
        return this.CACHET;
    }

    public void clock() {
        ++this.Tclk;
    }

    public boolean[][] getMEM() {
        return this.MEM;
    }

    public void setMEM(int adr, boolean[] word) {
        System.arraycopy(word, 0, this.MEM[adr], 0, 8);
    }

    public boolean isHM() {
        return this.HM;
    }

    public boolean isMxDIDATA() {
        return this.mxDIDATA;
    }

    public boolean isWriteDATA() {
        return this.writeDATA;
    }

    public boolean isMxADATA() {
        return this.mxADATA;
    }

    public StepDescription getCpuDesc() {
        return this.cpuDesc;
    }

    public void setCpuDesc(StepDescription cpuDesc) {
        this.cpuDesc = cpuDesc;
    }

    public StepDescription getCacheDesc() {
        return this.cacheDesc;
    }

    public void setCacheDesc(StepDescription cacheDesc) {
        this.cacheDesc = cacheDesc;
    }

    public TAB getCopyOfTAB() {
        return this.copyOfTAB;
    }

    public void copyTAB() {
        try {
            this.copyOfTAB = new TAB(8, 16, 8, 2);
            int i = 0;
            while (i < 32) {
                this.copyOfTAB.writeV(i, this.tab.readV(i));
                this.copyOfTAB.writeMODE(i, this.tab.readMODE(i));
                this.copyOfTAB.writeWAIT(i, this.tab.readWAIT(i));
                this.copyOfTAB.writeADR(i, this.tab.readADR(i));
                this.copyOfTAB.writeDATA(i, this.tab.readDATA(i));
                ++i;
            }
        }
        catch (SignalWidthException e) {
            e.printStackTrace();
        }
    }

    public boolean[][] getCopyOfMEM() {
        return this.copyOfMEM;
    }

    public void copyMEM() {
        int capacity = (int)Math.pow(2.0, 16.0);
        this.copyOfMEM = new boolean[capacity][8];
        int i = 0;
        while (i < capacity) {
            int j = 0;
            while (j < 8) {
                this.copyOfMEM[i][j] = this.MEM[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void setTab(TAB tab) {
        try {
            int i = 0;
            while (i < 32) {
                this.tab.writeV(i, tab.readV(i));
                this.tab.writeMODE(i, tab.readMODE(i));
                this.tab.writeWAIT(i, tab.readWAIT(i));
                this.tab.writeADR(i, tab.readADR(i));
                this.tab.writeDATA(i, tab.readDATA(i));
                ++i;
            }
        }
        catch (SignalWidthException e) {
            e.printStackTrace();
        }
    }

    public void setMEM(boolean[][] mem) {
        int capacity = (int)Math.pow(2.0, 16.0);
        int i = 0;
        while (i < capacity) {
            int j = 0;
            while (j < 8) {
                this.MEM[i][j] = mem[i][j];
                ++j;
            }
            ++i;
        }
    }

    public int getTclk() {
        return this.Tclk;
    }

    public void setTclk(int tclk) {
        this.Tclk = tclk;
    }
}

