/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logic.Pin;
import util.NameConnector;

public class TimeHistory {
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final int TRI = 2;
    public static final String TRISTATE = "Z";
    private List<String> history = new ArrayList<String>();
    private List<Map<String, String>> multiHistrory = new ArrayList<Map<String, String>>();
    public Map<String, Integer> signals = new HashMap<String, Integer>();
    private List<Pin> pins = new ArrayList<Pin>();
    private List<TimeHistoryObserver> observers;

    public TimeHistory(List<String> names) {
        int i = 0;
        for (String name : names) {
            this.signals.put(name, i++);
            Pin pin = NameConnector.getPin(name);
            pin.setName(name);
            this.pins.add(pin);
        }
        this.observers = new LinkedList<TimeHistoryObserver>();
    }

    public void addClkState() {
        String newState = String.format("%0" + (this.pins.size() + 1) + "X", 0);
        HashMap<String, String> newMultiState = new HashMap<String, String>();
        int i = 0;
        while (i < this.pins.size()) {
            Pin pin = this.pins.get(i);
            if (pin.getNumOfLines() == 1) {
                newState = pin.isHighZ() ? this.addSignalToClkState(2, newState, i) : (pin.getBoolVal() ? this.addSignalToClkState(1, newState, i) : this.addSignalToClkState(0, newState, i));
            } else if (pin.isHighZ()) {
                newMultiState.put(pin.getName(), TRISTATE);
            } else {
                newMultiState.put(pin.getName(), "" + pin.getIntVal());
            }
            ++i;
        }
        this.history.add(newState);
        this.multiHistrory.add(newMultiState);
        this.update();
    }

    public String addSignalToClkState(int signalState, String clkState, int i) {
        try {
            String newValue = Integer.toHexString(signalState);
            return String.valueOf(clkState.substring(0, i)) + newValue + clkState.substring(i + 1);
        }
        catch (Exception e) {
            return clkState;
        }
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public List<String> getHistory() {
        return this.history;
    }

    public void setHistory(ArrayList<String> history) {
        this.history = history;
    }

    public List<Map<String, String>> getMultiHistrory() {
        return this.multiHistrory;
    }

    public void setMultiHistrory(List<Map<String, String>> multiHistrory) {
        this.multiHistrory = multiHistrory;
    }

    public void clearHistory(int beginIndex) {
        int hsize = this.getHistorySize();
        int i = beginIndex;
        while (i < hsize) {
            this.history.remove(beginIndex);
            this.multiHistrory.remove(beginIndex);
            ++i;
        }
        this.update();
    }

    public boolean isEmpty() {
        return this.signals == null || this.signals.size() == 0;
    }

    public int getSignalFromHistory(int clk, String name) {
        if (this.signals.containsKey(name)) {
            int index = this.signals.get(name);
            int val = Integer.parseInt("" + this.history.get(clk).charAt(index), 16);
            return val;
        }
        return 0;
    }

    public String getMultiSignalFromHistory(int i, String name) {
        try {
            Map<String, String> tmp = this.multiHistrory.get(i);
            return tmp.get(name);
        }
        catch (Exception e) {
            return "NNNN";
        }
    }

    public void addObserver(TimeHistoryObserver observer) {
        this.observers.add(observer);
    }

    public void clearObservers() {
        this.observers.clear();
    }

    public void update() {
        for (TimeHistoryObserver observer : this.observers) {
            observer.update();
        }
    }

    public static interface TimeHistoryObserver {
        public void update();
    }
}

