/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import main.SimulatorActions;
import shemes.components.Bus1;
import shemes.components.Exec3;
import shemes.components.Fetch1;
import shemes.components.Fetch2;
import shemes.components.Fetch3;
import shemes.components.ProcesorUpravljacka;
import shemes.components.SignaliUpravljackeJedinice;
import util.DefaultParameters;
import util.Log;
import util.Messages;

public class Parameters {
    public static int numberOfRegisters;
    public static int GPRARStartPosition;
    public static int GPRNumberOfBits;
    public static String[][] fetch1Conections;
    public static String[][] fetch2Conections;
    public static String[][] fetch3Conections;
    public static String[][] exec3Conections;
    public static String[][] counterCodeAddresses;
    public static String[][] counterAdrModesAddresses;
    public static String[][] controlUnitDecoder;
    public static String[][] controlUnitOperationSignals;
    public static int oprSignalSize;
    public static int uprSignalUslovSize;
    public static int uprSignalBranchSize;
    private static int dataSize;
    private static int addressableUnit;
    public static int memdelay;
    public static String dataSizeString;
    public static String addressableUnitString;
    public static String memdelayString;
    public static String numberOfRegistersString;
    public static String GPRARStartPositionString;
    public static String GPRNumberOfBitsString;
    public static String configurationFile;
    public static String microprogramFile;
    public static String errorFile;
    public static Map<Class<?>, String> comments;
    public static Map<Class<?>, String> configuration;
    private static boolean valsAvailable;
    private static Map<String, String> vals;
    private static boolean microcodeLinesAvailable;
    public static List<String> microcodeLines;
    private static Map<String, Class<?>> converter;
    public static int sizeSP;
    public static int valSP;
    public static int sizeCW;
    public static int valCW;
    public static int valGPRAR;
    public static int sizeR;
    public static int[] valsR;
    public static int sizeIBUS1;
    public static int sizeIBUS2;
    public static int sizeIBUS3;
    public static int sizeABUS;
    public static int sizeDBUS;
    public static int sizeMAR;
    public static int valMAR;
    public static int sizeMDR;
    public static int valMDR;
    public static int sizeDWL;
    public static int valDWL;
    public static int sizeDWH;
    public static int valDWH;
    public static int sizeDW;
    public static int sizeAB;
    public static int valAB;
    public static int sizeBB;
    public static int valBB;
    public static int sizeAW;
    public static int valAW;
    public static int sizeAWH;
    public static int sizeBW;
    public static int valBW;
    public static int sizeALU;
    public static int sizePC;
    public static int valPC;
    public static int sizePCH;
    public static int sizePCL;
    public static int sizeIMR;
    public static int valIMR;
    public static int sizeIVTP;
    public static int valIVTP;
    public static int sizeMemAdr;
    public static int sizeMemData;

    static {
        configurationFile = "./konfiguracija.txt";
        microprogramFile = "./microProgram.txt";
        errorFile = "./error.txt";
        valsAvailable = false;
        vals = null;
        microcodeLinesAvailable = false;
        microcodeLines = null;
        converter = new HashMap();
        converter.put("", Bus1.class);
        converter.put("FETCH1", Fetch1.class);
        converter.put("FETCH2", Fetch2.class);
        converter.put("FETCH3", Fetch3.class);
        converter.put("EXEC3", Exec3.class);
        converter.put("KMOPR1", ProcesorUpravljacka.class);
        converter.put("KMADR1", ProcesorUpravljacka.class);
        converter.put("CONTRODC", SignaliUpravljackeJedinice.class);
    }

    public static void init() {
        if (valsAvailable) {
            Parameters.init(vals);
        } else {
            Parameters.init(configurationFile);
        }
        if (!microcodeLinesAvailable) {
            microcodeLines = Parameters.loadLines(microprogramFile);
        }
    }

    private static void init(String file) {
        Parameters.reset();
        HashMap<String, List<String[]>> data = new HashMap<String, List<String[]>>();
        comments = new HashMap();
        configuration = new HashMap();
        LinkedList<String> currentComments = new LinkedList<String>();
        Parameters.redirect(errorFile, true, true);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (!Parameters.isEmpty(line)) {
                        String name = Parameters.getLineName(line);
                        Parameters.extractParam(data, line, name);
                        Parameters.loadComment(comments, name, currentComments);
                        continue;
                    }
                    currentComments.add(line);
                }
                Parameters.loadParam(data);
                Parameters.loadConfiguration(configuration);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.Parameters"));
        }
        Parameters.fill();
    }

    private static void init(Map<String, String> vals) {
        HashMap<String, List<String[]>> data = new HashMap<String, List<String[]>>();
        Parameters.redirect(errorFile, true, true);
        try {
            for (String tName : vals.keySet()) {
                String[] lines;
                String val = vals.get(tName);
                Parameters.clear(tName);
                String[] stringArray = lines = val.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (!Parameters.isEmpty(line)) {
                        String name = Parameters.getLineName(line);
                        Parameters.extractParam(data, line, name);
                    }
                    ++n2;
                }
            }
            Parameters.loadParam(data);
            Parameters.loadConfiguration(configuration);
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.Parameters"));
        }
        Parameters.fill();
    }

    private static void loadConfiguration(Map<Class<?>, String> configuration) {
        String[][] cpuConfiguration = new String[][]{{"dataSize", String.valueOf(dataSize)}, {"numberOfRegisters", String.valueOf(numberOfRegisters)}, {"GPRARStartPosition", String.valueOf(GPRARStartPosition)}, {"GPRNumberOfBits", String.valueOf(GPRNumberOfBits)}, {"memdelay", String.valueOf(memdelay)}, {"addressableUnit", String.valueOf(addressableUnit)}};
        configuration.put(Bus1.class, Parameters.append(new StringBuilder(), "", cpuConfiguration).toString());
        configuration.put(Fetch1.class, Parameters.append(new StringBuilder(), "FETCH1", fetch1Conections).toString());
        configuration.put(Fetch2.class, Parameters.append(new StringBuilder(), "FETCH2", fetch2Conections).toString());
        configuration.put(Fetch3.class, Parameters.append(new StringBuilder(), "FETCH3", fetch3Conections).toString());
        configuration.put(Exec3.class, Parameters.append(new StringBuilder(), "EXEC3", exec3Conections).toString());
        String procesosUpravljacka = Parameters.append(Parameters.append(new StringBuilder(), "KMOPR1", counterCodeAddresses), "KMADR1", counterAdrModesAddresses).toString();
        configuration.put(ProcesorUpravljacka.class, procesosUpravljacka);
        configuration.put(SignaliUpravljackeJedinice.class, Parameters.append(new StringBuilder(), "CONTRODC", controlUnitDecoder).toString());
    }

    private static void loadComment(Map<Class<?>, String> comments, String name, List<String> currentComments) {
        Class<Object> tmpClass = converter.get(name);
        if (tmpClass == null) {
            tmpClass = Bus1.class;
        }
        String tmp = comments.get(tmpClass);
        StringBuilder sb = new StringBuilder();
        if (tmp != null) {
            sb = sb.append(tmp);
        }
        for (String s : currentComments) {
            sb = sb.append("\n").append(s);
        }
        comments.put(tmpClass, sb.toString());
        currentComments.clear();
    }

    public static void saveConfiguration(String oldName, String newName) {
        String line;
        Closeable in;
        Object var5_9;
        StringBuilder sb = new StringBuilder();
        HashSet<String> data = new HashSet<String>();
        Parameters.redirect(errorFile, true, true);
        try {
            Throwable throwable = null;
            var5_9 = null;
            try {
                in = new BufferedReader(new FileReader(oldName));
                try {
                    while ((line = ((BufferedReader)in).readLine()) != null) {
                        if (!Parameters.isEmpty(line)) {
                            String name = Parameters.getLineName(line);
                            Parameters.saveParam(data, line, name, sb);
                            continue;
                        }
                        sb = sb.append(line).append("\n");
                    }
                }
                finally {
                    if (in != null) {
                        ((BufferedReader)in).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.Parameters"));
        }
        try {
            Throwable e = null;
            var5_9 = null;
            try {
                in = new PrintWriter(new FileWriter(newName));
                try {
                    line = sb.toString();
                    ((PrintWriter)in).print(line);
                }
                finally {
                    if (in != null) {
                        ((PrintWriter)in).close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.Parameters"));
        }
        valsAvailable = false;
    }

    public static void saveMicrocode(String oldName, String newName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter in = new PrintWriter(new FileWriter(newName));){
                for (String line : microcodeLines) {
                    in.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.Microcode"));
        }
        microcodeLinesAvailable = false;
    }

    private static void clear(String name) {
        switch (name) {
            case "Fetch1": {
                fetch1Conections = new String[0][0];
                break;
            }
            case "Fetch2": {
                fetch2Conections = new String[0][0];
                break;
            }
            case "Fetch3": {
                fetch3Conections = new String[0][0];
                break;
            }
            case "Exec3": {
                exec3Conections = new String[0][0];
                break;
            }
            case "Counter": {
                counterCodeAddresses = new String[0][0];
                counterAdrModesAddresses = new String[0][0];
                break;
            }
            case "Uprav1": {
                controlUnitDecoder = new String[0][0];
            }
        }
    }

    public static void extractParam(Map<String, List<String[]>> data, String line, String name) {
        if ("dataSize".equals(name)) {
            int val = Parameters.getLineInt(line);
            dataSizeString = "" + val;
            if (val == 8 || val == 16) {
                dataSize = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorSirina"));
            }
        } else if ("memdelay".equals(name)) {
            int val = Parameters.getLineInt(line);
            memdelayString = "" + val;
            if (val >= 0 && val < 256) {
                memdelay = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorKasnjenjeMemorije"));
            }
        } else if ("addressableUnit".equals(name)) {
            int val = Parameters.getLineInt(line);
            addressableUnitString = "" + val;
            if (val == 8 || val == 16) {
                addressableUnit = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorAdresibilnaJedinica"));
            }
        } else if ("numberOfRegisters".equals(name)) {
            int val = Parameters.getLineInt(line);
            numberOfRegistersString = "" + val;
            if (val == 0 || val == 2 || val == 4 || val == 8 || val == 16 || val == 32 || val == 64) {
                numberOfRegisters = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorBrojRegistara"));
            }
        } else if ("GPRARStartPosition".equals(name)) {
            int val = Parameters.getLineInt(line);
            GPRARStartPositionString = "" + val;
            if (val >= 0 && val <= 32) {
                GPRARStartPosition = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorStartPosition"));
            }
        } else if ("GPRNumberOfBits".equals(name)) {
            int val = Parameters.getLineInt(line);
            GPRNumberOfBitsString = "" + val;
            if (val >= 0 && val <= 6) {
                GPRNumberOfBits = val;
            } else {
                SimulatorActions.addErrorMessage(Messages.getString("Parameters.ErrorBrojBitaZaRegs"));
            }
        } else {
            List<String[]> row = data.get(name);
            if (row == null) {
                row = new LinkedList<String[]>();
                data.put(name, row);
            }
            String[] s = Parameters.getLine(line);
            row.add(s);
        }
    }

    public static void saveParam(Set<String> data, String line, String name, StringBuilder sb) {
        if ("dataSize".equals(name)) {
            sb = sb.append("\"dataSize\", \"").append(dataSize).append("\"\n\n");
        } else if ("memdelay".equals(name)) {
            sb = sb.append("\"memdelay\", \"").append(memdelay).append("\"\n\n");
        } else if ("addressableUnit".equals(name)) {
            sb = sb.append("\"addressableUnit\", \"").append(addressableUnit).append("\"\n\n");
        } else if ("numberOfRegisters".equals(name)) {
            sb = sb.append("\"numberOfRegisters\", \"").append(numberOfRegisters).append("\"\n\n");
        } else if ("GPRARStartPosition".equals(name)) {
            sb = sb.append("\"GPRARStartPosition\", \"").append(GPRARStartPosition).append("\"\n\n");
        } else if ("GPRNumberOfBits".equals(name)) {
            sb = sb.append("\"GPRNumberOfBits\", \"").append(GPRNumberOfBits).append("\"\n\n");
        } else if ("FETCH1".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "FETCH1", fetch1Conections);
            data.add(name);
        } else if ("FETCH2".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "FETCH2", fetch2Conections);
            data.add(name);
        } else if ("FETCH3".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "FETCH3", fetch3Conections);
            data.add(name);
        } else if ("EXEC3".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "EXEC3", exec3Conections);
            data.add(name);
        } else if ("KMOPR1".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "KMOPR1", counterCodeAddresses);
            data.add(name);
        } else if ("KMADR1".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "KMADR1", counterAdrModesAddresses);
            data.add(name);
        } else if ("CONTRODC".equals(name) && !data.contains(name)) {
            sb = Parameters.append(sb, "CONTRODC", controlUnitDecoder);
            data.add(name);
        }
    }

    private static StringBuilder append(StringBuilder sb, String name, String[][] args) {
        String[][] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            boolean first = true;
            if (name != null && !name.equals("")) {
                sb = sb.append("\"").append(name).append("\"");
                first = false;
            }
            String[] stringArray2 = line;
            int n3 = line.length;
            int n4 = 0;
            while (n4 < n3) {
                String d = stringArray2[n4];
                sb = first ? sb.append("\"").append(d).append("\"") : sb.append(", \"").append(d).append("\"");
                first = false;
                ++n4;
            }
            sb = sb.append("\n");
            ++n2;
        }
        sb = sb.append("\n");
        return sb;
    }

    public static void loadParam(Map<String, List<String[]>> data) {
        for (String key : data.keySet()) {
            List<String[]> param = data.get(key);
            if ("FETCH1".equals(key)) {
                fetch1Conections = Parameters.convert(param);
            }
            if ("FETCH2".equals(key)) {
                fetch2Conections = Parameters.convert(param);
            }
            if ("FETCH3".equals(key)) {
                fetch3Conections = Parameters.convert(param);
            }
            if ("EXEC3".equals(key)) {
                exec3Conections = Parameters.convert(param);
            }
            if ("KMOPR1".equals(key)) {
                counterCodeAddresses = Parameters.convert(param);
                Parameters.testAddresses(counterCodeAddresses);
            }
            if ("KMADR1".equals(key)) {
                counterAdrModesAddresses = Parameters.convert(param);
                Parameters.testAddresses(counterAdrModesAddresses);
            }
            if (!"CONTRODC".equals(key)) continue;
            controlUnitDecoder = Parameters.convert(param);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void testAddresses(String[][] data) {
        var4_1 = data;
        var3_2 = data.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            block9: {
                line = var4_1[var2_3];
                if (line.length < 2) {
                    sb = new StringBuilder(Messages.getString("Parameters.ErrorInLine"));
                    var9_11 = line;
                    var8_10 = line.length;
                    var7_8 = 0;
                    while (var7_8 < var8_10) {
                        arg = var9_11[var7_8];
                        sb.append(" ").append(arg);
                        ++var7_8;
                    }
                    SimulatorActions.addErrorMessage(sb.toString());
                } else {
                    try {
                        val = line[1];
                        if (val.endsWith("h")) {
                            val = val.substring(0, val.length() - 1);
                            Integer.parseInt(val, 16);
                        } else {
                            Integer.parseInt(val);
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        sb = new StringBuilder(Messages.getString("Parameters.ErrorNumberFormat"));
                        var10_13 = line;
                        var9_12 = line.length;
                        var8_10 = 0;
                        ** while (var8_10 < var9_12)
                    }
lbl-1000:
                    // 1 sources

                    {
                        arg = var10_13[var8_10];
                        sb.append(" ").append(arg);
                        ++var8_10;
                        continue;
                    }
lbl40:
                    // 1 sources

                    SimulatorActions.addErrorMessage(sb.toString());
                }
            }
            ++var2_3;
        }
    }

    public static void redirect(String file, boolean stdin, boolean stderr) {
        try {
            if (stdin) {
                FileOutputStream outF = new FileOutputStream(file);
                PrintStream outP = new PrintStream(outF);
                System.setOut(outP);
            }
            if (stderr) {
                FileOutputStream errF = new FileOutputStream(file);
                PrintStream errP = new PrintStream(errF);
                System.setErr(errP);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected static String[] getLine(String line) {
        String[] result = null;
        try {
            line = line.trim();
            line = line.replace("\"", "");
            String[] data = line.split(",");
            result = new String[data.length - 1];
            int i = 0;
            while (i < result.length) {
                result[i] = data[i + 1].trim();
                ++i;
            }
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.ErrorInLineGeneral") + line);
        }
        return result;
    }

    protected static String getLineName(String line) {
        String result = "";
        try {
            line = line.trim();
            line = line.replace("\"", "");
            String[] data = line.split(",");
            result = data[0];
            result = result.trim();
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.ErrorInLineMsg") + line);
        }
        return result;
    }

    protected static int getLineInt(String line) {
        int result = -1;
        try {
            line = line.trim();
            line = line.replace("\"", "");
            String[] data = line.split(",");
            result = Integer.parseInt(data[1].trim());
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.ErrorInLineInt") + line);
        }
        return result;
    }

    protected static boolean isEmpty(String line) {
        boolean result = true;
        try {
            line = line.trim();
            return line.startsWith("//");
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.ErrorLineIsEmpty") + line);
            return result;
        }
    }

    protected static String[][] convert(List<String[]> row) {
        String[][] result = new String[row.size()][];
        int i = 0;
        while (i < row.size()) {
            result[i] = row.get(i);
            ++i;
        }
        return result;
    }

    public static int calcSize(String[][] data, String name) {
        try {
            String[] line = Parameters.getLine(data, name);
            return Integer.parseInt(line[2]);
        }
        catch (Exception e) {
            SimulatorActions.addErrorMessage(String.valueOf(e.toString()) + "\n" + Messages.getString("Parameters.ErrorCalcSize") + name);
            return 0;
        }
    }

    public static String[] getLine(String[][] data, String name) {
        String[][] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            if (line[1].equalsIgnoreCase(name)) {
                return line;
            }
            ++n2;
        }
        return null;
    }

    public static void fill() {
        sizeAB = dataSize;
        sizeBB = dataSize;
        sizeALU = dataSize;
        sizeDBUS = addressableUnit;
        sizeMDR = addressableUnit;
        sizeMemData = addressableUnit;
    }

    public static void reset() {
        numberOfRegisters = 32;
        GPRARStartPosition = 0;
        GPRNumberOfBits = 5;
        fetch1Conections = DefaultParameters.fetch1Conections;
        fetch2Conections = DefaultParameters.fetch2Conections;
        fetch3Conections = DefaultParameters.fetch3Conections;
        exec3Conections = DefaultParameters.exec3Conections;
        counterCodeAddresses = DefaultParameters.counterCodeAddresses;
        counterAdrModesAddresses = DefaultParameters.counterAdrModesAddresses;
        controlUnitDecoder = DefaultParameters.controlUnitDecoder;
        controlUnitOperationSignals = DefaultParameters.controlUnitOperationSignals;
        dataSize = 16;
        addressableUnit = 8;
        memdelay = 5;
        sizeSP = 16;
        valSP = 4096;
        sizeCW = 16;
        valCW = 0;
        valGPRAR = 0;
        sizeR = 16;
        valsR = DefaultParameters.valsR;
        sizeIBUS1 = 16;
        sizeIBUS2 = 16;
        sizeIBUS3 = 16;
        sizeABUS = 16;
        sizeDBUS = 8;
        sizeMAR = 16;
        valMAR = 0;
        sizeMDR = 8;
        valMDR = 0;
        sizeDWL = 8;
        valDWL = 0;
        sizeDWH = 8;
        valDWH = 0;
        sizeDW = 16;
        sizeAB = 8;
        valAB = 0;
        sizeBB = 8;
        valBB = 0;
        sizeAW = 16;
        valAW = 0;
        sizeAWH = 8;
        sizeBW = 16;
        valBW = 0;
        sizeALU = 16;
        sizePC = 16;
        valPC = 256;
        sizePCH = 8;
        sizePCL = 8;
        sizeIMR = 16;
        valIMR = 255;
        sizeIVTP = 16;
        valIVTP = 0;
        sizeMemAdr = 16;
        sizeMemData = 8;
        oprSignalSize = 96;
        uprSignalUslovSize = 8;
        uprSignalBranchSize = 8;
        microprogramFile = "./microProgram.txt";
        configurationFile = "./konfiguracija.txt";
        errorFile = "./error.txt";
    }

    public static void setVals(Map<String, String> vals) {
        valsAvailable = true;
        Parameters.vals = vals;
    }

    public static void setMicrocode(List<String> microcodeLines) {
        microcodeLinesAvailable = true;
        Parameters.microcodeLines = microcodeLines;
    }

    private static List<String> loadLines(String inFile) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(inFile));){
                String s;
                while ((s = in.readLine()) != null) {
                    result.add(s);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Log.errorLog(e, "Error " + inFile);
        }
        return result;
    }
}

