/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import logic.LogicComponent;
import logic.Pin;
import shemes.Schema;
import util.Log;

public class NameConnector {
    static Map<String, Pin> pins;
    static final String[] skipNames;
    static final Set<String> skipNamesSet;
    static Map<String, LogicComponent> components;
    static Map<String, Schema> schemas;

    static {
        skipNames = new String[]{"Fetch2.ADD", "Fetch2.AND", "Fetch2.ASL", "Fetch2.ASR", "Fetch2.DEC", "Fetch2.INC", "Fetch2.LDB", "Fetch2.LSL", "Fetch2.LSR", "Fetch2.NOT", "Fetch2.OR", "Fetch2.POPB", "Fetch2.ROL", "Fetch2.ROLC", "Fetch2.ROR", "Fetch2.RORC", "Fetch2.SUB", "Fetch2.XOR"};
        skipNamesSet = new HashSet<String>();
        String[] stringArray = skipNames;
        int n = skipNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            skipNamesSet.add(name.toLowerCase());
            ++n2;
        }
    }

    public static void addPins(String component, Map<String, Pin> componentPins) {
        for (String key : componentPins.keySet()) {
            Pin pin = pins.get(key = key.toLowerCase());
            if (pin != null) continue;
            pin = componentPins.get(key);
            if (pins.get(key) == null) {
                pins.put(key, pin);
            } else {
                pins.remove(key);
            }
            pins.put(String.valueOf(component) + "." + key, pin);
        }
    }

    public static void addPins(String component, Pin[] outputPins) {
        component = component.toLowerCase();
        Pin[] pinArray = outputPins;
        int n = outputPins.length;
        int n2 = 0;
        while (n2 < n) {
            Pin outputPin = pinArray[n2];
            String key = outputPin.getName();
            if (pins.get(key = key.toLowerCase()) == null) {
                pins.put(key, outputPin);
            } else {
                pins.remove(key);
            }
            String fullName = String.valueOf(component) + "." + key;
            if (pins.containsKey(fullName)) {
                Log.errorLog("Duplicate pin name:" + fullName);
            }
            pins.put(fullName, outputPin);
            ++n2;
        }
    }

    public static void addPin(String component, Pin outputPin) {
        NameConnector.addPin(component, outputPin.getName(), outputPin);
    }

    public static void addPin(String component, String pinName, Pin outputPin) {
        if (pinName == null || pinName.contains(".")) {
            Log.errorLog("Pin[" + pinName + "] sadrzi znak '.' u svom nazivu");
            return;
        }
        if (pins.get(pinName.toLowerCase()) == null) {
            pins.put(pinName.toLowerCase(), outputPin);
        } else {
            pins.remove(pinName.toLowerCase());
        }
        String fullName = String.valueOf(component.toLowerCase()) + "." + pinName.toLowerCase();
        if (pins.containsKey(fullName)) {
            Log.errorLog("Duplicate pin name:" + fullName);
        }
        pins.put(fullName, outputPin);
    }

    public static Pin getPin(String name) {
        String oldName;
        Pin result = pins.get(name = name.toLowerCase());
        if (result == null) {
            result = new Pin(false, name);
            if (!skipNamesSet.contains(name)) {
                Log.errorLog("Pin[" + name + "] nije definisan u konfiguracionom fajlu, a neko ga referencira");
            }
        }
        if ((oldName = result.getName()) == null || oldName.equals("")) {
            result.setName(name);
        }
        return result;
    }

    public static Map<String, Pin> listPins() {
        HashMap<String, Pin> result = new HashMap<String, Pin>();
        for (Map.Entry<String, Pin> entry : pins.entrySet()) {
            if (entry.getKey() == null || entry.getKey().contains(".")) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static List<String> listPinNames() {
        HashSet<String> temp = new HashSet<String>();
        for (Map.Entry<String, Pin> entry : pins.entrySet()) {
            if (entry.getKey() == null || entry.getKey().contains(".")) continue;
            temp.add(entry.getKey());
        }
        ArrayList<String> result = new ArrayList<String>(temp);
        Collections.sort(result);
        return result;
    }

    public static void addComponents(String componentName, List<LogicComponent> componentList) {
        if (components == null) {
            components = new HashMap<String, LogicComponent>();
        }
        int i = 0;
        for (LogicComponent subComponent : componentList) {
            String subComponentName = subComponent.getName();
            LogicComponent comp = components.get(subComponentName);
            if (comp != null) continue;
            if (subComponentName == null || "".equals(subComponentName)) {
                subComponentName = String.valueOf(componentName) + "." + i;
                components.put(subComponentName, subComponent);
                continue;
            }
            components.put(subComponentName, subComponent);
            String fullName = String.valueOf(componentName) + "." + subComponentName;
            if (components.containsKey(fullName)) {
                Log.errorLog("Duplicate component name:" + fullName);
            }
            components.put(String.valueOf(componentName) + "." + subComponentName, subComponent);
        }
    }

    public static void addComponent(String componentParent, String componentName, LogicComponent component) {
        if (components == null) {
            components = new HashMap<String, LogicComponent>();
        }
        components.put(componentName, component);
        String fullName = String.valueOf(componentParent) + "." + componentName;
        if (components.containsKey(fullName)) {
            Log.errorLog("Duplicate component name:" + fullName);
        }
        components.put(String.valueOf(componentParent) + "." + componentName, component);
    }

    public static LogicComponent getComponent(String name) {
        LogicComponent result = components.get(name);
        return result;
    }

    public static Map<String, LogicComponent> listComponents() {
        HashMap<String, LogicComponent> result = new HashMap<String, LogicComponent>(components);
        return result;
    }

    public static void addSchema(String schemaName, Schema schema) {
        if (schemas == null) {
            schemas = new HashMap<String, Schema>();
        }
        schemas.put(schemaName, schema);
    }

    public static Schema getSchema(String schemaName) {
        Schema result = schemas.get(schemaName);
        return result;
    }

    public static Map<String, Schema> listSchemas() {
        HashMap<String, Schema> result = new HashMap<String, Schema>(schemas);
        return result;
    }

    public static void reset() {
        pins = new HashMap<String, Pin>();
        pins.put("0", new Pin(false, "0"));
        pins.put("1", new Pin(true, "1"));
        components = null;
        schemas = null;
    }
}

