/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.Log;
import util.Parameters;

public class MicrocodeConverter {
    private static int NOJUMP = 0;
    private static final String NOJUMPS = "next";
    private static int UNCOND = 1;
    private static final String UNCONDS = "br";
    private static int BRADR = 22;
    private static final String BRADRS = "bradr";
    private static int BROPR = 23;
    private static final String BROPRS = "bropr";
    public static MicrocodeConverter microcodeConverter;
    private Map<Integer, MicrocodeData> data = new HashMap<Integer, MicrocodeData>();
    private List<Line> allLines = new LinkedList<Line>();
    static Map<String, Integer> branches;
    static Map<String, Integer> codesFields;
    static Map<Integer, String> fieldCodes;
    static Map<Integer, String> conditionCodes;
    static Set<String> operations;

    public MicrocodeConverter() {
        microcodeConverter = this;
    }

    public List<String> parse(List<String> lines) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            this.data = new HashMap<Integer, MicrocodeData>();
            this.allLines = new LinkedList<Line>();
            List<MicrocodeData> microcode = this.parseLines(lines);
            int i = 0;
            for (MicrocodeData code : microcode) {
                this.data.put(i++, code);
                if (code != null && code.status == 0) {
                    result.add(code.microcode);
                    continue;
                }
                result.add(MicrocodeData.EMPTYCODE);
            }
        }
        catch (Exception e) {
            Log.errorLog(e, "Error when parsing");
        }
        return result;
    }

    public List<MicrocodeData> parseLines(List<String> lines) {
        char[] code;
        List list;
        MicrocodeData mData;
        Object errorMsg;
        ArrayList<MicrocodeData> result = new ArrayList<MicrocodeData>();
        int i = 0;
        while (i < 1 << Parameters.uprSignalBranchSize) {
            result.add(null);
            ++i;
        }
        String comment = "";
        HashMap<String, LinkedList<MicrocodeData>> connectedLabels = new HashMap<String, LinkedList<MicrocodeData>>();
        HashMap<String, MicrocodeData> allLabels = new HashMap<String, MicrocodeData>();
        int i2 = 0;
        int index = 0;
        for (String line : lines) {
            String lable2;
            MicrocodeData data = this.parseLine(line);
            List<String> lables = data.labels;
            if (lables != null) {
                for (String lable2 : lables) {
                    if (allLabels.containsKey(lable2)) {
                        errorMsg = "Multiple deffinition of label: " + lable2 + " [" + ((MicrocodeData)allLabels.get((Object)lable2)).originalLine + "] [" + data.originalLine + "]";
                        this.setError(data, (String)errorMsg);
                    }
                    allLabels.put(lable2, data);
                }
            }
            if ((lable2 = data.branchLabel) != null && !lable2.equals("")) {
                LinkedList<MicrocodeData> list2 = (LinkedList<MicrocodeData>)connectedLabels.get(lable2);
                if (list2 == null) {
                    list2 = new LinkedList<MicrocodeData>();
                    connectedLabels.put(lable2, list2);
                }
                list2.add(data);
            }
            if (data.comment.equals("")) {
                data.comment = comment;
            } else {
                comment = data.comment;
            }
            switch (data.status) {
                case 0: {
                    if (data.address < 0) {
                        data.address = index++;
                    } else {
                        index = data.address + 1;
                    }
                    MicrocodeData r = (MicrocodeData)result.get(data.address);
                    if (r != null) {
                        errorMsg = "Multiple init of line: " + i2 + " [" + r.originalLine + "] [" + data.originalLine + "]";
                        this.setError(data, (String)errorMsg);
                    }
                    result.set(data.address, data);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    errorMsg = "Invalid data in line " + i2 + " : " + line;
                    this.setError(data, (String)errorMsg);
                }
            }
            Line l = new Line(i2, line, data);
            this.allLines.add(l);
            ++i2;
        }
        comment = "";
        int j = 0;
        while (j < result.size()) {
            MicrocodeData r = (MicrocodeData)result.get(j);
            if (r == null) {
                r = new MicrocodeData();
                r.comment = comment;
                r.address = j;
                result.set(j, r);
            } else {
                comment = r.comment;
            }
            ++j;
        }
        for (String label : connectedLabels.keySet()) {
            mData = (MicrocodeData)allLabels.get(label);
            if (mData != null) {
                int address = mData.address;
                list = (List)connectedLabels.get(label);
                for (Object m : list) {
                    code = ((MicrocodeData)m).microcode.toCharArray();
                    this.packBranchAddress(code, address);
                    ((MicrocodeData)m).microcode = new String(code);
                }
                continue;
            }
            List list3 = (List)connectedLabels.get(label);
            for (MicrocodeData m : list3) {
                errorMsg = "Missing lable [" + label + "] in line: " + m.originalLine;
                this.setError(m, (String)errorMsg);
            }
        }
        for (String label : allLabels.keySet()) {
            mData = (MicrocodeData)allLabels.get(label);
            int address = mData.address;
            list = (List)connectedLabels.get(label);
            if (list == null) continue;
            for (Object m : list) {
                code = ((MicrocodeData)m).microcode.toCharArray();
                this.packBranchAddress(code, address);
                ((MicrocodeData)m).microcode = new String(code);
            }
        }
        return result;
    }

    public MicrocodeData parseLine(String line) {
        MicrocodeData result = new MicrocodeData();
        result.originalLine = line;
        int branchCnt = 0;
        char[] code = result.microcode.toCharArray();
        try {
            String[] args;
            result.comment = this.extractComment(line);
            line = this.prepareLine(line);
            String microcodeAdr = this.extractAdderess(line);
            result.labels = this.extractLabels(line);
            String[] stringArray = args = this.extractOperands(line);
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (this.isCode(arg)) {
                    this.packCode(code, arg);
                    result.status = 0;
                    result.address = !microcodeAdr.equals("") ? Integer.parseInt(microcodeAdr.substring(4, microcodeAdr.length()), 16) : -1;
                } else if (this.isConditionsBranch(arg) || this.isUnonditionsBranch(arg)) {
                    if (++branchCnt != 1) {
                        String errorMsg = "Multiple branches in line: " + result.originalLine;
                        this.setError(result, errorMsg);
                    }
                    this.validateBranch(arg, result);
                    int branchCode = this.extractBranchCode(arg);
                    this.packBranchCode(code, branchCode);
                    int branchAdr = this.extractBranchAdr(arg);
                    if (branchAdr >= 0) {
                        this.packBranchAddress(code, branchAdr);
                    } else {
                        result.branchLabel = this.extractBranchLabel(arg);
                    }
                    result.status = 0;
                    result.address = !microcodeAdr.equals("") ? Integer.parseInt(microcodeAdr.substring(4, microcodeAdr.length()), 16) : -1;
                } else if (this.isAddressBranch(arg) || this.isOperationBranch(arg)) {
                    if (++branchCnt != 1) {
                        String errorMsg = "Multiple branches in line: " + result.originalLine;
                        this.setError(result, errorMsg);
                    }
                    int branchCode = this.extractBranchCode(arg);
                    this.packBranchCode(code, branchCode);
                    result.status = 0;
                    result.address = !microcodeAdr.equals("") ? Integer.parseInt(microcodeAdr.substring(4, microcodeAdr.length()), 16) : -1;
                } else {
                    String errorMsg = "Incorrect argument \"" + arg + "\" in line: " + result.originalLine;
                    this.setError(result, errorMsg);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            String errorMsg = "Error in line " + result.originalLine;
            this.setError(result, e, errorMsg);
        }
        result.microcode = new String(code);
        return result;
    }

    protected void setError(MicrocodeData result, String errorMsg) {
        result.addError(errorMsg);
        Log.errorLog(errorMsg);
        result.status = 2;
    }

    protected void setError(MicrocodeData result, Exception e, String errorMsg) {
        result.addError(errorMsg);
        Log.errorLog(e, errorMsg);
        result.status = 2;
    }

    private void validateBranch(String arg, MicrocodeData data) {
        if (arg == null || arg.equals("")) {
            return;
        }
        String[] args = arg.split(" ");
        if (args.length == 7) {
            String errorMsg;
            if (!args[0].equalsIgnoreCase(UNCONDS)) {
                errorMsg = "\"br\" is missing in line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
            if (!args[1].equalsIgnoreCase("(")) {
                errorMsg = "\"(\" is missing after \"br\" in line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
            if (!args[2].equalsIgnoreCase("if")) {
                errorMsg = "\"if\" is missing after \"br (\" in line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
            if (!args[4].equalsIgnoreCase("then")) {
                errorMsg = "\"then\" is missing line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
            if (!args[6].equalsIgnoreCase(")")) {
                errorMsg = "\")\" is missing in line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
        } else if (args.length == 2) {
            if (!args[0].equalsIgnoreCase(UNCONDS)) {
                String errorMsg = "\"br\" is missing in line:" + data.originalLine;
                this.setError(data, errorMsg);
            }
        } else {
            String errorMsg = "Expecting branch format \"br (if condition then label)\" or \"br label\" in line:" + data.originalLine;
            this.setError(data, errorMsg);
        }
    }

    protected void packCode(char[] code, String arg) {
        int position = this.getPosition(arg);
        int nibl = position / 4;
        int val = position % 4;
        char c = code[nibl];
        int d = Integer.parseInt("" + c, 16);
        code[nibl] = c = Integer.toHexString(d |= 1 << 3 - val).charAt(0);
    }

    protected void packBranchCode(char[] code, int branchCode) {
        String bCode = "0" + Integer.toHexString(branchCode);
        bCode = bCode.substring(bCode.length() - 2, bCode.length());
        char[] cCode = bCode.toCharArray();
        int i = 0;
        while (i < Parameters.uprSignalUslovSize / 4) {
            code[i + Parameters.oprSignalSize / 4] = i < cCode.length ? cCode[i] : 48;
            ++i;
        }
    }

    protected void packBranchAddress(char[] code, int branchAdr) {
        String bAdr = "0" + Integer.toHexString(branchAdr);
        bAdr = bAdr.substring(bAdr.length() - 2, bAdr.length());
        char[] cAdr = bAdr.toCharArray();
        int i = 0;
        while (i < Parameters.uprSignalBranchSize / 4) {
            code[i + (Parameters.oprSignalSize + Parameters.uprSignalUslovSize) / 4] = i < cAdr.length ? cAdr[i] : 48;
            ++i;
        }
    }

    private String[] extractOperands(String line) {
        if (line == null || line.equals("")) {
            return new String[0];
        }
        line = this.skipMadrAndLabels(line);
        String[] args = line.split(",");
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].trim();
            ++i;
        }
        return args;
    }

    private String skipMadrAndLabels(String line) {
        String[] splits = line.split(" ");
        int i = 0;
        while (i < splits.length) {
            String opr = splits[i];
            if (!this.isMadrAddress(opr) && !this.isLabele(opr)) break;
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        while (i < splits.length) {
            String opr = splits[i];
            sb = sb.append(opr).append(" ");
            ++i;
        }
        return sb.toString();
    }

    private List<String> extractLabels(String line) {
        LinkedList<String> result = null;
        String[] elements = line.split(" ");
        int start = 0;
        if (elements.length > 0 && this.isMadrAddress(elements[0])) {
            start = 1;
        }
        int i = start;
        while (i < elements.length) {
            if (!this.isLabele(elements[i])) break;
            if (result == null) {
                result = new LinkedList<String>();
            }
            result.add(elements[i].substring(0, elements[i].length() - 1));
            ++i;
        }
        return result;
    }

    private boolean isLabele(String element) {
        return element.endsWith(":");
    }

    private boolean isMadrAddress(String line) {
        boolean result = false;
        if (line != null && !line.equals("")) {
            int i = line.indexOf(32);
            String r = line;
            if (i >= 0) {
                r = line.substring(0, i);
            }
            if (!(r = r.trim()).endsWith(":") && r.startsWith("madr")) {
                String s = r.substring(4, r.length());
                try {
                    Integer.parseInt(s, 16);
                    result = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String extractAdderess(String line) {
        int i;
        String result = "";
        if (line != null && !line.equals("") && (i = line.indexOf(32)) >= 0) {
            result = line.substring(0, i);
            if ((result = result.trim()).endsWith(":") || !result.startsWith("madr")) {
                result = "";
            } else {
                String s = result.substring(4, result.length());
                try {
                    Integer.parseInt(s, 16);
                }
                catch (Exception e) {
                    result = "";
                }
            }
        }
        return result;
    }

    protected String extractComment(String operation) {
        if ((operation = operation.trim()).startsWith("!")) {
            return operation;
        }
        return "";
    }

    protected String prepareLine(String operation) {
        operation = operation.toLowerCase();
        operation = operation.replace("(", " ( ");
        operation = operation.replace(")", " ) ");
        operation = operation.replaceAll("( )+", " ");
        int index = (operation = operation.replace("if !", "if #")).indexOf(33);
        if (index >= 0) {
            operation = operation.substring(0, index);
        }
        if ((index = operation.indexOf(59)) > 0) {
            operation = operation.substring(0, index);
        }
        operation = operation.replace('\t', ' ');
        operation = operation.replaceAll("( )+:", ": ");
        operation = operation.replaceAll("( )+", " ");
        operation = operation.trim();
        return operation;
    }

    private int extractBranchAdr(String arg) {
        int result = -1;
        try {
            arg = arg.replace('(', ' ');
            arg = arg.replace(')', ' ');
            int madrIndex = arg.indexOf(" madr");
            if (madrIndex >= 0) {
                String adr = arg.substring(madrIndex + " madr".length(), arg.length());
                adr = adr.trim();
                String[] adrs = adr.split(" ");
                result = Integer.parseInt(adrs[0], 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String extractBranchLabel(String arg) {
        String result = "";
        try {
            String tmp = arg;
            int index = tmp.indexOf(41);
            if (index > 0) {
                tmp = tmp.substring(0, index);
            }
            tmp = tmp.trim();
            String[] data = tmp.split(" ");
            result = data[data.length - 1];
            result = result.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private int extractBranchCode(String arg) {
        int result = 1;
        try {
            if (this.isConditionsBranch(arg)) {
                String operation = arg.substring(arg.indexOf("if ") + "if ".length(), arg.length());
                operation = operation.substring(0, operation.indexOf(32));
                if (branches.containsKey(operation = operation.trim())) {
                    result = branches.get(operation);
                } else {
                    if (operation.contains(".")) {
                        String complement = "";
                        if (operation.contains("#")) {
                            complement = "#";
                        }
                        String[] data = operation.split("\\.");
                        operation = data[data.length - 1];
                        operation = String.valueOf(complement) + operation.trim();
                    }
                    if (branches.containsKey(operation)) {
                        result = branches.get(operation);
                    } else {
                        this.noOperationMsg(arg, operation);
                    }
                }
            } else if (this.isAddressBranch(arg)) {
                result = BRADR;
            } else if (this.isOperationBranch(arg)) {
                result = BROPR;
            } else if (this.isUnonditionsBranch(arg)) {
                result = UNCOND;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.errorLog("Incorrect branch code \"" + arg + "\"");
            throw new RuntimeException(arg);
        }
        return result;
    }

    public void noOperationMsg(String arg, String operation) {
        String msg = "Branch " + operation + " was not defined at control unit decoder (CONTRODC)";
        if (branches.containsKey("#" + operation)) {
            msg = String.valueOf(msg) + "; but #" + operation + " was";
        } else if (operation.contains("#")) {
            String opr = operation.replace("#", "");
            if (branches.containsKey(opr = opr.trim())) {
                msg = String.valueOf(msg) + "; but " + opr + " was";
            }
        }
        arg = String.valueOf(arg) + "; " + msg;
        Log.errorLog(arg);
    }

    private boolean isConditionsBranch(String arg) {
        return arg.contains("br ") && arg.indexOf("if ") >= 0;
    }

    private boolean isUnonditionsBranch(String arg) {
        return arg.contains("br ") && arg.indexOf("if ") < 0;
    }

    private boolean isAddressBranch(String arg) {
        return arg.contains(BRADRS);
    }

    private boolean isOperationBranch(String arg) {
        return arg.contains(BROPRS);
    }

    private int getPosition(String arg) {
        Integer i = codesFields.get(arg);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private String getCode(Integer arg) {
        String result = fieldCodes.get(arg);
        return result;
    }

    private String getCondition(Integer arg) {
        String result = conditionCodes.get(arg);
        return result;
    }

    private boolean isCode(String arg) {
        return operations.contains(arg);
    }

    public List<String> fromMicrocode(List<MicrocodeData> microcode) {
        LinkedList<String> result = new LinkedList<String>();
        for (MicrocodeData code : microcode) {
            String operation = this.fromMicrocode(code);
            result.add(operation);
        }
        return result;
    }

    public String fromMicrocode(MicrocodeData microcode) {
        String result = "";
        String adr = this.toAddress(microcode.address);
        result = String.valueOf(result) + adr + " ";
        int num = 0;
        int i = 0;
        while (i < Parameters.oprSignalSize / 4) {
            char c = microcode.microcode.charAt(i);
            int posi = Integer.parseInt("" + c, 16);
            int j = 0;
            while (j < 4) {
                int index;
                String opr;
                if ((posi & 1) == 1 && (opr = this.getCode(index = i * 4 + 3 - j)) != null && !opr.equals("")) {
                    if (num != 0) {
                        result = String.valueOf(result) + ", ";
                    }
                    result = String.valueOf(result) + opr;
                    ++num;
                }
                posi >>= 1;
                ++j;
            }
            ++i;
        }
        String branchCodeString = microcode.microcode.substring(Parameters.oprSignalSize / 4, 2 + Parameters.oprSignalSize / 4);
        int branchCode = Integer.parseInt(branchCodeString, 16);
        if (branchCode == 1) {
            String adrString = this.toAddress(microcode.microcode.substring((Parameters.oprSignalSize + Parameters.uprSignalUslovSize) / 4, 2 + (Parameters.oprSignalSize + Parameters.uprSignalUslovSize) / 4));
            if (num != 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "br " + adrString;
        } else if (branchCode == BRADR) {
            if (num != 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + BRADRS;
        } else if (branchCode == BROPR) {
            if (num != 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + BROPRS;
        } else {
            String condition = this.getCondition(branchCode);
            if (condition != null && !condition.equals("")) {
                condition = condition.replace('#', '!');
                String adrString = this.toAddress(microcode.microcode.substring((Parameters.oprSignalSize + Parameters.uprSignalUslovSize) / 4, 2 + (Parameters.oprSignalSize + Parameters.uprSignalUslovSize) / 4));
                if (num != 0) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + "br (if " + condition + " then " + adrString + ")";
            }
        }
        result = String.valueOf(result) + ";";
        return result;
    }

    public String toAddress(String adr) {
        if (adr == null || adr.equals("")) {
            Log.errorLog("Not a valid address \"" + adr + "\"");
            throw new RuntimeException("Not a valid address");
        }
        String result = adr;
        if (result.length() == 1) {
            result = "0" + result;
        }
        result = "madr" + result.toUpperCase();
        return result;
    }

    public String toAddress(int adr) {
        return this.toAddress(Integer.toHexString(adr));
    }

    static void init() {
        String[] lin;
        codesFields = new HashMap<String, Integer>();
        String[][] stringArray = Parameters.controlUnitOperationSignals;
        int n = Parameters.controlUnitOperationSignals.length;
        int n2 = 0;
        while (n2 < n) {
            lin = stringArray[n2];
            codesFields.put(lin[0].toLowerCase(), Integer.parseInt(lin[1]));
            ++n2;
        }
        fieldCodes = new HashMap<Integer, String>();
        stringArray = Parameters.controlUnitOperationSignals;
        n = Parameters.controlUnitOperationSignals.length;
        n2 = 0;
        while (n2 < n) {
            lin = stringArray[n2];
            fieldCodes.put(Integer.parseInt(lin[1]), lin[0]);
            ++n2;
        }
        operations = codesFields.keySet();
        branches = new HashMap<String, Integer>();
        stringArray = Parameters.controlUnitDecoder;
        n = Parameters.controlUnitDecoder.length;
        n2 = 0;
        while (n2 < n) {
            lin = stringArray[n2];
            String opr = lin[1];
            if (!opr.equals("")) {
                String br = lin[2];
                br = opr.contains(".") ? String.valueOf(br) + opr.substring(opr.indexOf(".") + 1, opr.length()) : String.valueOf(br) + opr;
                br = br.toLowerCase();
                branches.put(br, Integer.parseInt(lin[0]));
            }
            ++n2;
        }
        conditionCodes = new HashMap<Integer, String>();
        stringArray = Parameters.controlUnitOperationSignals;
        n = Parameters.controlUnitOperationSignals.length;
        n2 = 0;
        while (n2 < n) {
            lin = stringArray[n2];
            conditionCodes.put(Integer.parseInt(lin[1]), lin[0].toLowerCase());
            ++n2;
        }
    }

    public static void init(String[][] init) {
        MicrocodeConverter.init();
        MicrocodeConverter.loadBranchCodes(init);
        MicrocodeConverter.loadBranches(init);
        MicrocodeData.init();
    }

    public static void loadBranchCodes(String[][] init) {
        int i = 0;
        while (i < init.length) {
            String[] data = init[i];
            int index = Integer.parseInt(data[0]);
            if (data.length > 3) {
                String name = data[3];
                if (NOJUMPS.equals(name)) {
                    NOJUMP = index;
                }
                if (UNCONDS.equals(name)) {
                    UNCOND = index;
                }
                if (BRADRS.equals(name)) {
                    BRADR = index;
                }
                if (BROPRS.equals(name)) {
                    BROPR = index;
                }
            }
            ++i;
        }
    }

    public static void loadBranches(String[][] init) {
        int i = 0;
        while (i < init.length) {
            String[] data = init[i];
            int index = Integer.parseInt(data[0]);
            String name = data[1].toLowerCase().trim();
            int poslition = name.indexOf(46);
            if (poslition > 0) {
                name = name.substring(poslition + 1);
            }
            String cmp = data[2].toLowerCase().trim();
            branches.put(String.valueOf(cmp) + name, index);
            conditionCodes.put(index, String.valueOf(cmp) + name);
            ++i;
        }
    }

    public static void main1(String[] args) {
        MicrocodeConverter c = new MicrocodeConverter();
        Parameters.init();
        MicrocodeConverter.loadBranches(Parameters.controlUnitDecoder);
        c.parseIn("./microProgram-1.txt", "./o1.txt");
        c.parseOut("./microkod.txt", "./o2.txt");
    }

    private List<MicrocodeData> toMicrocodeFromBin(List<String> lines) {
        LinkedList<MicrocodeData> result = new LinkedList<MicrocodeData>();
        int i = 0;
        for (String line : lines) {
            if (line == null || line.equals("")) continue;
            int com = (line = line.trim()).indexOf(32);
            if (com > 0) {
                line = line.substring(0, com);
            }
            if ((com = line.indexOf(59)) > 0) {
                line = line.substring(0, com);
            }
            if ((com = line.indexOf(9)) > 0) {
                line = line.substring(0, com);
            }
            MicrocodeData code = new MicrocodeData();
            code.address = i++;
            code.microcode = line;
            code.status = 0;
            code.originalLine = line;
            result.add(code);
        }
        return result;
    }

    public void parseIn(String inFile, String outFile) {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            LinkedList<String> lines = new LinkedList<String>();
            while ((s = in.readLine()) != null) {
                lines.add(s);
            }
            in.close();
            List<MicrocodeData> microcode = this.parseLines(lines);
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            for (MicrocodeData code : microcode) {
                if (code != null && code.status == 0) {
                    out.println(code.microcode);
                    continue;
                }
                out.println(MicrocodeData.EMPTYCODE);
            }
            out.close();
        }
        catch (Exception e) {
            Log.errorLog(e, "In file " + inFile + ", out file" + outFile);
        }
    }

    public void parseOut(String inFile, String outFile) {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            LinkedList<String> lines = new LinkedList<String>();
            while ((s = in.readLine()) != null) {
                lines.add(s);
            }
            in.close();
            List<MicrocodeData> microcode = this.toMicrocodeFromBin(lines);
            List<String> data = this.fromMicrocode(microcode);
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            for (String code : data) {
                if (code != null) {
                    out.println(code);
                    continue;
                }
                out.println("!-----!");
            }
            out.close();
        }
        catch (Exception e) {
            Log.errorLog(e, "Parse out" + inFile + ", out file" + outFile);
        }
    }

    public String getSteps(int step) {
        MicrocodeData element = this.data.get(step);
        if (element != null) {
            return this.fromMicrocode(element);
        }
        return "";
    }

    public String getComment(int step) {
        MicrocodeData element = this.data.get(step);
        if (element != null) {
            return element.comment;
        }
        return "";
    }

    public String getConverted() {
        StringBuilder sb = new StringBuilder();
        for (Line line : this.allLines) {
            sb = line.microcode.status == 0 ? sb.append(this.fromMicrocode(line.microcode)).append("\n") : sb.append(line.line).append("\n");
        }
        return sb.toString();
    }

    public String getOriginal() {
        StringBuilder sb = new StringBuilder();
        for (Line line : this.allLines) {
            sb = sb.append(line.line).append("\n");
        }
        return sb.toString();
    }

    public List<Line> getLines() {
        return this.allLines;
    }

    public static class Line {
        public int rb;
        public String line;
        public MicrocodeData microcode;

        public Line(int rb, String line, MicrocodeData microcode) {
            this.rb = rb;
            this.line = line;
            this.microcode = microcode;
        }
    }

    public static class MicrocodeData {
        public static final int OK = 0;
        public static final int COMMENT = 1;
        public static final int ERR = 2;
        public static String EMPTYCODE = "0000000000000000000000000000";
        public String microcode = EMPTYCODE;
        public int address = 0;
        public int status = 1;
        public String comment = "";
        public String originalLine = "";
        List<String> labels = null;
        String branchLabel = "";
        List<String> errors;
        List<String> warnings;

        public static void init() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < (Parameters.oprSignalSize + Parameters.uprSignalUslovSize + Parameters.uprSignalBranchSize) / 4) {
                sb = sb.append("0");
                ++i;
            }
            EMPTYCODE = sb.toString();
            char[] code = EMPTYCODE.toCharArray();
            int branchCode = NOJUMP;
            String bCode = "0" + Integer.toHexString(branchCode);
            bCode = bCode.substring(bCode.length() - Parameters.uprSignalBranchSize / 4, bCode.length());
            char[] cCode = bCode.toCharArray();
            int i2 = 0;
            while (i2 < Parameters.uprSignalBranchSize / 4) {
                code[i2 + Parameters.oprSignalSize / 4] = cCode[i2];
                ++i2;
            }
            EMPTYCODE = new String(code);
        }

        public void addError(String error) {
            if (error == null || error.equals("")) {
                return;
            }
            if (this.errors == null) {
                this.errors = new LinkedList<String>();
            }
            this.errors.add(error);
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public void addWarning(String warning) {
            if (warning == null || warning.equals("")) {
                return;
            }
            if (this.warnings == null) {
                this.warnings = new LinkedList<String>();
            }
            this.warnings.add(warning);
        }

        public List<String> getWarmings() {
            return this.warnings;
        }
    }
}

