/*
 * Decompiled with CFR 0.152.
 */
package util;

import javax.swing.JTextArea;
import main.MessageDialog;

public class Log {
    private static JTextArea errorArea;
    private static JTextArea logArea;
    private static StringBuffer buffer;

    static {
        buffer = new StringBuffer();
    }

    public static void reset() {
        buffer = new StringBuffer();
        if (errorArea != null) {
            errorArea.setText(null);
        }
        if (logArea != null) {
            logArea.setText(null);
        }
    }

    public static void setLogAreas(JTextArea logArea, JTextArea errorArea) {
        Log.logArea = logArea;
        Log.errorArea = errorArea;
    }

    public static String getLog() {
        return buffer.toString();
    }

    public static void log(String data) {
        Log.log(data, logArea, false);
    }

    public static void errorDialog(String data) {
        Log.log(data, errorArea, true);
    }

    public static void errorLog(String data) {
        Log.log(data, errorArea, false);
    }

    public static void errorLog(Exception data, String line) {
        Log.log(String.valueOf(line) + ", " + data.toString(), errorArea, false);
    }

    private static void log(String data, JTextArea area, boolean dialog) {
        try {
            String[] lines;
            if (area != null) {
                area.append(String.valueOf(data.trim()) + "\n");
            } else {
                System.out.println(data);
                buffer.append(data.trim()).append("\n");
            }
            if (dialog && (lines = data.split("\\n")).length > 0 && lines[0].contains(":")) {
                String msg = lines[0].substring(lines[0].indexOf(":") + 1);
                MessageDialog.sendMessage(msg.trim(), "Error");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

