/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.Drawable;
import gui.GuiComponent;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class SignaliOperacioneJedinice
extends AbstractSchema {
    public static final String DNAME = "Oper1";
    private static final int MAXCOLUM = 5;

    public SignaliOperacioneJedinice() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("SignaliOperacioneJedinice.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Oper1.png");
        int num = Parameters.controlUnitOperationSignals.length;
        int rowMax = num / 5;
        if (rowMax * 5 < num) {
            ++rowMax;
        }
        int i = 0;
        while (i < num) {
            String[] opr = Parameters.controlUnitOperationSignals[i];
            int colum = i / rowMax;
            int row = i % rowMax;
            int x = 40 + colum * 150;
            int y = 65 + row * 25;
            String name = opr[0];
            int rb = Integer.parseInt(opr[1]);
            Pin pin = NameConnector.getPin("CW" + rb);
            List<Drawable> element = this.creteGui(pin, name, rb, x, y);
            for (Drawable d : element) {
                this.gui.addDrawable(d);
            }
            ++i;
        }
    }

    private List<Drawable> creteGui(Pin pin, String name, int rb, int x, int y) {
        LinkedList<Drawable> result = new LinkedList<Drawable>();
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(x, y));
        points.add(new Point(x + 13, y));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, pin);
        result.add(line);
        GuiTextLabel nameLabel = new GuiTextLabel(x + 22, y, name, 14);
        result.add(nameLabel);
        GuiTextLabel cwLabel = new GuiTextLabel(x - 35, y, "CW", 14);
        result.add(cwLabel);
        GuiTextLabel cwNoLabel = new GuiTextLabel(x - 12, y + 2, "" + rb, 12);
        result.add(cwNoLabel);
        return result;
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        String[][] stringArray = Parameters.controlUnitOperationSignals;
        int n = Parameters.controlUnitOperationSignals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] opr = stringArray[n2];
            String name = opr[0];
            int rb = Integer.parseInt(opr[1]);
            Pin pin = NameConnector.getPin("CW" + rb);
            result.add(new Element<String, Pin>(name, pin));
            ++n2;
        }
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        return result;
    }
}

