/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.BoolsToInt;
import logic.components.CLK;
import logic.components.KMADR;
import logic.components.KMOPR;
import logic.components.MP;
import logic.components.MicroMEM;
import logic.components.NOT;
import logic.components.OR;
import logic.components.REG;
import shemes.AbstractSchema;
import shemes.components.SignaliOperacioneJedinice;
import shemes.components.SignaliUpravljackeJedinice;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class ProcesorUpravljacka
extends AbstractSchema {
    public static final String DNAME = "Counter";
    private KMOPR KMOPR1;
    private KMADR KMADR1;
    private MP MP1;
    private REG mPC;
    private OR ORmPC;
    private NOT NOTmPC;
    private MicroMEM mMEM;
    private int oprSignalSize;
    private int uprSignalUslovSize;
    private int uprSignalBranchSize;
    private BoolsToInt zeroes;
    private BoolsToInt mCWbits_BranchAdr;
    static String[] candidates = new String[]{"Exec2.START", "Bus1.hack", "Bus1.fcCPU", "Fetch3.gropr", "Fetch3.L1", "Fetch2.regdir", "Fetch2.NOP", "Exec4.brpom", "Intr1.prekid"};

    public ProcesorUpravljacka() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("ProcesorUpravljacka.NAME");
        this.oprSignalSize = Parameters.oprSignalSize;
        this.uprSignalUslovSize = Parameters.uprSignalUslovSize;
        this.uprSignalBranchSize = Parameters.uprSignalBranchSize;
        NameConnector.addSchema(this.componentName, this);
        this.addScheme(new SignaliOperacioneJedinice());
        this.addScheme(new SignaliUpravljackeJedinice());
    }

    @Override
    public void initComponent() {
        int[] kmoprCodeAddresses = new int[Parameters.counterCodeAddresses.length];
        int i = 0;
        while (i < kmoprCodeAddresses.length) {
            String val = Parameters.counterCodeAddresses[i][1];
            val = val.toLowerCase();
            if ((val = val.trim()).endsWith("h")) {
                val = val.substring(0, val.length() - 1);
                kmoprCodeAddresses[i] = Integer.parseInt(val, 16);
            } else {
                kmoprCodeAddresses[i] = Integer.parseInt(val);
            }
            ++i;
        }
        this.KMOPR1 = new KMOPR(kmoprCodeAddresses);
        this.KMOPR1.getOutPin(0).setNumOfLines(this.uprSignalBranchSize);
        int[] kmoprAdrModesAddresses = new int[Parameters.counterAdrModesAddresses.length];
        int i2 = 0;
        while (i2 < kmoprAdrModesAddresses.length) {
            String val = Parameters.counterAdrModesAddresses[i2][1];
            if (val.endsWith("h")) {
                val = val.substring(0, val.length() - 1);
                kmoprAdrModesAddresses[i2] = Integer.parseInt(val, 16);
            } else {
                kmoprAdrModesAddresses[i2] = Integer.parseInt(val);
            }
            ++i2;
        }
        this.KMADR1 = new KMADR(kmoprAdrModesAddresses);
        this.KMADR1.getOutPin(0).setNumOfLines(this.uprSignalBranchSize);
        this.MP1 = new MP(4);
        this.MP1.getOutPin(0).setNumOfLines(this.uprSignalBranchSize);
        this.MP1.getOutPin(0).setIsInt();
        this.mPC = new REG(1, "mPC");
        this.mPC.getOutPin(0).setNumOfLines(this.uprSignalBranchSize);
        this.mPC.getOutPin(0).setIsInt();
        this.ORmPC = new OR(4);
        this.NOTmPC = new NOT();
        this.mMEM = new MicroMEM(this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize, 1 << this.uprSignalBranchSize, Parameters.microcodeLines);
        this.zeroes = new BoolsToInt(this.uprSignalBranchSize);
        this.mCWbits_BranchAdr = new BoolsToInt(this.uprSignalBranchSize);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        Pin pin;
        String name;
        int i = 0;
        while (i < Parameters.counterCodeAddresses.length) {
            name = Parameters.counterCodeAddresses[i][0];
            pin = NameConnector.getPin(name);
            this.KMOPR1.setInPin(i, pin);
            ++i;
        }
        i = 0;
        while (i < Parameters.counterAdrModesAddresses.length) {
            name = Parameters.counterAdrModesAddresses[i][0];
            pin = NameConnector.getPin(name);
            this.KMADR1.setInPin(i, pin);
            ++i;
        }
        this.MP1.setInPin(0, this.mCWbits_BranchAdr.getOutPin(0));
        this.MP1.setInPin(1, this.KMADR1.getOutPin(0));
        this.MP1.setInPin(2, this.KMOPR1.getOutPin(0));
        Pin p = new Pin(0, 1, "");
        p.setIsInt();
        this.MP1.setInPin(3, p);
        this.MP1.setCtrl(0, NameConnector.getPin("Uprav1.bradr"));
        this.MP1.setCtrl(1, NameConnector.getPin("Uprav1.bropr"));
        this.ORmPC.setInPin(0, NameConnector.getPin("Uprav1.bradr"));
        this.ORmPC.setInPin(1, NameConnector.getPin("Uprav1.bropr"));
        this.ORmPC.setInPin(2, NameConnector.getPin("Uprav1.branch"));
        this.ORmPC.setInPin(3, NameConnector.getPin("Uprav1.br"));
        this.NOTmPC.setInPin(0, this.ORmPC.getOutPin(0));
        this.mPC.setInPin(0, this.MP1.getOutPin(0));
        this.mPC.setPinLd(this.ORmPC.getOutPin(0));
        this.mPC.setPinInc(this.NOTmPC.getOutPin(0));
        this.mPC.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.mMEM.setInPin(0, this.mPC.getOutPin(0));
        int i2 = 0;
        while (i2 < this.uprSignalBranchSize) {
            this.zeroes.setInPin(i2, new Pin(false, "0"));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.uprSignalBranchSize) {
            this.mCWbits_BranchAdr.setInPin(i2, this.mMEM.getOutPin(111 - i2));
            ++i2;
        }
        super.initConections();
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Counter.png");
        Pin pin = null;
        GuiTextLabel label = null;
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(125, 81));
        points.add(new Point(125, 90));
        sections.add(points);
        pin = this.KMOPR1.getInPin(0);
        GuiPinLine line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(125, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 81));
        points.add(new Point(140, 90));
        sections.add(points);
        pin = this.KMOPR1.getInPin(1);
        line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(140, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(219, 81));
        points.add(new Point(219, 90));
        sections.add(points);
        pin = this.KMOPR1.getInPin(this.KMOPR1.getInPins().length - 2);
        line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(219, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(276, 81));
        points.add(new Point(276, 90));
        sections.add(points);
        pin = this.KMADR1.getInPin(0);
        line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(276, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(291, 81));
        points.add(new Point(291, 90));
        sections.add(points);
        pin = this.KMADR1.getInPin(1);
        line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(291, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(370, 81));
        points.add(new Point(370, 90));
        sections.add(points);
        pin = this.KMADR1.getInPin(this.KMADR1.getInPins().length - 1);
        line = new GuiPinLine(sections, pin);
        this.gui.addDrawable(line);
        label = new GuiTextLabel(370, 75, pin.getName(), 13, -1.5707963267948966);
        this.gui.addDrawable(label);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(172, 139));
        points.add(new Point(172, 194));
        sections.add(points);
        line = new GuiPinLine(sections, this.KMOPR1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(323, 139));
        points.add(new Point(323, 166));
        points.add(new Point(202, 166));
        points.add(new Point(202, 194));
        sections.add(points);
        line = new GuiPinLine(sections, this.KMADR1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(142, 183));
        points.add(new Point(142, 194));
        sections.add(points);
        line = new GuiPinLine(sections, this.zeroes.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(360, 487));
        points.add(new Point(360, 505));
        points.add(new Point(477, 505));
        points.add(new Point(477, 175));
        points.add(new Point(233, 175));
        points.add(new Point(233, 194));
        sections.add(points);
        line = new GuiPinLine(sections, new BoolsToInt(this.mMEM, this.oprSignalSize + this.uprSignalUslovSize, this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize - 1, false).getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(262, 203));
        points.add(new Point(255, 203));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bradr"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(262, 222));
        points.add(new Point(255, 222));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bropr"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(187, 232));
        points.add(new Point(187, 269));
        sections.add(points);
        line = new GuiPinLine(sections, this.MP1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(112, 288));
        points.add(new Point(120, 288));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(326, 271));
        points.add(new Point(319, 271));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bradr"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(318, 282));
        points.add(new Point(327, 282));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bropr"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(326, 305));
        points.add(new Point(319, 305));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.branch"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(326, 294));
        points.add(new Point(317, 294));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.br"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(297, 288));
        points.add(new Point(289, 288));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(260, 297));
        points.add(new Point(289, 297));
        points.add(new Point(289, 279));
        points.add(new Point(255, 279));
        sections.add(points);
        line = new GuiPinLine(sections, this.ORmPC.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(187, 307));
        points.add(new Point(187, 345));
        sections.add(points);
        line = new GuiPinLine(sections, this.mPC.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(113, 364));
        points.add(new Point(120, 364));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(422, 428));
        points.add(new Point(415, 428));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(415, 450));
        points.add(new Point(422, 450));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(86, 458));
        points.add(new Point(86, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(225, 458));
        points.add(new Point(225, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(95));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(259, 458));
        points.add(new Point(259, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(96));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(304, 458));
        points.add(new Point(304, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(103));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(338, 458));
        points.add(new Point(338, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(104));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(383, 458));
        points.add(new Point(383, 465));
        sections.add(points);
        line = new GuiPinLine(sections, this.mMEM.getOutPin(111));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(157, 491));
        points.add(new Point(157, 543));
        sections.add(points);
        line = new GuiPinLine(sections, new BoolsToInt(this.mMEM, 0, 31, false).getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(281, 487));
        points.add(new Point(281, 533));
        points.add(new Point(432, 533));
        points.add(new Point(432, 543));
        sections.add(points);
        line = new GuiPinLine(sections, new BoolsToInt(this.mMEM, this.oprSignalSize, this.oprSignalSize + this.uprSignalUslovSize - 1, false).getOutPin(0));
        this.gui.addDrawable(line);
        this.initSignaliUpravljacke(this.gui);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(187, 382));
        points.add(new Point(187, 420));
        sections.add(points);
        line = new GuiPinLine(sections, this.zeroes.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(154, 155, this.KMOPR1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(305, 155, this.KMADR1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(389, 195, this.mCWbits_BranchAdr.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(389, 520, this.mCWbits_BranchAdr.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(160, 250, this.MP1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(160, 320, this.mPC.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(60, 520, new BoolsToInt(this.mMEM, 0, 23, false).getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(102, 520, new BoolsToInt(this.mMEM, 24, 47, false).getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(144, 520, new BoolsToInt(this.mMEM, 48, 71, false).getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(186, 520, new BoolsToInt(this.mMEM, 72, 95, false).getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(255, 520, new BoolsToInt(this.mMEM, 96, 103, false).getOutPin(0)));
        super.initGui();
    }

    public void initSignaliUpravljacke(GuiComponent gui) {
        GuiPinLine line;
        ArrayList<Point> points;
        ArrayList<List<Point>> sections;
        int numOfLines = 11;
        int[][] positions = new int[][]{{346, 550, 356, 550}, {346, 565, 356, 565}, {346, 580, 356, 580}, {346, 610, 356, 610}, {346, 641, 355, 641}, {346, 671, 355, 671}, {518, 550, 508, 550}, {518, 580, 508, 580}, {518, 610, 508, 610}, {518, 641, 508, 641}, {518, 671, 509, 671}};
        List<PinWrapper> signaliUpravljacke = this.extractSignaliUpravljacke(numOfLines);
        int i = 0;
        while (i < numOfLines) {
            PinWrapper pw = signaliUpravljacke.get(i);
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(positions[i][0], positions[i][1]));
            points.add(new Point(positions[i][2], positions[i][3]));
            sections.add(points);
            line = new GuiPinLine(sections, pw.pin);
            gui.addDrawable(line);
            GuiTextLabel label = null;
            label = positions[i][0] > 432 ? new GuiTextLabel(positions[i][0] + 10, positions[i][1] + 7, pw.name, 13, 0) : new GuiTextLabel(positions[i][0] - 10, positions[i][1] + 7, pw.name, 13, 1);
            gui.addDrawable(label);
            ++i;
        }
        sections = new ArrayList<List<Point>>();
        points = new ArrayList<Point>();
        points.add(new Point(387, 693));
        points.add(new Point(387, 678));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bradr"));
        gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(417, 693));
        points.add(new Point(417, 678));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.bropr"));
        gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(447, 692));
        points.add(new Point(447, 678));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.br"));
        gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(477, 678));
        points.add(new Point(477, 693));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Uprav1.branch"));
        gui.addDrawable(line);
        gui.addDrawable(new GuiTextLabel(160, 185, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(190, 185, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(220, 185, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(175, 245, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(175, 320, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(350, 500, "" + this.uprSignalBranchSize, 10));
        gui.addDrawable(new GuiTextLabel(196, 157, this.uprSignalBranchSize - 1 + "..0", 10));
        gui.addDrawable(new GuiTextLabel(347, 157, this.uprSignalBranchSize - 1 + "..0", 10));
        gui.addDrawable(new GuiTextLabel(222, 322, this.uprSignalBranchSize - 1 + "..0", 10));
        gui.addDrawable(new GuiTextLabel(140, 500, "" + this.oprSignalSize, 10));
        gui.addDrawable(new GuiTextLabel(270, 500, "" + this.uprSignalUslovSize, 10));
        gui.addDrawable(new GuiTextLabel(163, 394, "" + (this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize), 10));
        gui.addDrawable(new GuiTextLabel(82, 455, "0", 10));
        gui.addDrawable(new GuiTextLabel(220, 455, "" + (this.oprSignalSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(252, 455, "" + this.oprSignalSize, 10));
        gui.addDrawable(new GuiTextLabel(297, 455, "" + (this.oprSignalSize + this.uprSignalUslovSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(330, 455, "" + (this.oprSignalSize + this.uprSignalUslovSize + 1), 10));
        gui.addDrawable(new GuiTextLabel(377, 455, "" + (this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(93, 480, "0", 10));
        gui.addDrawable(new GuiTextLabel(233, 480, "" + (this.oprSignalSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(263, 480, "" + this.oprSignalSize, 10));
        gui.addDrawable(new GuiTextLabel(308, 480, "" + (this.oprSignalSize + this.uprSignalUslovSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(341, 480, "" + (this.oprSignalSize + this.uprSignalUslovSize + 1), 10));
        gui.addDrawable(new GuiTextLabel(388, 480, "" + (this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize - 1), 10));
        gui.addDrawable(new GuiTextLabel(398, 171, this.oprSignalSize + this.uprSignalUslovSize + "..." + (this.oprSignalSize + this.uprSignalUslovSize + this.uprSignalBranchSize - 1), 10));
    }

    private List<PinWrapper> extractSignaliUpravljacke(int numberOfPins) {
        String[][] lines;
        LinkedList<PinWrapper> result = new LinkedList<PinWrapper>();
        HashSet<String> usedNames = new HashSet<String>();
        HashSet<String> posibleNames = new HashSet<String>();
        LinkedList<String> names = new LinkedList<String>();
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null && !name.equals("")) {
                names.add(name);
            }
            ++n2;
        }
        String[][] stringArray2 = lines = Parameters.controlUnitDecoder;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            String[] line = stringArray2[n];
            String name = line[1];
            if (name != null && !name.equals("")) {
                posibleNames.add(name);
                names.add(name);
            }
            ++n;
        }
        for (String name : names) {
            if (posibleNames.contains(name) && !usedNames.contains(name)) {
                Pin pin = NameConnector.getPin(name);
                PinWrapper pw = new PinWrapper(pin, name);
                result.add(pw);
                usedNames.add(name);
            }
            if (result.size() >= numberOfPins) break;
        }
        if (result.size() < numberOfPins) {
            int i = result.size();
            while (i < numberOfPins) {
                Pin pin = new Pin(false, "0");
                PinWrapper pw = new PinWrapper(pin, "0");
                result.add(pw);
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("KMADR", this.KMADR1.getOutPin(0)));
        result.add(new Element<String, Pin>("KMOPR", this.KMOPR1.getOutPin(0)));
        result.add(new Element<String, Pin>("mPC", this.mPC.getOutPin(0)));
        int i = 0;
        while (i < this.mMEM.getOutPins().length) {
            result.add(new Element<String, Pin>("CW" + i, this.mMEM.getOutPin(i)));
            ++i;
        }
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        Element<String, MicroMEM> element = new Element<String, MicroMEM>("mMem", this.mMEM);
        result.add(element);
        return result;
    }

    public REG mPCREG() {
        return this.mPC;
    }

    public LogicComponent getCW() {
        return this.mMEM;
    }

    static class PinWrapper {
        public Pin pin;
        public String name;

        public PinWrapper() {
            this(null, "");
        }

        public PinWrapper(Pin pin, String name) {
            this.pin = pin;
            this.name = name;
        }
    }
}

