/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.AND;
import logic.components.BoolsToInt;
import logic.components.CLK;
import logic.components.CMP;
import logic.components.NOT;
import logic.components.OR;
import logic.components.REG;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class MemorijaUpravljacka
extends AbstractSchema {
    public static final String DNAME = "Mem2";
    private OR OR1;
    private NOT NOT1;
    private AND AND1;
    private AND AND2;
    private REG MEMACC;
    private REG TIME;
    private CMP CMP1;
    private BoolsToInt zeroes;

    public MemorijaUpravljacka() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("MemorijaUpravljacka.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.OR1 = new OR();
        this.NOT1 = new NOT();
        this.AND1 = new AND();
        this.AND2 = new AND();
        this.MEMACC = new REG(8, "MEMACC");
        this.MEMACC.getOutPin(0).setIsInt();
        this.MEMACC.getOutPin(0).setNumOfLines(8);
        this.MEMACC.initVal(0);
        this.TIME = new REG(1, "TIME");
        this.TIME.getOutPin(0).setIsInt();
        this.TIME.getOutPin(0).setNumOfLines(8);
        this.CMP1 = new CMP(1);
        this.zeroes = new BoolsToInt(8);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.OR1.setInPin(0, NameConnector.getPin("Mem1.rdMEM"));
        this.OR1.setInPin(1, NameConnector.getPin("Mem1.wrMEM"));
        this.NOT1.setInPin(0, NameConnector.getPin("Mem2.fcMEM"));
        this.AND1.setInPin(0, this.OR1.getOutPin(0));
        this.AND1.setInPin(1, this.NOT1.getOutPin(0));
        this.MEMACC.setInPin(0, new Pin(0, 8, ""));
        this.MEMACC.setPinLd(new Pin(false, "0"));
        this.MEMACC.setPinCL(NameConnector.getPin("Mem2.fcMEM"));
        this.MEMACC.setPinInc(this.AND1.getOutPin(0));
        this.MEMACC.setClk((CLK)NameConnector.getComponent("MEMCLK"));
        this.TIME.initVal(Parameters.memdelay);
        this.TIME.setClk((CLK)NameConnector.getComponent("MEMCLK"));
        this.CMP1.setInPin(0, this.MEMACC.getOutPin(0));
        this.CMP1.setInPin(1, this.TIME.getOutPin(0));
        this.CMP1.setE(this.OR1.getOutPin(0));
        this.AND2.setInPin(0, NameConnector.getPin("Mem1.rdMEM"));
        this.AND2.setInPin(1, NameConnector.getPin("Mem2.fcMEM"));
        int i = 0;
        while (i < 8) {
            this.zeroes.setInPin(i, new Pin(false, "0"));
            ++i;
        }
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Mem2.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(94, 46));
        points.add(new Point(109, 46));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Mem1.rdMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(94, 57));
        points.add(new Point(109, 57));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem1.wrMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(130, 51));
        points.add(new Point(158, 51));
        sections.add(points);
        line = new GuiPinLine(sections, this.OR1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(94, 76));
        points.add(new Point(256, 76));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(139, 76));
        points.add(new Point(139, 63));
        points.add(new Point(153, 63));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem2.fcMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(181, 57));
        points.add(new Point(256, 57));
        sections.add(points);
        line = new GuiPinLine(sections, this.AND1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(415, 57));
        points.add(new Point(408, 57));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(332, 29));
        points.add(new Point(332, 48));
        sections.add(points);
        line = new GuiPinLine(sections, this.zeroes.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(408, 76));
        points.add(new Point(415, 76));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Memorija.MEMCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(332, 86));
        points.add(new Point(332, 228));
        points.add(new Point(453, 228));
        sections.add(points);
        line = new GuiPinLine(sections, this.MEMACC.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(604, 56));
        points.add(new Point(597, 56));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(525, 28));
        points.add(new Point(525, 47));
        sections.add(points);
        line = new GuiPinLine(sections, this.zeroes.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(604, 75));
        points.add(new Point(597, 75));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Memorija.MEMCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(525, 85));
        points.add(new Point(525, 133));
        points.add(new Point(402, 133));
        points.add(new Point(402, 192));
        points.add(new Point(453, 192));
        sections.add(points);
        line = new GuiPinLine(sections, this.TIME.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(536, 191));
        points.add(new Point(555, 191));
        sections.add(points);
        line = new GuiPinLine(sections, this.CMP1.getOutPin(1));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(94, 136));
        points.add(new Point(105, 136));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem2.fcMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(94, 148));
        points.add(new Point(105, 148));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem1.rdMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(128, 142));
        points.add(new Point(136, 142));
        sections.add(points);
        line = new GuiPinLine(sections, this.AND2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(494, 255));
        points.add(new Point(494, 275));
        sections.add(points);
        line = new GuiPinLine(sections, this.OR1.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(420, 188, this.TIME.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(420, 224, this.MEMACC.getOutPin(0)));
        this.gui.addDrawable(new GuiTextLabel(522, 22, "" + Parameters.memdelay, 12));
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("fcMEM", this.CMP1.getOutPin(1)));
        result.add(new Element<String, Pin>("MEMout", this.AND2.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        return result;
    }
}

