/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.TSBGui;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import logic.LogicComponent;
import logic.LogicComponentFactory;
import logic.Pin;
import logic.components.BoolsToInt;
import logic.components.CLK;
import logic.components.IntToBools;
import logic.components.IntToInt;
import logic.components.REG;
import logic.components.TSB;
import shemes.AbstractSchema;
import shemes.components.Bus1;
import util.Element;
import util.IndexExtractor;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.ValidationElement;

public class Fetch1
extends AbstractSchema {
    public static final String DNAME = "Fetch1";
    private REG PC;
    private TSB TSBPCout1;
    private TSB TSBPCHout3;
    private TSB TSBPCLout3;
    private TSB TSBIRDAout3;
    private TSB TSBIRJAout2;
    private TSB TSBIRPOMout3;
    private TSB TSBIRBRout3;
    private IntToInt PChigh;
    private IntToInt PClow;
    private IntToInt IBUS1lowINT;
    private IntToBools IBUS1lowBOOLS;
    private REG IR0;
    private REG IR1;
    private REG IR2;
    private REG IR3;
    private BoolsToInt IR0ToINT;
    private BoolsToInt IR1ToINT;
    private BoolsToInt IR2ToINT;
    private BoolsToInt IR3ToINT;
    static String[] okComponents = new String[]{"TRI"};
    static Set<String> supportedComponents = new HashSet<String>();

    static {
        String[] stringArray = okComponents;
        int n = okComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String comp = stringArray[n2];
            supportedComponents.add(comp);
            ++n2;
        }
    }

    public Fetch1() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Fetch1.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.components = new HashMap();
        this.PC = new REG(1, "PC");
        this.PC.getOutPin(0).setIsInt();
        this.PC.getOutPin(0).setNumOfLines(Parameters.sizePC);
        this.PC.initVal(Parameters.valPC);
        this.TSBPCout1 = new TSB("PCout1");
        this.TSBPCout1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.PChigh = new IntToInt(Parameters.sizeIBUS3, Parameters.sizePCH, true, false);
        this.PClow = new IntToInt(Parameters.sizeIBUS3, Parameters.sizePCL, false, false);
        this.TSBPCHout3 = new TSB("PCHout3");
        this.TSBPCHout3.getOutPin(0).setNumOfLines(Parameters.sizePCH);
        this.TSBPCLout3 = new TSB("PCLout3");
        this.TSBPCLout3.getOutPin(0).setNumOfLines(Parameters.sizePCL);
        int dbusSize = Parameters.sizeDBUS;
        this.IBUS1lowINT = new IntToInt(Parameters.sizeIBUS1, dbusSize);
        this.IBUS1lowBOOLS = new IntToBools(dbusSize);
        this.IR0 = new REG(dbusSize, "IR0");
        this.IR1 = new REG(dbusSize, "IR1");
        this.IR2 = new REG(dbusSize, "IR2");
        this.IR3 = new REG(dbusSize, "IR3");
        this.IR0ToINT = new BoolsToInt(dbusSize);
        this.IR1ToINT = new BoolsToInt(dbusSize);
        this.IR2ToINT = new BoolsToInt(dbusSize);
        this.IR3ToINT = new BoolsToInt(dbusSize);
        this.TSBIRDAout3 = this.initTSB("IRAD");
        this.components.put("IRAD", this.TSBIRDAout3);
        this.TSBIRJAout2 = this.initTSB("IRJA");
        this.components.put("IRJA", this.TSBIRJAout2);
        this.TSBIRPOMout3 = this.initTSB("IRPOM");
        this.components.put("IRPOM", this.TSBIRPOMout3);
        this.TSBIRBRout3 = this.initTSB("IRBR");
        this.components.put("IRBR", this.TSBIRBRout3);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.PC.setInPin(0, NameConnector.getPin("Bus1.IBUS2"));
        this.PC.setPinInc(NameConnector.getPin("Oper1.incPC"));
        this.PC.setPinLd(NameConnector.getPin("Oper1.ldPC"));
        this.PC.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBPCout1.setInPin(0, this.PC.getOutPin(0));
        this.TSBPCout1.setE(NameConnector.getPin("Oper1.PCout1"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS1(this.TSBPCout1.getOutPin(0));
        this.PChigh.setInPin(0, this.PC.getOutPin(0));
        this.PClow.setInPin(0, this.PC.getOutPin(0));
        this.TSBPCHout3.setInPin(0, this.PChigh.getOutPin(0));
        this.TSBPCHout3.setE(NameConnector.getPin("Oper1.PCHout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBPCHout3.getOutPin(0));
        this.TSBPCLout3.setInPin(0, this.PClow.getOutPin(0));
        this.TSBPCLout3.setE(NameConnector.getPin("Oper1.PCLout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBPCLout3.getOutPin(0));
        this.IBUS1lowINT.setInPin(0, NameConnector.getPin("Bus1.IBUS1"));
        this.IBUS1lowBOOLS.setInPin(0, this.IBUS1lowINT.getOutPin(0));
        this.IR0.setPinLd(NameConnector.getPin("Oper1.ldIR0"));
        this.IR0.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.IR1.setPinLd(NameConnector.getPin("Oper1.ldIR1"));
        this.IR1.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.IR2.setPinLd(NameConnector.getPin("Oper1.ldIR2"));
        this.IR2.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.IR3.setPinLd(NameConnector.getPin("Oper1.ldIR3"));
        this.IR3.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        int dbusSize = Parameters.sizeDBUS;
        int i = 0;
        while (i < dbusSize) {
            Pin p = this.IBUS1lowBOOLS.getOutPin(i);
            this.IR0.setInPin(i, p);
            this.IR1.setInPin(i, p);
            this.IR2.setInPin(i, p);
            this.IR3.setInPin(i, p);
            ++i;
        }
        i = 0;
        while (i < dbusSize) {
            this.IR0ToINT.setInPin(i, this.IR0.getOutPin(i));
            this.IR1ToINT.setInPin(i, this.IR1.getOutPin(i));
            this.IR2ToINT.setInPin(i, this.IR2.getOutPin(i));
            this.IR3ToINT.setInPin(i, this.IR3.getOutPin(i));
            ++i;
        }
        this.connectTSB("IRAD", this.TSBIRDAout3);
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBIRDAout3.getOutPin(0));
        this.connectTSB("IRJA", this.TSBIRJAout2);
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS2(this.TSBIRJAout2.getOutPin(0));
        this.connectTSB("IRPOM", this.TSBIRPOMout3);
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBIRPOMout3.getOutPin(0));
        this.connectTSB("IRBR", this.TSBIRBRout3);
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBIRBRout3.getOutPin(0));
    }

    private TSB initTSB(String component) {
        String[] data = new String[]{};
        int i = 0;
        while (i < Parameters.fetch1Conections.length) {
            data = Parameters.fetch1Conections[i];
            if (data[1].equals(component)) break;
            ++i;
        }
        TSB result = (TSB)LogicComponentFactory.loadComponent(data, supportedComponents);
        if (result == null) {
            result = new TSB("");
        }
        return result;
    }

    private void connectTSB(String component, TSB tsb) {
        if (tsb == null) {
            return;
        }
        try {
            int size;
            String[] data = new String[]{};
            int i = 0;
            while (i < Parameters.fetch1Conections.length) {
                data = Parameters.fetch1Conections[i];
                if (data[1].equals(component)) break;
                ++i;
            }
            if (data.length > 0) {
                size = tsb.getOutPin(0).getNumOfLines();
                BoolsToInt input = new BoolsToInt(size);
                StringBuilder longName = new StringBuilder();
                int i2 = 0;
                while (i2 < size) {
                    input.setInPin(i2, NameConnector.getPin(data[4 + i2]));
                    longName = longName.append(data[4 + i2]).append(",");
                    ++i2;
                }
                input.getOutPin(0).setName(IndexExtractor.extractShortName(longName.toString()));
                tsb.setInPin(0, input.getOutPin(0));
                tsb.setE(NameConnector.getPin(data[3]));
                tsb.getE().setName(data[3]);
            } else {
                size = 0;
                BoolsToInt input = new BoolsToInt(size);
                StringBuilder longName = new StringBuilder();
                input.getOutPin(0).setName(IndexExtractor.extractShortName(longName.toString()));
                tsb.setInPin(0, input.getOutPin(0));
                tsb.setE(new Pin(false, ""));
                tsb.getE().setName("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Fetch1.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(592, 7));
        points.add(new Point(592, 775));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(573, 21));
        points.add(new Point(573, 760));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(554, 37));
        points.add(new Point(554, 748));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(573, 70));
        points.add(new Point(370, 70));
        points.add(new Point(370, 93));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(287, 102));
        points.add(new Point(294, 102));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.incPC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(287, 121));
        points.add(new Point(294, 121));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldPC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(445, 112));
        points.add(new Point(452, 112));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(370, 131));
        points.add(new Point(370, 251));
        points.add(new Point(456, 251));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(370, 204));
        points.add(new Point(456, 204));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(370, 157));
        points.add(new Point(456, 157));
        sections.add(points);
        line = new GuiPinLine(sections, this.PC.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(467, 162));
        points.add(new Point(467, 168));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.PCout1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(467, 209));
        points.add(new Point(467, 215));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.PCHout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(467, 256));
        points.add(new Point(467, 262));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.PCLout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(478, 157));
        points.add(new Point(592, 157));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBPCout1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(477, 204));
        points.add(new Point(554, 204));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBPCHout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(477, 251));
        points.add(new Point(554, 251));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBPCLout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(592, 298));
        points.add(new Point(226, 298));
        points.add(new Point(226, 320));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(441, 298));
        points.add(new Point(441, 321));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1lowINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(144, 331));
        points.add(new Point(151, 331));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(144, 349));
        points.add(new Point(151, 349));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldIR0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(226, 359));
        points.add(new Point(226, 377));
        sections.add(points);
        line = new GuiPinLine(sections, this.IR0ToINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(359, 331));
        points.add(new Point(366, 331));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(359, 349));
        points.add(new Point(366, 349));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldIR1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(441, 359));
        points.add(new Point(441, 377));
        sections.add(points);
        line = new GuiPinLine(sections, this.IR1ToINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(592, 404));
        points.add(new Point(227, 404));
        points.add(new Point(227, 427));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(441, 404));
        points.add(new Point(441, 427));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1lowINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(144, 436));
        points.add(new Point(151, 436));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(144, 455));
        points.add(new Point(151, 455));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldIR2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(227, 464));
        points.add(new Point(227, 481));
        sections.add(points);
        line = new GuiPinLine(sections, this.IR2ToINT.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(354, 436));
        points.add(new Point(366, 436));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(355, 455));
        points.add(new Point(366, 455));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldIR3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(441, 464));
        points.add(new Point(441, 481));
        sections.add(points);
        line = new GuiPinLine(sections, this.IR3ToINT.getOutPin(0));
        this.gui.addDrawable(line);
        TSBGui TSBIRDAout3Gui = new TSBGui(this.TSBIRDAout3, 375, 508, null, true, false);
        this.gui.addDrawables(TSBIRDAout3Gui.getDrawables());
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(500, 517));
        points.add(new Point(554, 517));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIRDAout3.getOutPin(0));
        this.gui.addDrawable(line);
        TSBGui TSBIRJAout2Gui = new TSBGui(this.TSBIRJAout2, 375, 565, null, true, false);
        this.gui.addDrawables(TSBIRJAout2Gui.getDrawables());
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(500, 574));
        points.add(new Point(573, 574));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIRJAout2.getOutPin(0));
        this.gui.addDrawable(line);
        TSBGui TSBIRPOMout3Gui = new TSBGui(this.TSBIRPOMout3, 375, 621, null, true, false);
        this.gui.addDrawables(TSBIRPOMout3Gui.getDrawables());
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(500, 630));
        points.add(new Point(554, 630));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIRPOMout3.getOutPin(0));
        this.gui.addDrawable(line);
        TSBGui TSBIRBRout3Gui = new TSBGui(this.TSBIRBRout3, 375, 678, null, true, false);
        this.gui.addDrawables(TSBIRBRout3Gui.getDrawables());
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(500, 687));
        points.add(new Point(554, 687));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBIRBRout3.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(595, 33, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(577, 66, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(524, 100, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(400, 67, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(330, 162, this.PC.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(507, 175, this.TSBPCout1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(512, 220, this.TSBPCHout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(512, 265, this.TSBPCLout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(340, 295, this.IBUS1lowINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(340, 401, this.IBUS1lowINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(220, 392, this.IR0ToINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(435, 392, this.IR1ToINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(220, 496, this.IR2ToINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(435, 496, this.IR3ToINT.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(508, 512, this.TSBIRDAout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(508, 569, this.TSBIRJAout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(508, 626, this.TSBIRPOMout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(508, 703, this.TSBIRBRout3.getOutPin(0)));
        this.gui.addDrawable(new GuiTextLabel(208, 319, "" + this.IR0.getInPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(208, 375, "" + this.IR0.getOutPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(423, 319, "" + this.IR1.getInPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(423, 375, "" + this.IR1.getOutPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(208, 425, "" + this.IR2.getInPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(208, 480, "" + this.IR2.getOutPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(423, 425, "" + this.IR3.getInPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(423, 480, "" + this.IR3.getOutPins().length, 14));
        this.gui.addDrawable(new GuiTextLabel(246, 381, this.IR0.getOutPins().length + this.IR1.getOutPins().length + this.IR2.getOutPins().length + this.IR3.getOutPins().length + -1 + ".." + (this.IR1.getOutPins().length + this.IR2.getOutPins().length + this.IR3.getOutPins().length), 10));
        this.gui.addDrawable(new GuiTextLabel(463, 381, this.IR1.getOutPins().length + this.IR2.getOutPins().length + this.IR3.getOutPins().length - 1 + ".." + (this.IR2.getOutPins().length + this.IR3.getOutPins().length), 10));
        this.gui.addDrawable(new GuiTextLabel(246, 483, this.IR2.getOutPins().length + this.IR3.getOutPins().length - 1 + ".." + this.IR3.getOutPins().length, 10));
        this.gui.addDrawable(new GuiTextLabel(463, 483, this.IR3.getOutPins().length - 1 + ".." + 0, 10));
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        Pin pin;
        String name;
        int id;
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        int dbusSize = Parameters.sizeDBUS;
        int i = 0;
        while (i < dbusSize) {
            id = 3 * dbusSize + i;
            name = "IR" + id;
            pin = this.IR0.getOutPin(i);
            pin.setName(name);
            result.add(new Element<String, Pin>(name, pin));
            ++i;
        }
        i = 0;
        while (i < dbusSize) {
            id = 2 * dbusSize + i;
            name = "IR" + id;
            pin = this.IR1.getOutPin(i);
            pin.setName(name);
            result.add(new Element<String, Pin>(name, pin));
            ++i;
        }
        i = 0;
        while (i < dbusSize) {
            id = dbusSize + i;
            name = "IR" + id;
            pin = this.IR2.getOutPin(i);
            pin.setName(name);
            result.add(new Element<String, Pin>(name, pin));
            ++i;
        }
        i = 0;
        while (i < dbusSize) {
            id = i;
            name = "IR" + id;
            pin = this.IR3.getOutPin(i);
            pin.setName(name);
            result.add(new Element<String, Pin>(name, pin));
            ++i;
        }
        result.add(new Element<String, Pin>("PC", this.PC.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        result.add(new Element<String, REG>("PC", this.PC));
        result.add(new Element<String, REG>("IR0", this.IR0));
        result.add(new Element<String, REG>("IR1", this.IR1));
        result.add(new Element<String, REG>("IR2", this.IR2));
        result.add(new Element<String, REG>("IR3", this.IR3));
        return result;
    }

    public REG RegPC() {
        return this.PC;
    }

    public REG RegIR0() {
        return this.IR0;
    }

    public REG RegIR1() {
        return this.IR1;
    }

    public REG RegIR2() {
        return this.IR2;
    }

    public REG RegIR3() {
        return this.IR3;
    }

    @Override
    public List<Element<String[], ValidationElement>> validate() {
        String[][] args = Parameters.fetch1Conections;
        HashSet<String> supportedNames = new HashSet<String>();
        supportedNames.add("IRAD");
        supportedNames.add("IRJA");
        supportedNames.add("IRPOM");
        supportedNames.add("IRBR");
        List<Element<String[], ValidationElement>> result = this.validate(args, supportedComponents, supportedNames, null);
        return result;
    }
}

