/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.ALU;
import logic.components.BoolsToInt;
import logic.components.CD;
import logic.components.CLK;
import logic.components.IntToBools;
import logic.components.IntToInt;
import logic.components.MP;
import logic.components.REG;
import logic.components.TSB;
import shemes.AbstractSchema;
import shemes.components.Bus1;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class Exec1
extends AbstractSchema {
    public static final String DNAME = "Exec1";
    private TSB TSBALUout1;
    private TSB TSBABout3;
    private IntToInt ABLToAB;
    private IntToInt IBUS2ToALU;
    private IntToInt IBUS3ToALU;
    private ALU ALUexec;
    private IntToBools ALUbits;
    private IntToBools ABbits;
    private IntToBools BBbits;
    private IntToInt IBUS1ToABandBB;
    private TSB TSBBBout2;
    private REG AB;
    private REG BB;
    private MP MX3;
    private MP MX4;
    private CD CD1;
    private CD CD2;
    private TSB TSBAWHout3;
    private TSB TSBAWout3;
    private TSB TSBBWout2;
    private IntToInt AWToAWH;
    private REG AW;
    private REG BW;

    public Exec1() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Exec1.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.TSBALUout1 = new TSB("ALUout1");
        this.TSBALUout1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.ABLToAB = new IntToInt(Parameters.sizeAB, Parameters.sizeIBUS3, false, false);
        this.TSBABout3 = new TSB("ABout3");
        this.TSBABout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.ALUexec = new ALU(Parameters.sizeALU);
        this.ALUbits = new IntToBools(Parameters.sizeALU);
        this.ABbits = new IntToBools(Parameters.sizeAB);
        this.BBbits = new IntToBools(Parameters.sizeBB);
        this.IBUS1ToABandBB = new IntToInt(Parameters.sizeIBUS1, Math.max(Parameters.sizeAB, Parameters.sizeBB), false, false);
        this.IBUS2ToALU = new IntToInt(Parameters.sizeIBUS2, Parameters.sizeALU, false, false);
        this.IBUS3ToALU = new IntToInt(Parameters.sizeIBUS3, Parameters.sizeALU, false, false);
        this.TSBBBout2 = new TSB("BBout2");
        this.TSBBBout2.getOutPin(0).setNumOfLines(Parameters.sizeBB);
        this.AB = new REG(1, "AB");
        this.AB.getOutPin(0).setIsInt();
        this.AB.getOutPin(0).setNumOfLines(Parameters.sizeAB);
        this.AB.initVal(Parameters.valAB);
        this.BB = new REG(1, "BB");
        this.BB.getOutPin(0).setIsInt();
        this.BB.getOutPin(0).setNumOfLines(Parameters.sizeBB);
        this.BB.initVal(Parameters.valBB);
        this.MX3 = new MP(4);
        this.CD1 = new CD(4);
        this.CD1.setE(new Pin(true, "1"));
        this.MX4 = new MP(4);
        this.CD2 = new CD(4);
        this.CD2.setE(new Pin(true, "1"));
        this.TSBBWout2 = new TSB("BWout2");
        this.TSBBWout2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.AWToAWH = new IntToInt(Parameters.sizeAW, Parameters.sizeAWH, true, false);
        this.TSBAWHout3 = new TSB("AWHout3");
        this.TSBAWHout3.getOutPin(0).setNumOfLines(Parameters.sizeAWH);
        this.TSBAWout3 = new TSB("AWout3");
        this.TSBAWout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.AW = new REG(1, "AW");
        this.AW.getOutPin(0).setIsInt();
        this.AW.getOutPin(0).setNumOfLines(Parameters.sizeAW);
        this.AW.initVal(Parameters.valAW);
        this.BW = new REG(1, "BW");
        this.BW.getOutPin(0).setIsInt();
        this.BW.getOutPin(0).setNumOfLines(Parameters.sizeBW);
        this.BW.initVal(Parameters.valBW);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.TSBALUout1.setInPin(0, this.ALUexec.getOutPin(0));
        this.TSBALUout1.setE(NameConnector.getPin("Oper1.ALUout1"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS1(this.TSBALUout1.getOutPin(0));
        this.ABLToAB.setInPin(0, this.AB.getOutPin(0));
        this.TSBABout3.setInPin(0, this.ABLToAB.getOutPin(0));
        this.TSBABout3.setE(NameConnector.getPin("Oper1.ABout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBABout3.getOutPin(0));
        this.IBUS2ToALU.setInPin(0, NameConnector.getPin("Bus1.IBUS2"));
        this.IBUS3ToALU.setInPin(0, NameConnector.getPin("Bus1.IBUS3"));
        this.ALUexec.setPinX(this.IBUS3ToALU.getOutPin(0));
        this.ALUexec.setPinY(this.IBUS2ToALU.getOutPin(0));
        this.ALUexec.setPinAdd(NameConnector.getPin("Oper1.add"));
        this.ALUexec.setPinSub(NameConnector.getPin("Oper1.sub"));
        this.ALUexec.setPinInc(NameConnector.getPin("Oper1.inc"));
        this.ALUexec.setPinDec(NameConnector.getPin("Oper1.dec"));
        this.ALUexec.setPinAnd(NameConnector.getPin("Oper1.and"));
        this.ALUexec.setPinOr(NameConnector.getPin("Oper1.or"));
        this.ALUexec.setPinXor(NameConnector.getPin("Oper1.xor"));
        this.ALUexec.setPinNot(NameConnector.getPin("Oper1.not"));
        this.ALUbits.setInPin(0, this.ALUexec.getOutPin(0));
        this.IBUS1ToABandBB.setInPin(0, NameConnector.getPin("Bus1.IBUS1"));
        this.TSBBBout2.setInPin(0, this.BB.getOutPin(0));
        this.TSBBBout2.setE(NameConnector.getPin("Oper1.BBout2"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS2(this.TSBBBout2.getOutPin(0));
        this.AB.setInPin(0, this.IBUS1ToABandBB.getOutPin(0));
        this.AB.setPinLd(NameConnector.getPin("Oper1.ldAB"));
        this.AB.setShr(NameConnector.getPin("Oper1.shr"));
        this.AB.setIR(this.MX3.getOutPin(0));
        this.AB.setShl(NameConnector.getPin("Oper1.shl"));
        this.AB.setIL(this.MX4.getOutPin(0));
        this.AB.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.ABbits.setInPin(0, this.AB.getOutPin(0));
        this.BB.setInPin(0, this.IBUS1ToABandBB.getOutPin(0));
        this.BB.setPinLd(NameConnector.getPin("Oper1.ldBB"));
        this.BB.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.BBbits.setInPin(0, this.BB.getOutPin(0));
        this.CD1.setInPin(0, NameConnector.getPin("Fetch2.ASR"));
        this.CD1.setInPin(1, NameConnector.getPin("Fetch2.LSR"));
        this.CD1.setInPin(2, NameConnector.getPin("Fetch2.ROR"));
        this.CD1.setInPin(3, NameConnector.getPin("Fetch2.RORC"));
        this.MX3.setCtrl(0, this.CD1.getOutPin(0));
        this.MX3.setCtrl(1, this.CD1.getOutPin(1));
        this.MX3.setInPin(0, this.ABbits.getOutPin(Parameters.sizeAB - 1));
        this.MX3.setInPin(1, new Pin(false, "0"));
        this.MX3.setInPin(2, this.ABbits.getOutPin(0));
        this.MX3.setInPin(3, NameConnector.getPin("Exec2.PSWC"));
        this.CD2.setInPin(0, NameConnector.getPin("Fetch2.ASL"));
        this.CD2.setInPin(1, NameConnector.getPin("Fetch2.LSL"));
        this.CD2.setInPin(2, NameConnector.getPin("Fetch2.ROL"));
        this.CD2.setInPin(3, NameConnector.getPin("Fetch2.ROLC"));
        this.MX4.setCtrl(0, this.CD2.getOutPin(0));
        this.MX4.setCtrl(1, this.CD2.getOutPin(1));
        this.MX4.setInPin(0, new Pin(false, "0"));
        this.MX4.setInPin(1, new Pin(false, "0"));
        this.MX4.setInPin(2, this.ABbits.getOutPin(Parameters.sizeAB - 1));
        this.MX4.setInPin(3, NameConnector.getPin("Exec2.PSWC"));
        this.TSBBWout2.setInPin(0, this.BW.getOutPin(0));
        this.TSBBWout2.setE(NameConnector.getPin("Oper1.BWout2"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS2(this.TSBBWout2.getOutPin(0));
        this.AWToAWH.setInPin(0, this.AW.getOutPin(0));
        this.TSBAWHout3.setInPin(0, this.AWToAWH.getOutPin(0));
        this.TSBAWHout3.setE(NameConnector.getPin("Oper1.AWHout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBAWHout3.getOutPin(0));
        this.TSBAWout3.setInPin(0, this.AW.getOutPin(0));
        this.TSBAWout3.setE(NameConnector.getPin("Oper1.AWout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBAWout3.getOutPin(0));
        this.AW.setInPin(0, NameConnector.getPin("Bus1.IBUS2"));
        this.AW.setPinLd(NameConnector.getPin("Oper1.ldAW"));
        this.AW.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.BW.setInPin(0, NameConnector.getPin("Bus1.IBUS2"));
        this.BW.setPinLd(NameConnector.getPin("Oper1.ldBW"));
        this.BW.setClk((CLK)NameConnector.getComponent("CPUCLK"));
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Exec1.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(627, 16));
        points.add(new Point(627, 832));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(608, 31));
        points.add(new Point(608, 817));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(608, 772));
        points.add(new Point(175, 772));
        points.add(new Point(175, 753));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(401, 772));
        points.add(new Point(401, 753));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(589, 46));
        points.add(new Point(589, 801));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        if (Parameters.sizeAB < Parameters.sizeIBUS3) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(341, 63));
            points.add(new Point(366, 63));
            sections.add(points);
            int numZeros = Parameters.sizeIBUS3 - Parameters.sizeAB;
            BoolsToInt zeroes = new BoolsToInt(numZeros);
            int i = 0;
            while (i < numZeros) {
                zeroes.setInPin(i, new Pin(false, "0"));
                ++i;
            }
            line = new GuiPinLine(sections, zeroes.getOutPin(0));
            this.gui.addDrawable(line);
        }
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(341, 78));
        points.add(new Point(366, 78));
        sections.add(points);
        line = new GuiPinLine(sections, this.AB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(404, 70));
        points.add(new Point(476, 70));
        sections.add(points);
        line = new GuiPinLine(sections, this.ABLToAB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 75));
        points.add(new Point(487, 81));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ABout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 70));
        points.add(new Point(589, 70));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBABout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 632));
        points.add(new Point(147, 632));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.ASR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 614));
        points.add(new Point(147, 614));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.LSR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 595));
        points.add(new Point(147, 595));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.ROR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(139, 576));
        points.add(new Point(147, 576));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.RORC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(203, 614));
        points.add(new Point(222, 614));
        points.add(new Point(222, 538));
        points.add(new Point(185, 538));
        points.add(new Point(185, 529));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(203, 595));
        points.add(new Point(213, 595));
        points.add(new Point(213, 548));
        points.add(new Point(166, 548));
        points.add(new Point(166, 529));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD1.getOutPin(1));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 510));
        points.add(new Point(147, 510));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec1.AB_Last"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(139, 491));
        points.add(new Point(147, 491));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(139, 472));
        points.add(new Point(147, 472));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec1.AB0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(140, 453));
        points.add(new Point(147, 453));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec2.PSWC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(203, 481));
        points.add(new Point(222, 481));
        points.add(new Point(222, 415));
        points.add(new Point(92, 415));
        points.add(new Point(92, 368));
        points.add(new Point(100, 368));
        sections.add(points);
        line = new GuiPinLine(sections, this.MX3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(300, 632));
        points.add(new Point(307, 632));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.ASL"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(300, 614));
        points.add(new Point(307, 614));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.LSL"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(300, 595));
        points.add(new Point(307, 595));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.ROL"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(299, 576));
        points.add(new Point(307, 576));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Fetch2.ROLC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(363, 614));
        points.add(new Point(382, 614));
        points.add(new Point(382, 538));
        points.add(new Point(344, 538));
        points.add(new Point(344, 529));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(363, 595));
        points.add(new Point(373, 595));
        points.add(new Point(373, 548));
        points.add(new Point(326, 548));
        points.add(new Point(326, 529));
        sections.add(points);
        line = new GuiPinLine(sections, this.CD2.getOutPin(1));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(300, 510));
        points.add(new Point(307, 510));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(299, 491));
        points.add(new Point(307, 491));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(299, 472));
        points.add(new Point(307, 472));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec1.AB_Last"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(300, 453));
        points.add(new Point(307, 453));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec2.PSWC"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(363, 481));
        points.add(new Point(382, 481));
        points.add(new Point(382, 415));
        points.add(new Point(258, 415));
        points.add(new Point(258, 368));
        points.add(new Point(250, 368));
        sections.add(points);
        line = new GuiPinLine(sections, this.MX4.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(93, 346));
        points.add(new Point(100, 346));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(92, 357));
        points.add(new Point(100, 357));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.shr"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(250, 357));
        points.add(new Point(257, 357));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.shl"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(250, 346));
        points.add(new Point(257, 346));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldAB"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(627, 397));
        points.add(new Point(175, 397));
        points.add(new Point(175, 378));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1ToABandBB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(175, 336));
        points.add(new Point(175, 323));
        sections.add(points);
        line = new GuiPinLine(sections, this.AB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(207, 166));
        points.add(new Point(215, 166));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.not"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(208, 181));
        points.add(new Point(215, 181));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.xor"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(208, 197));
        points.add(new Point(215, 197));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.or"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(207, 212));
        points.add(new Point(215, 212));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.and"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(211, 242));
        points.add(new Point(230, 242));
        points.add(new Point(230, 231));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(608, 246));
        points.add(new Point(324, 246));
        points.add(new Point(324, 231));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS2ToALU.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(361, 212));
        points.add(new Point(368, 212));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.add"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(361, 197));
        points.add(new Point(368, 197));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.sub"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(361, 181));
        points.add(new Point(368, 181));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.inc"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(361, 166));
        points.add(new Point(368, 166));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.dec"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(368, 132));
        points.add(new Point(346, 132));
        points.add(new Point(346, 148));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Exec1.C_Last"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(288, 148));
        points.add(new Point(288, 117));
        points.add(new Point(476, 117));
        sections.add(points);
        line = new GuiPinLine(sections, this.ALUexec.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 123));
        points.add(new Point(487, 128));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ALUout1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 117));
        points.add(new Point(627, 117));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBALUout1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(589, 265));
        points.add(new Point(252, 265));
        points.add(new Point(252, 231));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS3ToALU.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 397));
        points.add(new Point(401, 378));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1ToABandBB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(318, 357));
        points.add(new Point(326, 357));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(476, 357));
        points.add(new Point(483, 357));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldBB"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 337));
        points.add(new Point(401, 293));
        points.add(new Point(476, 293));
        sections.add(points);
        line = new GuiPinLine(sections, this.BB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 298));
        points.add(new Point(487, 304));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.BBout2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 293));
        points.add(new Point(608, 293));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBBBout2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(93, 732));
        points.add(new Point(100, 732));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldAW"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(250, 732));
        points.add(new Point(257, 732));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(175, 712));
        points.add(new Point(175, 693));
        sections.add(points);
        line = new GuiPinLine(sections, this.AW.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(319, 732));
        points.add(new Point(326, 732));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldBW"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(476, 732));
        points.add(new Point(483, 732));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 712));
        points.add(new Point(401, 670));
        points.add(new Point(476, 670));
        sections.add(points);
        line = new GuiPinLine(sections, this.BW.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 681));
        points.add(new Point(487, 675));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.BWout2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 670));
        points.add(new Point(608, 670));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBBWout2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(410, 623));
        points.add(new Point(476, 623));
        sections.add(points);
        line = new GuiPinLine(sections, this.AW.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(429, 623));
        points.add(new Point(429, 576));
        points.add(new Point(476, 576));
        sections.add(points);
        line = new GuiPinLine(sections, this.AWToAWH.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 581));
        points.add(new Point(487, 587));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.AWHout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(487, 628));
        points.add(new Point(487, 634));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.AWout3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 576));
        points.add(new Point(589, 576));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBAWHout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(498, 623));
        points.add(new Point(589, 623));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBAWout3.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(631, 64, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(613, 80, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(593, 94, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(497, 393, this.IBUS1ToABandBB.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(405, 316, this.BB.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(526, 309, this.TSBBBout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(169, 316, this.AB.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(413, 241, this.IBUS2ToALU.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(280, 260, this.IBUS3ToALU.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(312, 112, this.ALUexec.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(526, 129, this.TSBALUout1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(536, 84, this.TSBABout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(164, 690, this.AW.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(536, 589, this.TSBAWHout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(582, 636, this.TSBAWout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(84, 684, this.TSBBWout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(500, 767, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(406, 691, this.BW.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(196, 767, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiTextLabel(569, 118, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(569, 247, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(569, 265, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(569, 292, String.valueOf(Parameters.sizeBB - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(569, 397, String.valueOf(Parameters.sizeAB - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(322, 138, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(250, 231, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(321, 231, String.valueOf(Parameters.sizeALU - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(207, 336, String.valueOf(Parameters.sizeAB - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(425, 336, String.valueOf(Parameters.sizeBB - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(373, 81, String.valueOf(Parameters.sizeAB - 1) + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(320, 87, String.valueOf(Parameters.sizeAB - 1) + "..0", 10));
        if (Parameters.sizeAB != Parameters.sizeIBUS3) {
            this.gui.addDrawable(new GuiTextLabel(368, 68, String.valueOf(Parameters.sizeAB - 1) + "..0", 10));
            this.gui.addDrawable(new GuiTextLabel(350, 60, "" + (Parameters.sizeIBUS3 - Parameters.sizeAB), 10));
        }
        this.gui.addDrawable(new GuiTextLabel(350, 75, "" + Parameters.sizeAB, 10));
        this.gui.addDrawable(new GuiTextLabel(273, 143, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(380, 143, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(451, 133, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(505, 133, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(347, 165, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(257, 244, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(329, 244, "" + Parameters.sizeALU, 10));
        this.gui.addDrawable(new GuiTextLabel(162, 333, "" + Parameters.sizeAB, 10));
        this.gui.addDrawable(new GuiTextLabel(388, 333, "" + Parameters.sizeAB, 10));
        this.gui.addDrawable(new GuiTextLabel(162, 393, "" + Parameters.sizeBB, 10));
        this.gui.addDrawable(new GuiTextLabel(388, 393, "" + Parameters.sizeBB, 10));
        this.gui.addDrawable(new GuiTextLabel(451, 413, "" + Parameters.sizeAB, 10));
        this.gui.addDrawable(new GuiTextLabel(130, 515, "" + (Parameters.sizeAB - 1), 10));
        this.gui.addDrawable(new GuiTextLabel(290, 480, "" + (Parameters.sizeAB - 1), 10));
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        int i = 0;
        while (i < Parameters.sizeAB) {
            result.add(new Element<String, Pin>("AB" + i, this.ABbits.getOutPin(i)));
            ++i;
        }
        result.add(new Element<String, Pin>("AB_Last", this.ABbits.getOutPin(Parameters.sizeAB - 1)));
        result.add(new Element<String, Pin>("C_Last", this.ALUexec.getPinC_Last()));
        result.add(new Element<String, Pin>("ALU_Last", this.ALUbits.getOutPin(Parameters.sizeALU - 1)));
        result.add(new Element<String, Pin>("BB_Last", this.BBbits.getOutPin(Parameters.sizeBB - 1)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        NameConnector.addComponent(this.componentName, "AB", this.AB);
        NameConnector.addComponent(this.componentName, "BB", this.BB);
        NameConnector.addComponent(this.componentName, "AW", this.AW);
        NameConnector.addComponent(this.componentName, "BW", this.BW);
        return result;
    }

    public REG RegAB() {
        return this.AB;
    }

    public REG RegBB() {
        return this.BB;
    }

    public REG RegAW() {
        return this.AW;
    }

    public REG RegBW() {
        return this.BW;
    }
}

