/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.AND;
import logic.components.BUS;
import logic.components.BoolsToInt;
import logic.components.CLK;
import logic.components.IntToInt;
import logic.components.MP;
import logic.components.NOT;
import logic.components.OR;
import logic.components.REG;
import logic.components.TSB;
import shemes.AbstractSchema;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.ValidationElement;

public class Bus1
extends AbstractSchema {
    public static final String DNAME = "Bus1";
    private BUS IBUS1;
    private BUS IBUS2;
    private BUS IBUS3;
    private BUS ABUS;
    private BUS DBUS;
    private BUS NOTRDBUS;
    private BUS NOTWRBUS;
    private BUS NOTFCBUS;
    private TSB TSBMOST1_2;
    private TSB TSBMOST2_1;
    private TSB TSBMDRout1;
    private TSB TSBeMAR;
    private TSB TSBeMDR;
    private TSB TSBrdCPU;
    private TSB TSBwrCPU;
    private TSB TSBDWout2;
    private TSB TSB1;
    private TSB TSBMOST1_3;
    private TSB TSBMOST3_2;
    private IntToInt IBUS1low;
    private MP MX1;
    private AND AND1;
    private AND AND2;
    private OR OR1;
    private REG MAR;
    private REG MDR;
    private REG DWH;
    private REG DWL;
    private NOT NOT1;
    private NOT NOT2;
    private NOT NOT3;
    private NOT NOT4;
    private BoolsToInt DW;
    private BoolsToInt DWHint;
    private BoolsToInt DWLint;

    public Bus1() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Bus1.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.IBUS1 = new BUS("IBUS1");
        this.IBUS1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.IBUS2 = new BUS("IBUS2");
        this.IBUS2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.IBUS3 = new BUS("IBUS3");
        this.IBUS3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.ABUS = new BUS("ABUS");
        this.ABUS.getOutPin(0).setNumOfLines(Parameters.sizeABUS);
        this.DBUS = new BUS("DBUS");
        this.DBUS.getOutPin(0).setNumOfLines(Parameters.sizeDBUS);
        this.NOTRDBUS = new BUS("NOTRDBUS");
        this.NOTRDBUS.getOutPin(0).setIsBool();
        this.NOTWRBUS = new BUS("NOTWRBUS");
        this.NOTWRBUS.getOutPin(0).setIsBool();
        this.NOTFCBUS = new BUS("NOTFCBUS");
        this.NOTFCBUS.getOutPin(0).setIsBool();
        this.TSBMOST1_2 = new TSB("MOST1_2");
        this.TSBMOST1_2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.TSBMOST2_1 = new TSB("MOST2_1");
        this.TSBMOST2_1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.TSBMOST1_3 = new TSB("MOST1_3");
        this.TSBMOST1_3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.TSBMOST3_2 = new TSB("MOST3_2");
        this.TSBMOST3_2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.TSBMDRout1 = new TSB("MDRout1");
        this.TSBMDRout1.getOutPin(0).setNumOfLines(Parameters.sizeMDR);
        this.TSBeMAR = new TSB("eMAR");
        this.TSBeMAR.getOutPin(0).setNumOfLines(Parameters.sizeABUS);
        this.TSBeMDR = new TSB("eMDR");
        this.TSBeMDR.getOutPin(0).setNumOfLines(Parameters.sizeMDR);
        this.TSBrdCPU = new TSB("rdCPU");
        this.TSBrdCPU.getOutPin(0).setNumOfLines(1);
        this.TSBrdCPU.getOutPin(0).setIsBool();
        this.TSBwrCPU = new TSB("wrCPU");
        this.TSBwrCPU.getOutPin(0).setNumOfLines(1);
        this.TSBwrCPU.getOutPin(0).setIsBool();
        this.TSBDWout2 = new TSB("DWout2");
        this.TSBDWout2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.IBUS1low = new IntToInt(Parameters.sizeIBUS1, Math.max(Parameters.sizeDWL, Parameters.sizeDWH), false, false);
        this.MX1 = new MP(2);
        this.MX1.getOutPin(0).setIsInt();
        this.MX1.getOutPin(0).setNumOfLines(Parameters.sizeMAR);
        this.AND1 = new AND();
        this.AND2 = new AND();
        this.OR1 = new OR();
        this.MAR = new REG(1, "MAR");
        this.MAR.getOutPin(0).setIsInt();
        this.MAR.getOutPin(0).setNumOfLines(Parameters.sizeMAR);
        this.MAR.initVal(Parameters.valMAR);
        this.MDR = new REG(1, "MDR");
        this.MDR.getOutPin(0).setIsInt();
        this.MDR.getOutPin(0).setNumOfLines(Parameters.sizeMDR);
        this.MDR.initVal(Parameters.valMDR);
        this.DWH = new REG(Parameters.sizeDWH, "DWH");
        this.DWH.initVal(Parameters.valDWH);
        this.DWL = new REG(Parameters.sizeDWL, "DWL");
        this.DWL.initVal(Parameters.valDWL);
        this.TSB1 = new TSB("NOT_FCBUS");
        this.TSB1.getOutPin(0).setNumOfLines(1);
        this.TSB1.getOutPin(0).setIsBool();
        this.NOT1 = new NOT();
        this.NOT2 = new NOT();
        this.NOT3 = new NOT();
        this.NOT4 = new NOT();
        this.DW = new BoolsToInt(Parameters.sizeDW);
        this.DWHint = new BoolsToInt(Parameters.sizeDWH);
        this.DWLint = new BoolsToInt(Parameters.sizeDWL);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.TSBMOST1_2.setInPin(0, this.IBUS1.getOutPin(0));
        this.TSBMOST1_2.setE(NameConnector.getPin("Oper1.MOST1_2"));
        this.addOnIBUS2(this.TSBMOST1_2.getOutPin(0));
        this.TSBMOST2_1.setInPin(0, this.IBUS2.getOutPin(0));
        this.TSBMOST2_1.setE(NameConnector.getPin("Oper1.MOST2_1"));
        this.addOnIBUS1(this.TSBMOST2_1.getOutPin(0));
        this.TSBMOST1_3.setInPin(0, this.IBUS1.getOutPin(0));
        this.TSBMOST1_3.setE(NameConnector.getPin("Oper1.MOST1_3"));
        this.addOnIBUS3(this.TSBMOST1_3.getOutPin(0));
        this.TSBMOST3_2.setInPin(0, this.IBUS3.getOutPin(0));
        this.TSBMOST3_2.setE(NameConnector.getPin("Oper1.MOST3_2"));
        this.addOnIBUS2(this.TSBMOST3_2.getOutPin(0));
        this.IBUS1low.setInPin(0, this.IBUS1.getOutPin(0));
        this.MX1.setInPin(0, this.DBUS.getOutPin(0));
        this.MX1.setInPin(1, this.IBUS3.getOutPin(0));
        this.MX1.setCtrl(0, NameConnector.getPin("Oper1.mxMDR"));
        this.TSB1.setInPin(0, NameConnector.getPin("Bus1.NOTFCBUS"));
        this.NOT1.setInPin(0, this.TSB1.getOutPin(0));
        this.AND1.setInPin(0, NameConnector.getPin("Oper1.rdCPU"));
        this.AND1.setInPin(1, this.NOT1.getOutPin(0));
        this.OR1.setInPin(0, NameConnector.getPin("Oper1.ldMDR"));
        this.OR1.setInPin(1, this.AND1.getOutPin(0));
        this.MDR.setInPin(0, this.MX1.getOutPin(0));
        this.MDR.setPinLd(this.OR1.getOutPin(0));
        this.MDR.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBMDRout1.setInPin(0, this.MDR.getOutPin(0));
        this.TSBMDRout1.setE(NameConnector.getPin("Oper1.MDRout1"));
        this.addOnIBUS1(this.TSBMDRout1.getOutPin(0));
        this.TSBeMDR.setInPin(0, this.MDR.getOutPin(0));
        this.TSBeMDR.setE(NameConnector.getPin("Oper1.eMDR"));
        this.addOnDBUS(this.TSBeMDR.getOutPin(0));
        this.MAR.setInPin(0, this.IBUS2.getOutPin(0));
        this.MAR.setPinLd(NameConnector.getPin("Oper1.ldMAR"));
        this.MAR.setPinInc(NameConnector.getPin("Oper1.incMAR"));
        this.MAR.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBeMAR.setInPin(0, this.MAR.getOutPin(0));
        this.TSBeMAR.setE(NameConnector.getPin("Oper1.eMAR"));
        this.addOnABUS(this.TSBeMAR.getOutPin(0));
        this.TSBrdCPU.setInPin(0, new Pin(true, "1"));
        this.TSBrdCPU.setE(NameConnector.getPin("Oper1.rdCPU"));
        this.NOT2.setInPin(0, this.TSBrdCPU.getOutPin(0));
        this.addOnNOTRDBUS(this.NOT2.getOutPin(0));
        this.TSBwrCPU.setInPin(0, new Pin(true, "1"));
        this.TSBwrCPU.setE(NameConnector.getPin("Oper1.wrCPU"));
        this.NOT3.setInPin(0, this.TSBwrCPU.getOutPin(0));
        this.addOnNOTWRBUS(this.NOT3.getOutPin(0));
        this.NOT4.setInPin(0, NameConnector.getPin("Oper1.eMAR"));
        this.AND2.setInPin(0, new Pin(false, "1"));
        this.AND2.setInPin(1, this.NOT4.getOutPin(0));
        this.DWH.setInPin(0, this.IBUS1low.getOutPin(0));
        this.DWH.setPinLd(NameConnector.getPin("Oper1.ldDWH"));
        this.DWH.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.DWL.setInPin(0, this.IBUS1low.getOutPin(0));
        this.DWL.setPinLd(NameConnector.getPin("Oper1.ldDWL"));
        this.DWL.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        int i = 0;
        while (i < Parameters.sizeDWL) {
            this.DW.setInPin(i, this.DWL.getOutPin(i));
            this.DWLint.setInPin(i, this.DWL.getOutPin(i));
            ++i;
        }
        i = 0;
        while (i < Parameters.sizeDWH) {
            this.DW.setInPin(Parameters.sizeDWL + i, this.DWH.getOutPin(i));
            this.DWHint.setInPin(i, this.DWH.getOutPin(i));
            ++i;
        }
        this.TSBDWout2.setInPin(0, this.DW.getOutPin(0));
        this.TSBDWout2.setE(NameConnector.getPin("Oper1.DWout2"));
        this.addOnIBUS2(this.TSBDWout2.getOutPin(0));
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Bus1.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(619, 5));
        points.add(new Point(619, 804));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(600, 20));
        points.add(new Point(600, 642));
        points.add(new Point(468, 642));
        points.add(new Point(468, 804));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(581, 35));
        points.add(new Point(581, 623));
        points.add(new Point(318, 623));
        points.add(new Point(318, 804));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(542, 700));
        points.add(new Point(542, 694));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.MOST1_2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(542, 757));
        points.add(new Point(542, 750));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.MOST2_1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(391, 672));
        points.add(new Point(391, 666));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.MOST1_3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(391, 728));
        points.add(new Point(391, 722));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.MOST3_2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(531, 689));
        points.add(new Point(468, 689));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMOST1_2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(468, 746));
        points.add(new Point(530, 746));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(552, 746));
        points.add(new Point(619, 746));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMOST2_1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(553, 689));
        points.add(new Point(619, 689));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 718));
        points.add(new Point(468, 718));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMOST3_2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(379, 718));
        points.add(new Point(318, 718));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(380, 661));
        points.add(new Point(318, 661));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMOST1_3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(402, 661));
        points.add(new Point(619, 661));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(126, 180));
        points.add(new Point(133, 180));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldMAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(126, 199));
        points.add(new Point(133, 199));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.incMAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(284, 189));
        points.add(new Point(291, 189));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(208, 208));
        points.add(new Point(208, 312));
        sections.add(points);
        line = new GuiPinLine(sections, this.MAR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(197, 323));
        points.add(new Point(204, 323));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.eMAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(208, 334));
        points.add(new Point(208, 351));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBeMAR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(457, 85));
        points.add(new Point(457, 104));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.DBUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(581, 80));
        points.add(new Point(476, 80));
        points.add(new Point(476, 104));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(495, 123));
        points.add(new Point(501, 123));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.mxMDR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 142));
        points.add(new Point(466, 170));
        sections.add(points);
        line = new GuiPinLine(sections, this.MX1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(337, 255));
        points.add(new Point(344, 255));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.NOTFCBUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(371, 255));
        points.add(new Point(378, 255));
        points.add(new Point(378, 227));
        points.add(new Point(316, 227));
        points.add(new Point(316, 201));
        points.add(new Point(323, 201));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOT1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(152, 416));
        points.add(new Point(152, 409));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.rdCPU"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(346, 195));
        points.add(new Point(363, 195));
        points.add(new Point(353, 195));
        points.add(new Point(353, 202));
        sections.add(points);
        line = new GuiPinLine(sections, this.AND1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(353, 152));
        points.add(new Point(353, 184));
        points.add(new Point(363, 184));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldMDR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(383, 189));
        points.add(new Point(391, 189));
        sections.add(points);
        line = new GuiPinLine(sections, this.OR1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(542, 189));
        points.add(new Point(548, 189));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(316, 152));
        points.add(new Point(316, 189));
        points.add(new Point(323, 189));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.rdCPU"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 208));
        points.add(new Point(466, 312));
        sections.add(points);
        line = new GuiPinLine(sections, this.MDR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 255));
        points.add(new Point(483, 255));
        sections.add(points);
        line = new GuiPinLine(sections, this.MDR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(494, 260));
        points.add(new Point(494, 266));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.MDRout1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(505, 255));
        points.add(new Point(619, 255));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMDRout1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(455, 323));
        points.add(new Point(462, 323));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.eMDR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 334));
        points.add(new Point(466, 351));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBeMDR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(130, 404));
        points.add(new Point(141, 404));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(168, 404));
        points.add(new Point(174, 404));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOT2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(250, 404));
        points.add(new Point(261, 404));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(272, 410));
        points.add(new Point(272, 415));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.wrCPU"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(288, 404));
        points.add(new Point(295, 404));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOT3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 399));
        points.add(new Point(412, 399));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(false, "0"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(401, 410));
        points.add(new Point(407, 410));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.eMAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(434, 404));
        points.add(new Point(441, 404));
        sections.add(points);
        line = new GuiPinLine(sections, this.AND2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(619, 468));
        points.add(new Point(252, 468));
        points.add(new Point(252, 487));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1low.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 468));
        points.add(new Point(466, 487));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1low.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(169, 497));
        points.add(new Point(177, 497));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(384, 497));
        points.add(new Point(391, 497));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(169, 516));
        points.add(new Point(177, 516));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldDWH"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(252, 525));
        points.add(new Point(252, 543));
        sections.add(points);
        line = new GuiPinLine(sections, this.DWHint.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(384, 516));
        points.add(new Point(391, 516));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldDWL"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(466, 525));
        points.add(new Point(466, 544));
        sections.add(points);
        line = new GuiPinLine(sections, this.DWLint.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(382, 570));
        points.add(new Point(407, 570));
        sections.add(points);
        line = new GuiPinLine(sections, this.DWHint.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(382, 585));
        points.add(new Point(407, 585));
        sections.add(points);
        line = new GuiPinLine(sections, this.DWLint.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(445, 578));
        points.add(new Point(483, 578));
        sections.add(points);
        line = new GuiPinLine(sections, this.DW.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(494, 589));
        points.add(new Point(494, 583));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.DWout2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(505, 578));
        points.add(new Point(600, 578));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBDWout2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(208, 170));
        points.add(new Point(208, 67));
        points.add(new Point(600, 67));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(622, 28, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(602, 46, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(584, 64, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(212, 145, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(456, 463, this.IBUS1low.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(255, 463, this.IBUS1low.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(478, 705, this.TSBMOST1_2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(580, 761, this.TSBMOST2_1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(330, 677, this.TSBMOST1_3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(431, 734, this.TSBMOST3_2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(221, 248, this.MAR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(471, 362, this.TSBeMDR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(195, 362, this.TSBeMAR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(449, 82, this.DBUS.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(475, 157, this.MX1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(435, 248, this.MDR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(535, 271, this.TSBMDRout1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(244, 555, this.DWHint.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(461, 555, this.DWLint.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(452, 592, this.DW.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(532, 574, this.TSBDWout2.getOutPin(0)));
        this.gui.addDrawable(new GuiTextLabel(443, 90, "" + Parameters.sizeMDR, 14));
        this.gui.addDrawable(new GuiTextLabel(461, 90, "" + Parameters.sizeMDR, 14));
        this.gui.addDrawable(new GuiTextLabel(446, 168, "" + Parameters.sizeMDR, 14));
        this.gui.addDrawable(new GuiTextLabel(446, 228, "" + Parameters.sizeMDR, 14));
        this.gui.addDrawable(new GuiTextLabel(446, 350, "" + Parameters.sizeDBUS, 14));
        this.gui.addDrawable(new GuiTextLabel(511, 272, "" + Parameters.sizeMDR, 14));
        this.gui.addDrawable(new GuiTextLabel(426, 100, Parameters.sizeMDR - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(515, 100, Parameters.sizeMDR - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(503, 231, Parameters.sizeMDR - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(547, 252, Parameters.sizeMDR - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(506, 354, Parameters.sizeMDR - 1 + "..0", 10));
    }

    public void addOnIBUS1(Pin pin) {
        this.IBUS1.setInPin(0, pin);
    }

    public void addOnIBUS2(Pin pin) {
        this.IBUS2.setInPin(0, pin);
    }

    public void addOnIBUS3(Pin pin) {
        this.IBUS3.setInPin(0, pin);
    }

    public void addOnDBUS(Pin pin) {
        this.DBUS.setInPin(0, pin);
    }

    public void addOnABUS(Pin pin) {
        this.ABUS.setInPin(0, pin);
    }

    public void addOnNOTRDBUS(Pin pin) {
        this.NOTRDBUS.setInPin(0, pin);
    }

    public void addOnNOTWRBUS(Pin pin) {
        this.NOTWRBUS.setInPin(0, pin);
    }

    public void addOnNOTFCBUS(Pin pin) {
        this.NOTFCBUS.setInPin(0, pin);
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("IBUS1", this.IBUS1.getOutPin(0)));
        result.add(new Element<String, Pin>("IBUS2", this.IBUS2.getOutPin(0)));
        result.add(new Element<String, Pin>("IBUS3", this.IBUS3.getOutPin(0)));
        result.add(new Element<String, Pin>("ABUS", this.ABUS.getOutPin(0)));
        result.add(new Element<String, Pin>("DBUS", this.DBUS.getOutPin(0)));
        result.add(new Element<String, Pin>("NOTRDBUS", this.NOTRDBUS.getOutPin(0)));
        result.add(new Element<String, Pin>("NOTWRBUS", this.NOTWRBUS.getOutPin(0)));
        result.add(new Element<String, Pin>("NOTFCBUS", this.NOTFCBUS.getOutPin(0)));
        result.add(new Element<String, Pin>("MDR", this.MDR.getOutPin(0)));
        result.add(new Element<String, Pin>("MAR", this.MAR.getOutPin(0)));
        result.add(new Element<String, Pin>("MX1", this.MX1.getOutPin(0)));
        result.add(new Element<String, Pin>("TSBMOST1_2out", this.TSBMOST1_2.getOutPin(0)));
        result.add(new Element<String, Pin>("TSBMOST2_1out", this.TSBMOST2_1.getOutPin(0)));
        result.add(new Element<String, Pin>("TSBMDRoutToIBUS", this.TSBMDRout1.getOutPin(0)));
        result.add(new Element<String, Pin>("TSBeMDRout", this.TSBeMDR.getOutPin(0)));
        result.add(new Element<String, Pin>("TSBMARout", this.TSBeMAR.getOutPin(0)));
        result.add(new Element<String, Pin>("fcCPU", this.NOT1.getOutPin(0)));
        result.add(new Element<String, Pin>("hack", this.AND2.getOutPin(0)));
        return result;
    }

    public REG RegMAR() {
        return this.MAR;
    }

    public REG RegMDR() {
        return this.MDR;
    }

    public REG RegDWH() {
        return this.DWH;
    }

    public REG RegDWL() {
        return this.DWL;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        result.add(new Element<String, REG>("MAR", this.MAR));
        result.add(new Element<String, REG>("MDR", this.MDR));
        result.add(new Element<String, REG>("DWH", this.DWH));
        result.add(new Element<String, REG>("DWL", this.DWL));
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validate() {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        Bus1.testRange(result, "dataSize", Parameters.dataSizeString, Messages.getString("Parameters.ErrorSirina"), false, 8, 16);
        Bus1.testRange(result, "memdelay", Parameters.memdelayString, Messages.getString("Parameters.ErrorKasnjenjeMemorije"), true, 0, 256);
        Bus1.testRange(result, "addressableUnit", Parameters.addressableUnitString, Messages.getString("Parameters.ErrorAdresibilnaJedinica"), false, 8, 16);
        Bus1.testRange(result, "numberOfRegisters", Parameters.numberOfRegistersString, Messages.getString("Parameters.ErrorBrojRegistara"), false, 0, 2, 4, 8, 16, 32, 64);
        Bus1.testRange(result, "GPRARStartPosition", Parameters.GPRARStartPositionString, Messages.getString("Parameters.ErrorStartPosition"), true, 0, 32);
        Bus1.testRange(result, "GPRNumberOfBits", Parameters.GPRNumberOfBitsString, Messages.getString("Parameters.ErrorBrojBitaZaRegs"), true, 0, 6);
        return result;
    }

    private static void testRange(List<Element<String[], ValidationElement>> result, String name, String sizeVal, String error, boolean interval, int ... vals) {
        int val = Integer.parseInt(sizeVal);
        if (interval) {
            if (vals[0] > val || val > vals[1]) {
                ValidationElement vElement = new ValidationElement(3, String.valueOf(error) + " :" + val);
                Element<String[], ValidationElement> element = new Element<String[], ValidationElement>(new String[]{name, sizeVal}, vElement);
                result.add(element);
            }
        } else {
            boolean ok = false;
            int[] nArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (val == i) {
                    ok = true;
                    break;
                }
                ++n2;
            }
            if (!ok) {
                ValidationElement vElement = new ValidationElement(3, String.valueOf(error) + " :" + val);
                Element<String[], ValidationElement> element = new Element<String[], ValidationElement>(new String[]{name, sizeVal}, vElement);
                result.add(element);
            }
        }
    }
}

