/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiLine;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.ADD;
import logic.components.CLK;
import logic.components.GPR;
import logic.components.IntToInt;
import logic.components.REG;
import logic.components.TSB;
import shemes.AbstractSchema;
import shemes.components.Bus1;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class Adr1
extends AbstractSchema {
    public static final String DNAME = "Adr1";
    private IntToInt IBUS1ToGPRAR;
    private REG GPRAR;
    private GPR GPRegs;
    private TSB TSBGPRout1;
    private REG SP;
    private TSB TSBSPout2;
    private ADD ADDadr;
    private REG CW;
    private TSB TSBADDout2;
    private TSB TSBCWout3;

    public Adr1() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("Adr1.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.IBUS1ToGPRAR = new IntToInt(Parameters.sizeIBUS1, Parameters.GPRNumberOfBits, false, false, Parameters.GPRARStartPosition);
        this.GPRAR = new REG(1, "GPRAR");
        this.GPRAR.getOutPin(0).setIsInt();
        this.GPRAR.getOutPin(0).setNumOfLines(Parameters.GPRNumberOfBits);
        this.GPRAR.initVal(Parameters.valGPRAR);
        this.GPRegs = new GPR(Parameters.numberOfRegisters, Parameters.sizeR);
        this.GPRegs.getOutPin(0).setNumOfLines(Parameters.sizeR);
        this.TSBGPRout1 = new TSB("GPRout1");
        this.TSBGPRout1.getOutPin(0).setNumOfLines(Parameters.sizeIBUS1);
        this.SP = new REG(1, "SP");
        this.SP.getOutPin(0).setIsInt();
        this.SP.getOutPin(0).setNumOfLines(Parameters.sizeSP);
        this.SP.initVal(Parameters.valSP);
        this.TSBSPout2 = new TSB("SPout2");
        this.TSBSPout2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.ADDadr = new ADD();
        this.ADDadr.getOutPin(0).setIsInt();
        this.ADDadr.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.CW = new REG(1, "CW");
        this.CW.getOutPin(0).setIsInt();
        this.CW.getOutPin(0).setNumOfLines(Parameters.sizeCW);
        this.CW.initVal(Parameters.valCW);
        this.TSBCWout3 = new TSB("CWout3");
        this.TSBCWout3.getOutPin(0).setNumOfLines(Parameters.sizeIBUS3);
        this.TSBADDout2 = new TSB("ADDout2");
        this.TSBADDout2.getOutPin(0).setNumOfLines(Parameters.sizeIBUS2);
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.IBUS1ToGPRAR.setInPin(0, NameConnector.getPin("Bus1.IBUS1"));
        this.GPRAR.setInPin(0, this.IBUS1ToGPRAR.getOutPin(0));
        this.GPRAR.setPinLd(NameConnector.getPin("Oper1.ldGPRAR"));
        this.GPRAR.setPinInc(NameConnector.getPin("Oper1.incGPRAR"));
        this.GPRAR.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.GPRegs.setAdressPin(this.GPRAR.getOutPin(0));
        this.GPRegs.setInputDataPin(NameConnector.getPin("Bus1.IBUS3"));
        this.GPRegs.setWrite(NameConnector.getPin("Oper1.wrGPR"));
        this.GPRegs.setRead(new Pin(true, "1"));
        this.GPRegs.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBGPRout1.setInPin(0, this.GPRegs.getOutPin(0));
        this.TSBGPRout1.setE(NameConnector.getPin("Oper1.GPRout1"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS1(this.TSBGPRout1.getOutPin(0));
        this.SP.setInPin(0, NameConnector.getPin("Bus1.IBUS3"));
        this.SP.setPinInc(NameConnector.getPin("Oper1.incSP"));
        this.SP.setPinDec(NameConnector.getPin("Oper1.decSP"));
        this.SP.setPinLd(NameConnector.getPin("Oper1.ldSP"));
        this.SP.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBSPout2.setInPin(0, this.SP.getOutPin(0));
        this.TSBSPout2.setE(NameConnector.getPin("Oper1.SPout2"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS2(this.TSBSPout2.getOutPin(0));
        this.CW.setInPin(0, NameConnector.getPin("Bus1.IBUS2"));
        this.CW.setPinLd(NameConnector.getPin("Oper1.ldCW"));
        this.CW.setClk((CLK)NameConnector.getComponent("CPUCLK"));
        this.TSBCWout3.setInPin(0, this.CW.getOutPin(0));
        this.TSBCWout3.setE(NameConnector.getPin("Oper1.CWout3"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS3(this.TSBCWout3.getOutPin(0));
        this.ADDadr.setPinA(NameConnector.getPin("Bus1.IBUS1"));
        this.ADDadr.setPinB(NameConnector.getPin("Bus1.IBUS3"));
        this.TSBADDout2.setInPin(0, this.ADDadr.getOutPin(0));
        this.TSBADDout2.setE(NameConnector.getPin("Oper1.ADDout2"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnIBUS2(this.TSBADDout2.getOutPin(0));
    }

    @Override
    public void initGui() {
        int[][] section2;
        int[][] section1;
        this.gui = new GuiComponent("src/images/Adr1.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(589, 7));
        points.add(new Point(589, 736));
        sections.add(points);
        GuiLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(570, 22));
        points.add(new Point(570, 721));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(551, 37));
        points.add(new Point(551, 705));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 93));
        points.add(new Point(242, 74));
        points.add(new Point(588, 74));
        sections.add(points);
        line = new GuiPinLine(sections, this.IBUS1ToGPRAR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(160, 103));
        points.add(new Point(167, 103));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.incGPRAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(160, 121));
        points.add(new Point(167, 121));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldGPRAR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(317, 112));
        points.add(new Point(324, 112));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 131));
        points.add(new Point(242, 213));
        points.add(new Point(268, 213));
        sections.add(points);
        line = new GuiPinLine(sections, this.GPRAR.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(419, 213));
        points.add(new Point(426, 213));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.wrGPR"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(344, 251));
        points.add(new Point(344, 279));
        points.add(new Point(412, 279));
        sections.add(points);
        line = new GuiPinLine(sections, this.GPRegs.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(423, 284));
        points.add(new Point(423, 290));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.GPRout1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(435, 279));
        points.add(new Point(589, 279));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBGPRout1.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(325, 334));
        points.add(new Point(325, 315));
        points.add(new Point(551, 315));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 343));
        points.add(new Point(250, 343));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.incSP"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 362));
        points.add(new Point(250, 362));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.decSP"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(400, 343));
        points.add(new Point(407, 343));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldSP"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(400, 362));
        points.add(new Point(407, 362));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(325, 371));
        points.add(new Point(325, 400));
        points.add(new Point(412, 400));
        sections.add(points);
        line = new GuiPinLine(sections, this.SP.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(423, 404));
        points.add(new Point(423, 411));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.SPout2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(434, 400));
        points.add(new Point(570, 400));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBSPout2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(325, 655));
        points.add(new Point(325, 676));
        points.add(new Point(570, 676));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 646));
        points.add(new Point(250, 646));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldCW"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(242, 627));
        points.add(new Point(250, 627));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Procesor.CPUCLK"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(325, 618));
        points.add(new Point(325, 580));
        points.add(new Point(412, 580));
        sections.add(points);
        line = new GuiPinLine(sections, this.CW.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(325, 486));
        points.add(new Point(325, 447));
        points.add(new Point(412, 447));
        sections.add(points);
        line = new GuiPinLine(sections, this.ADDadr.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(423, 452));
        points.add(new Point(423, 458));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ADDout2"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(433, 447));
        points.add(new Point(570, 447));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBADDout2.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(433, 580));
        points.add(new Point(551, 580));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBCWout3.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(423, 585));
        points.add(new Point(423, 591));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Oper1.ldCW"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(287, 522));
        points.add(new Point(287, 553));
        points.add(new Point(551, 553));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(363, 522));
        points.add(new Point(363, 541));
        points.add(new Point(589, 541));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(344, 176));
        points.add(new Point(344, 150));
        points.add(new Point(551, 150));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.IBUS3"));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(593, 37, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(384, 536, NameConnector.getPin("Bus1.IBUS1")));
        this.gui.addDrawable(new GuiPinLabel(572, 54, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(500, 671, NameConnector.getPin("Bus1.IBUS2")));
        this.gui.addDrawable(new GuiPinLabel(521, 115, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(441, 146, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(494, 311, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(293, 548, NameConnector.getPin("Bus1.IBUS3")));
        this.gui.addDrawable(new GuiPinLabel(338, 71, this.IBUS1ToGPRAR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(223, 170, this.GPRAR.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(336, 294, this.GPRegs.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(487, 275, this.TSBGPRout1.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(336, 418, this.SP.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(460, 385, this.TSBSPout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(460, 435, this.TSBADDout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(336, 445, this.ADDadr.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(500, 441, this.TSBADDout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(500, 395, this.TSBSPout2.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(500, 576, this.TSBCWout3.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(336, 574, this.CW.getOutPin(0)));
        this.gui.addDrawable(new GuiTextLabel(231, 88, "" + Parameters.GPRNumberOfBits, 12));
        this.gui.addDrawable(new GuiTextLabel(231, 150, "" + Parameters.GPRNumberOfBits, 12));
        if (Parameters.GPRNumberOfBits > 0) {
            this.gui.addDrawable(new GuiTextLabel(279, 71, String.valueOf(Parameters.GPRARStartPosition + Parameters.GPRNumberOfBits - 1) + ".." + Parameters.GPRARStartPosition, 10));
            this.gui.addDrawable(new GuiTextLabel(294, 154, String.valueOf(Parameters.GPRARStartPosition + Parameters.GPRNumberOfBits - 1) + ".." + Parameters.GPRARStartPosition, 10));
            this.gui.addDrawable(new GuiTextLabel(281, 221, String.valueOf(Parameters.GPRARStartPosition + Parameters.GPRNumberOfBits - 1) + ".." + Parameters.GPRARStartPosition, 10));
        } else {
            section1 = new int[][]{{166, 71}, {319, 145}};
            line = new GuiLine(section1, Color.RED, 3.0f);
            this.gui.addDrawable(line);
            section2 = new int[][]{{166, 145}, {319, 71}};
            line = new GuiLine(section2, Color.RED, 3.0f);
            this.gui.addDrawable(line);
        }
        if (Parameters.numberOfRegisters == 0) {
            section1 = new int[][]{{255, 158}, {421, 265}};
            line = new GuiLine(section1, Color.RED, 3.0f);
            this.gui.addDrawable(line);
            section2 = new int[][]{{255, 265}, {421, 158}};
            line = new GuiLine(section2, Color.RED, 3.0f);
            this.gui.addDrawable(line);
        }
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("SP", this.SP.getOutPin(0)));
        result.add(new Element<String, Pin>("CW", this.CW.getOutPin(0)));
        result.add(new Element<String, Pin>("GPRAR", this.GPRAR.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        int i = 0;
        while (i < this.GPRegs.getSize()) {
            result.add(new Element<String, REG>("R[" + i + "]", this.GPRegs.getREG(i)));
            ++i;
        }
        result.add(new Element<String, REG>("GPRAR", this.GPRAR));
        result.add(new Element<String, REG>("SP", this.SP));
        result.add(new Element<String, REG>("CW", this.CW));
        return result;
    }

    public int readGPR(int adress) {
        return this.GPRegs.read(adress);
    }

    public GPR GPR() {
        return this.GPRegs;
    }

    public REG RegGPRAR() {
        return this.GPRAR;
    }

    public REG RegSP() {
        return this.SP;
    }

    public REG RegCW() {
        return this.CW;
    }
}

