/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui.Drawable;
import gui.GuiComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import util.Log;

public class WorkingPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    Map<GuiComponent, GuiPanel> panels = new HashMap<GuiComponent, GuiPanel>();
    GuiPanel currentPanel;

    public WorkingPanel(GuiComponent gui) {
        GuiPanel panel = new GuiPanel(gui);
        this.panels.put(gui, panel);
        this.setViewportView(panel);
        this.currentPanel = panel;
    }

    public void changeSchema(GuiComponent gui) {
        GuiPanel panel = this.panels.get(gui);
        if (panel == null) {
            panel = new GuiPanel(gui);
            this.panels.put(gui, panel);
        }
        this.setViewportView(panel);
        this.currentPanel = panel;
    }

    public void update(boolean validate) {
        if (validate) {
            this.currentPanel.validate();
        }
        this.currentPanel.repaint();
    }

    class GuiPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BufferedImage image;
        private File imagefile;
        private GuiComponent guiComponent;

        public GuiPanel(GuiComponent guiComponent) {
            this.setBackground(Color.WHITE);
            this.guiComponent = guiComponent;
            this.imagefile = new File(guiComponent.getFileName());
            try {
                this.image = ImageIO.read(this.imagefile);
            }
            catch (IOException e) {
                Log.errorLog("Missing file: " + this.imagefile.getAbsolutePath());
            }
            Dimension guiDimension = guiComponent.calcDimension();
            Dimension dim = new Dimension(Math.max(guiDimension.width, this.image.getWidth()), Math.max(guiDimension.height, this.image.getHeight()));
            this.adjustSize(dim);
        }

        @Override
        public void paint(Graphics g) {
            this.clearPanel(g);
            g.drawImage(this.image, 0, 0, null);
            for (Drawable gl : this.guiComponent.getDrawables()) {
                gl.draw(g);
            }
            this.getToolkit().sync();
        }

        public void clearPanel(Graphics g) {
            Color tmp = g.getColor();
            Dimension size = this.getParent().getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, Math.max(this.getWidth(), (int)size.getWidth()), Math.max(this.getHeight(), (int)size.getHeight()));
            g.setColor(tmp);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void adjustSize(Dimension size) {
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setPreferredSize(size);
            this.setSize(size);
            this.validate();
        }
    }
}

