/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import main.SimulatorActions;

public class UndoRedo {
    String documentTitle;
    int operationCnt;
    protected UndoHandler undoHandler = new UndoHandler();
    protected UndoManager undoManager = new UndoManager();
    private UndoAction undoAction = null;
    private RedoAction redoAction = null;

    public UndoRedo(String documentTitle) {
        this.documentTitle = documentTitle;
        this.operationCnt = 0;
    }

    public void undoredo(JTextComponent area) {
        KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 128);
        KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 128);
        this.undoAction = new UndoAction();
        area.getInputMap().put(undoKeystroke, "undoKeystroke");
        area.getActionMap().put("undoKeystroke", this.undoAction);
        this.redoAction = new RedoAction();
        area.getInputMap().put(redoKeystroke, "redoKeystroke");
        area.getActionMap().put("redoKeystroke", this.redoAction);
        this.undoAction.addPropertyChangeListener(SimulatorActions.simulatorActions);
        this.redoAction.addPropertyChangeListener(SimulatorActions.simulatorActions);
        Document document = area.getDocument();
        document.addUndoableEditListener(this.undoHandler);
    }

    public void reset() {
        this.undoManager.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedo.this.undoManager.redo();
                ++UndoRedo.this.operationCnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
            UndoRedo.this.undoAction.update();
        }

        protected void update() {
            if (UndoRedo.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", UndoRedo.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
                this.putValue("No redo", UndoRedo.this.documentTitle);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedo.this.undoManager.undo();
                --UndoRedo.this.operationCnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
            UndoRedo.this.redoAction.update();
        }

        protected void update() {
            if (UndoRedo.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", UndoRedo.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
            if (UndoRedo.this.operationCnt == 0) {
                this.putValue("No undo", UndoRedo.this.documentTitle);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            ++UndoRedo.this.operationCnt;
            UndoRedo.this.undoManager.addEdit(e.getEdit());
            UndoRedo.this.undoAction.update();
            UndoRedo.this.redoAction.update();
        }
    }
}

