/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import logic.Execution;
import main.CommandStatusPanel;
import main.Main;
import shemes.Schema;
import util.Element;
import util.Loader;
import util.Log;
import util.NameConnector;
import util.Parameters;

public class SimulatorActions
implements PropertyChangeListener {
    public static final String NOUNDO = "No undo";
    public static final String NOREDO = "No redo";
    public static SimulatorActions simulatorActions = new SimulatorActions();
    private static final int MAX = 2000;

    public static void showMemory() {
        Main.dialogMem.pack();
        Main.dialogMem.setVisible(true);
        Main.centralPanel.update(false);
        Main.mainWindow.update();
    }

    public static void showRegisters() {
        Main.dialogRegs.pack();
        Main.dialogRegs.setVisible(true);
        Main.centralPanel.update(false);
        Main.mainWindow.update();
    }

    public static void showFlipFlops() {
        Main.dialogFlipflops.pack();
        Main.dialogFlipflops.setVisible(true);
        Main.centralPanel.update(false);
        Main.mainWindow.update();
    }

    public static void resetNoMemory() {
        Execution.init(false);
        Main.eastPanel.reset();
        Main.mainWindow.update();
    }

    public static void resetAll() {
        Execution.init(true);
        Main.eastPanel.reset();
        Main.mainWindow.update();
    }

    public static void close() {
        boolean changed = Main.parameterEditorPanel.changed;
        boolean bl = changed = changed || Main.microcodeEditorPanel.changed;
        if (changed) {
            String theMessage = "Configuration has been modified. Save changes?";
            int result = JOptionPane.showConfirmDialog(null, theMessage, "Save Resource", 1);
            switch (result) {
                case 0: {
                    SimulatorActions.save();
                    System.exit(0);
                    break;
                }
                case 1: {
                    System.exit(0);
                    break;
                }
            }
        } else {
            System.exit(0);
        }
    }

    public static void loadMemoryAction(String path) {
        Loader.loadMemory(path);
        Main.mainWindow.update();
    }

    public static void storeMemoryAction(String path) {
        Loader.storeMemory(path);
    }

    public static void loadAllAction(String path) {
        Loader.loadAll(path);
        Main.mainWindow.update();
    }

    public static void storeAllAction(String path) {
        Loader.storeAll(path);
    }

    public static void gotoTimeAction(String time) {
        CommandStatusPanel csp = Main.getCommandStatusPanel();
        try {
            int n = Integer.parseInt(time);
            if (n < 0) {
                return;
            }
            if (n < Execution.globalTime) {
                Execution.init(false);
                csp.updateLabels();
                csp.updateCUContext();
                csp.enableNext();
            }
            while (NameConnector.getPin("Exec2.START").getBoolVal() && Execution.globalTime < n) {
                SimulatorActions.nextClk();
                csp.updateLabels();
                csp.updateCUContext();
            }
            csp.validateNext();
            Main.centralPanel.update(true);
            Main.mainWindow.update();
        }
        catch (NumberFormatException e) {}
        finally {
            return;
        }
    }

    public static void gotoProgramEndAction() {
        CommandStatusPanel csp = Main.getCommandStatusPanel();
        int cnt = 0;
        while (NameConnector.getPin("Exec2.START").getBoolVal() && cnt++ < 2000) {
            SimulatorActions.nextClk();
            csp.updateLabels();
            csp.updateCUContext();
        }
        csp.validateNext();
        Main.centralPanel.update(true);
        Main.mainWindow.update();
    }

    public static void gotoNextInstructionAction() {
        CommandStatusPanel csp = Main.getCommandStatusPanel();
        SimulatorActions.nextClk();
        csp.updateLabels();
        csp.updateCUContext();
        csp.validateNext();
        Main.centralPanel.update(true);
        SimulatorActions.nextClk();
        csp.updateLabels();
        csp.updateCUContext();
        csp.validateNext();
        Main.centralPanel.update(true);
        while (NameConnector.getPin("Counter.mPC").getIntVal() != 0 && NameConnector.getPin("Exec2.START").getBoolVal()) {
            SimulatorActions.nextClk();
            csp.updateLabels();
            csp.updateCUContext();
        }
        csp.validateNext();
        Main.centralPanel.update(true);
        Main.mainWindow.update();
    }

    public static void gotoNextClkAction() {
        CommandStatusPanel csp = Main.getCommandStatusPanel();
        SimulatorActions.nextClk();
        csp.updateLabels();
        csp.updateCUContext();
        csp.validateNext();
        Main.centralPanel.update(true);
        Main.mainWindow.update();
    }

    public static void gotoSignalChangeAction(List<Element<String, Integer>> signals) {
        CommandStatusPanel csp = Main.getCommandStatusPanel();
        int cnt = 0;
        while (NameConnector.getPin("Exec2.START").getBoolVal() && cnt++ < 2000) {
            SimulatorActions.nextClk();
            csp.updateLabels();
            csp.updateCUContext();
        }
        csp.validateNext();
        Main.centralPanel.update(true);
        Main.mainWindow.update();
    }

    protected static void nextClk() {
        try {
            Execution.nextCLK();
        }
        catch (Throwable e) {
            Log.errorDialog("Infinite loop ocured");
        }
    }

    public static void reload() {
        boolean changed = Main.parameterEditorPanel.changed;
        boolean bl = changed = changed || Main.microcodeEditorPanel.changed;
        if (changed) {
            SimulatorActions.refreshAll();
        } else {
            Main.load();
        }
    }

    public static void refreshAll() {
        boolean changed = Main.parameterEditorPanel.changed;
        if (changed) {
            Map<Schema, String> valsS = Main.parameterEditorPanel.getConfiguration();
            HashMap<String, String> vals = new HashMap<String, String>();
            for (Schema s : valsS.keySet()) {
                if (s == null) continue;
                vals.put(s.getName(), valsS.get(s));
            }
            Parameters.setVals(vals);
        }
        if (changed = Main.microcodeEditorPanel.changed) {
            String[] texts;
            String text = Main.microcodeEditorPanel.original.getText();
            LinkedList<String> lines = new LinkedList<String>();
            String[] stringArray = texts = text.split("\r\n");
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                lines.add(s);
                ++n2;
            }
            Parameters.setMicrocode(lines);
        }
        Main.load();
    }

    public static void save() {
        SimulatorActions.refreshAll();
        SimulatorActions.saveConfiguration();
        SimulatorActions.saveMicrocode();
    }

    public static void saveConfiguration() {
        boolean changed = Main.parameterEditorPanel.changed;
        if (changed) {
            SimulatorActions.saveAsConfiguration(Parameters.configurationFile, Parameters.configurationFile);
        }
    }

    public static void saveAsConfiguration(String name) {
        SimulatorActions.refreshAll();
        SimulatorActions.saveAsConfiguration(Parameters.configurationFile, name);
    }

    private static void saveAsConfiguration(String oldName, String newName) {
        Parameters.saveConfiguration(oldName, newName);
        Main.parameterEditorPanel.changed = false;
        String titleConfiguration = Main.southPanel.getTitleAt(Main.editorPanelId);
        if (titleConfiguration.endsWith("*")) {
            titleConfiguration = titleConfiguration.substring(0, titleConfiguration.length() - 1);
            Main.southPanel.setTitleAt(Main.editorPanelId, titleConfiguration);
        }
    }

    public static void saveMicrocode() {
        boolean changed = Main.microcodeEditorPanel.changed;
        if (changed) {
            SimulatorActions.saveAsMicrocode(Parameters.microprogramFile, Parameters.microprogramFile);
        }
    }

    public static void saveAsMicrocode(String name) {
        SimulatorActions.refreshAll();
        SimulatorActions.saveAsMicrocode(Parameters.microprogramFile, name);
    }

    private static void saveAsMicrocode(String oldName, String newName) {
        Parameters.saveMicrocode(oldName, newName);
        Main.microcodeEditorPanel.changed = false;
        String titleConfiguration = Main.southPanel.getTitleAt(Main.microcodePanelId);
        if (titleConfiguration.endsWith("*")) {
            titleConfiguration = titleConfiguration.substring(0, titleConfiguration.length() - 1);
            Main.southPanel.setTitleAt(Main.microcodePanelId, titleConfiguration);
        }
    }

    public static void changeSchema(Schema newSchema) {
        Main.currentScheme = newSchema;
        Main.centralPanel.changeSchema(newSchema.getGui());
        Main.threePanel.changeSchema(newSchema);
        Main.parameterEditorPanel.changeSchema(newSchema);
    }

    public static void configurationChanged() {
        String titleConfiguration = Main.southPanel.getTitleAt(Main.editorPanelId);
        if (!titleConfiguration.endsWith("*")) {
            titleConfiguration = String.valueOf(titleConfiguration) + "*";
            Main.southPanel.setTitleAt(Main.editorPanelId, titleConfiguration);
        }
    }

    public static void setErrorLogFlag(boolean val) {
        String titleConfiguration = Main.southPanel.getTitleAt(Main.errorPanelId);
        if (val || !Main.errorArea.getText().equals("")) {
            if (!titleConfiguration.endsWith("*")) {
                titleConfiguration = String.valueOf(titleConfiguration) + "*";
                Main.southPanel.setTitleAt(Main.errorPanelId, titleConfiguration);
            }
        } else if (titleConfiguration.endsWith("*")) {
            titleConfiguration = titleConfiguration.substring(0, titleConfiguration.length() - 1);
            Main.southPanel.setTitleAt(Main.errorPanelId, titleConfiguration);
        }
    }

    public static void addErrorMessage(String message) {
        SimulatorActions.setErrorLogFlag(true);
        Log.errorLog(message);
    }

    public static void microcodeChanged() {
        String titleConfiguration = Main.southPanel.getTitleAt(Main.microcodePanelId);
        if (!titleConfiguration.endsWith("*")) {
            titleConfiguration = String.valueOf(titleConfiguration) + "*";
            Main.southPanel.setTitleAt(Main.microcodePanelId, titleConfiguration);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl34 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl34 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

