/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import main.Main;
import main.SimulatorActions;
import util.Messages;

public class SimMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenu fileMenu = new JMenu();
    private JMenuItem loadMemoryItem = new JMenuItem();
    private JMenuItem storeMemoryItem = new JMenuItem();
    private JMenuItem loadAllItem = new JMenuItem();
    private JMenuItem storeAllItem = new JMenuItem();
    private JMenuItem saveConfigurationItem = new JMenuItem();
    private JMenuItem saveAsConfigurationItem = new JMenuItem();
    private JMenuItem saveAsMicrocodeItem = new JMenuItem();
    private JMenuItem reloadItem = new JMenuItem();
    private JMenuItem closeItem = new JMenuItem();
    private JMenu viewMenu = new JMenu();
    private JMenuItem timeDiagramItem = new JMenuItem();
    private JMenuItem memoryItem = new JMenuItem();
    private JMenuItem registersItem = new JMenuItem();
    private JMenuItem flipflopsItem = new JMenuItem();
    private JMenu runMenu = new JMenu();
    private JMenuItem nextClkItem = new JMenuItem();
    private JMenuItem nextInstructionItem = new JMenuItem();
    private JMenuItem nextProgramItem = new JMenuItem();
    private JMenuItem resetAllItem = new JMenuItem();
    private JMenuItem resetItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem aboutItem = new JMenuItem();

    public SimMenu() {
        this.createMenu();
    }

    private void createMenu() {
        this.creaateFileMenu();
        this.createViewMenu();
        this.createRunMenu();
        this.createHelpMenu();
    }

    public void creaateFileMenu() {
        this.fileMenu.setText(Messages.getString("SimMenu.File"));
        this.loadMemoryItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.loadMemoryItem.setText(Messages.getString("SimMenu.Load_memory"));
        this.loadMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showOpenDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.loadMemoryAction(path);
                }
            }
        });
        this.fileMenu.add(this.loadMemoryItem);
        this.storeMemoryItem.setText(Messages.getString("SimMenu.Store_memory"));
        this.storeMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showSaveDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.storeMemoryAction(path);
                }
            }
        });
        this.fileMenu.add(this.storeMemoryItem);
        this.loadAllItem.setText(Messages.getString("SimMenu.Load_All"));
        this.loadAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showOpenDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.loadAllAction(path);
                }
            }
        });
        this.storeAllItem.setText(Messages.getString("SimMenu.Store_All"));
        this.storeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showSaveDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.storeAllAction(path);
                }
            }
        });
        this.fileMenu.addSeparator();
        this.saveConfigurationItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveConfigurationItem.setText(Messages.getString("SimMenu.Save"));
        this.saveConfigurationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.save();
            }
        });
        this.fileMenu.add(this.saveConfigurationItem);
        this.saveAsConfigurationItem.setText(Messages.getString("SimMenu.SaveAsConfiguration"));
        this.saveAsConfigurationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showSaveDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.saveAsConfiguration(path);
                }
            }
        });
        this.fileMenu.add(this.saveAsConfigurationItem);
        this.saveAsMicrocodeItem.setText(Messages.getString("SimMenu.SaveAsMicrocode"));
        this.saveAsMicrocodeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser jc = new JFileChooser(".//");
                int fStatus = jc.showSaveDialog(SimMenu.this);
                if (fStatus == 0) {
                    String path = jc.getSelectedFile().getPath();
                    SimulatorActions.saveAsMicrocode(path);
                }
            }
        });
        this.fileMenu.add(this.saveAsMicrocodeItem);
        this.reloadItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.reloadItem.setText(Messages.getString("SimMenu.Reload"));
        this.reloadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.reload();
            }
        });
        this.fileMenu.add(this.reloadItem);
        this.closeItem.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        this.closeItem.setText(Messages.getString("SimMenu.Close"));
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.close();
            }
        });
        this.fileMenu.add(this.closeItem);
        this.add(this.fileMenu);
    }

    public void createViewMenu() {
        this.viewMenu.setText(Messages.getString("SimMenu.View"));
        this.timeDiagramItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.timeDiagramItem.setText(Messages.getString("SimMenu.Time_Diagram"));
        this.timeDiagramItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.dialogSignals.setVisible(true);
            }
        });
        this.viewMenu.add(this.timeDiagramItem);
        this.memoryItem.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        this.memoryItem.setText(Messages.getString("SimMenu.Memory"));
        this.memoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.showMemory();
            }
        });
        this.viewMenu.add(this.memoryItem);
        this.registersItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.registersItem.setText(Messages.getString("SimMenu.Registers"));
        this.registersItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.showRegisters();
            }
        });
        this.viewMenu.add(this.registersItem);
        this.flipflopsItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.flipflopsItem.setText(Messages.getString("SimMenu.Flip-flops"));
        this.flipflopsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.showFlipFlops();
            }
        });
        this.viewMenu.add(this.flipflopsItem);
        this.add(this.viewMenu);
    }

    public void createRunMenu() {
        this.runMenu.setText(Messages.getString("SimMenu.Run"));
        this.nextClkItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.nextClkItem.setText(Messages.getString("SimMenu.Next_clk"));
        this.nextClkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.gotoNextClkAction();
            }
        });
        this.runMenu.add(this.nextClkItem);
        this.nextInstructionItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.nextInstructionItem.setText(Messages.getString("SimMenu.Next_instruction"));
        this.nextInstructionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.gotoNextInstructionAction();
            }
        });
        this.runMenu.add(this.nextInstructionItem);
        this.nextProgramItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.nextProgramItem.setText(Messages.getString("SimMenu.Next_program"));
        this.nextProgramItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.gotoProgramEndAction();
            }
        });
        this.runMenu.add(this.nextProgramItem);
        this.resetAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 512));
        this.resetAllItem.setText(Messages.getString("SimMenu.ResetAll"));
        this.resetAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.resetAll();
            }
        });
        this.runMenu.add(this.resetAllItem);
        this.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, 512));
        this.resetItem.setText(Messages.getString("SimMenu.Reset"));
        this.resetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulatorActions.resetNoMemory();
            }
        });
        this.runMenu.add(this.resetItem);
        this.add(this.runMenu);
    }

    public void createHelpMenu() {
        this.helpMenu.setText(Messages.getString("SimMenu.Help"));
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.aboutItem.setText(Messages.getString("SimMenu.Aboit"));
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.add(this.helpMenu);
    }
}

